/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.java.utils;

import com.silabs.java.internal.utils.ResultImpl;
import com.silabs.java.utils.Either;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;

public interface Result<R, E>
extends Either<R, E> {
    public static <R, E> Result<R, E> ok(R result) {
        return new ResultImpl<Object, Object>(result, null, () -> null);
    }

    public static <R, E> Result<R, E> err(E error, Supplier<R> defResult) {
        return new ResultImpl<Object, E>(null, error, defResult);
    }

    public static <R, E> Result<R, E> err(E error) {
        return new ResultImpl<Object, E>(null, error, () -> null);
    }

    default public Optional<R> mapError(Consumer<E> handler) {
        if (this.isLeft()) {
            return Optional.of(this.left());
        }
        handler.accept(this.right());
        return Optional.empty();
    }

    default public <E2> Result<R, E2> transformError(Function<E, E2> transform) {
        if (!this.isOK()) {
            return Result.err(transform.apply(this.error()));
        }
        Result casted = this;
        return casted;
    }

    default public <R2> Result<R2, E> mapResult(Function<R, R2> transform) {
        if (this.isOK()) {
            return Result.ok(transform.apply(this.okValue()));
        }
        Result casted = this;
        return casted;
    }

    public R defaultValue();

    default public E error() {
        return (E)this.right();
    }

    default public R okValue() {
        return (R)this.left();
    }

    default public boolean isOK() {
        return this.isLeft();
    }

    default public R unwrap(Consumer<E> issueHandler) {
        return (R)Result.unwrapInternal(this, () -> this.defaultValue(), issueHandler);
    }

    default public R unwrap(R defaultValue, Consumer<E> issueHandler) {
        return (R)Result.unwrapInternal(this, () -> defaultValue, issueHandler);
    }

    private static <R, E> R unwrapInternal(Result<R, E> self, Supplier<R> defaultValue, Consumer<E> issueHandler) {
        if (self.isLeft()) {
            return (R)self.left();
        }
        issueHandler.accept(self.right());
        return defaultValue.get();
    }

    default public <X extends Throwable> R unwrapOrThrow(Function<E, X> convert) throws X {
        if (this.isLeft()) {
            return (R)this.left();
        }
        throw (Throwable)convert.apply(this.error());
    }
}

