/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.java.utils;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.util.Collection;
import java.util.Set;

public class SafeObjectParser
implements AutoCloseable {
    private final SafeObjectInputStream stream;
    private ClassLoader clazzLoader;

    public SafeObjectParser(InputStream in, Collection<Class<?>> allowedClasses) throws IOException {
        this.stream = new SafeObjectInputStream(in);
        this.setAllowedClasses(allowedClasses);
    }

    public SafeObjectParser(InputStream in, Class<?> ... allowedClasses) throws IOException {
        this(in, Set.of(allowedClasses));
    }

    public SafeObjectParser setClassLoader(ClassLoader clazzLoader) {
        this.clazzLoader = clazzLoader;
        return this;
    }

    public ObjectInputStream getStream() {
        return this.stream;
    }

    public SafeObjectParser setAllowedClasses(Class<?> ... allowedClasses) {
        return this.setAllowedClasses(Set.of(allowedClasses));
    }

    public SafeObjectParser setAllowedClasses(Collection<Class<?>> allowedClasses) {
        this.stream.allowedClasses = allowedClasses;
        return this;
    }

    public <T> T load() throws ClassNotFoundException, IOException {
        return (T)this.stream.readObject();
    }

    @Override
    public void close() throws IOException {
        if (this.stream != null) {
            this.stream.close();
        }
    }

    protected class SafeObjectInputStream
    extends ObjectInputStream {
        private Collection<Class<?>> allowedClasses;

        protected SafeObjectInputStream(InputStream in) throws IOException {
            super(in);
        }

        @Override
        protected Class<?> resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
            Class<?> clazz;
            if (SafeObjectParser.this.clazzLoader != null) {
                try {
                    clazz = SafeObjectParser.this.clazzLoader.loadClass(desc.getName());
                }
                catch (ClassNotFoundException ex) {
                    clazz = super.resolveClass(desc);
                }
            } else {
                clazz = super.resolveClass(desc);
            }
            this.validateClass(clazz);
            return clazz;
        }

        private void validateClass(Class<?> clazz) {
            if (clazz.isArray()) {
                return;
            }
            if (clazz.equals(String.class)) {
                return;
            }
            if (Number.class.isAssignableFrom(clazz)) {
                return;
            }
            if (Boolean.class.isAssignableFrom(clazz)) {
                return;
            }
            if (this.allowedClasses != null) {
                if (this.allowedClasses.contains(clazz)) {
                    return;
                }
                if (this.allowedClasses.stream().anyMatch(c -> c.isAssignableFrom(clazz))) {
                    return;
                }
            }
            throw new SecurityException("Deserialized class is not in the allowed list: " + clazz);
        }
    }
}

