/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.java.utils;

import com.silabs.java.utils.log.Log;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.prefs.Preferences;

public class WinRegistry {
    public static final int HKEY_CURRENT_USER = -2147483647;
    public static final int HKEY_LOCAL_MACHINE = -2147483646;
    public static final long REG_SUCCESS = 0L;
    public static final long REG_NOTFOUND = 2L;
    public static final long REG_ACCESSDENIED = 5L;
    private static final int KEY_ALL_ACCESS = 983103;
    private static final int KEY_READ = 131097;
    private static Preferences userRoot = Preferences.userRoot();
    private static Preferences systemRoot = Preferences.systemRoot();
    private static Class<? extends Preferences> userClass = userRoot.getClass();
    private static Method regOpenKey = null;
    private static Method regCloseKey = null;
    private static Method regQueryValueEx = null;
    private static Method regEnumValue = null;
    private static Method regQueryInfoKey = null;
    private static Method regEnumKeyEx = null;
    private static Method regCreateKeyEx = null;
    private static Method regSetValueEx = null;
    private static Method regDeleteValue = null;
    private static Method regDeleteKey = null;

    private WinRegistry() {
    }

    private static long[] WindowsRegOpenKey(Preferences root, long hKey, byte[] subKey, int securityMask) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        return (long[])regOpenKey.invoke((Object)root, hKey, subKey, securityMask);
    }

    private static int WindowsRegCloseKey(Preferences root, long hKey) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        return (Integer)regCloseKey.invoke((Object)root, hKey);
    }

    private static byte[] WindowsRegQueryValueEx(Preferences root, long hKey, byte[] valueName) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        return (byte[])regQueryValueEx.invoke((Object)root, hKey, valueName);
    }

    private static byte[] WindowsRegEnumValue(Preferences root, long hKey, int valueIndex, int maxValueNameLength) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        return (byte[])regEnumValue.invoke((Object)root, hKey, valueIndex, maxValueNameLength);
    }

    private static long[] WindowsRegQueryInfoKey1(Preferences root, long hKey) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        return (long[])regQueryInfoKey.invoke((Object)root, hKey);
    }

    private static byte[] WindowsRegEnumKeyEx(Preferences root, long hKey, int subKeyIndex, int maxKeyLength) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        return (byte[])regEnumKeyEx.invoke((Object)root, hKey, subKeyIndex, maxKeyLength);
    }

    private static long[] WindowsRegCreateKeyEx(Preferences root, long hKey, byte[] subKey) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        return (long[])regCreateKeyEx.invoke((Object)root, hKey, subKey);
    }

    private static int WindowsRegSetValueEx(Preferences root, long hKey, byte[] valueName, byte[] value) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        return (Integer)regSetValueEx.invoke((Object)root, hKey, valueName, value);
    }

    private static int WindowsRegDeleteValue(Preferences root, long hKey, byte[] valueName) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        return (Integer)regDeleteValue.invoke((Object)root, hKey, valueName);
    }

    private static int WindowsRegDeleteKey(Preferences root, long hKey, byte[] subKey) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        return (Integer)regDeleteKey.invoke((Object)root, hKey, subKey);
    }

    public static String readString(int hkey, String key, String valueName) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        if (hkey == -2147483646) {
            return WinRegistry.readString(systemRoot, hkey, key, valueName);
        }
        if (hkey == -2147483647) {
            return WinRegistry.readString(userRoot, hkey, key, valueName);
        }
        throw new IllegalArgumentException("hkey=" + hkey);
    }

    public static Map<String, String> readStringValues(int hkey, String key) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        if (hkey == -2147483646) {
            return WinRegistry.readStringValues(systemRoot, hkey, key);
        }
        if (hkey == -2147483647) {
            return WinRegistry.readStringValues(userRoot, hkey, key);
        }
        throw new IllegalArgumentException("hkey=" + hkey);
    }

    public static List<String> readStringSubKeys(int hkey, String key) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        if (hkey == -2147483646) {
            return WinRegistry.readStringSubKeys(systemRoot, hkey, key);
        }
        if (hkey == -2147483647) {
            return WinRegistry.readStringSubKeys(userRoot, hkey, key);
        }
        throw new IllegalArgumentException("hkey=" + hkey);
    }

    public static void createKey(int hkey, String key) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        long[] ret;
        if (hkey == -2147483646) {
            ret = WinRegistry.createKey(systemRoot, hkey, key);
            WinRegistry.WindowsRegCloseKey(systemRoot, ret[0]);
        } else if (hkey == -2147483647) {
            ret = WinRegistry.createKey(userRoot, hkey, key);
            WinRegistry.WindowsRegCloseKey(userRoot, ret[0]);
        } else {
            throw new IllegalArgumentException("hkey=" + hkey);
        }
        if (ret[1] != 0L) {
            throw new IllegalArgumentException("rc=" + ret[1] + "  key=" + key);
        }
    }

    public static void writeStringValue(int hkey, String key, String valueName, String value) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        if (hkey == -2147483646) {
            WinRegistry.writeStringValue(systemRoot, hkey, key, valueName, value);
        } else if (hkey == -2147483647) {
            WinRegistry.writeStringValue(userRoot, hkey, key, valueName, value);
        } else {
            throw new IllegalArgumentException("hkey=" + hkey);
        }
    }

    public static void deleteKey(int hkey, String key) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        int rc = -1;
        if (hkey == -2147483646) {
            rc = WinRegistry.deleteKey(systemRoot, hkey, key);
        } else if (hkey == -2147483647) {
            rc = WinRegistry.deleteKey(userRoot, hkey, key);
        }
        if ((long)rc != 0L) {
            throw new IllegalArgumentException("rc=" + rc + "  key=" + key);
        }
    }

    public static void deleteValue(int hkey, String key, String value) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        long rc = -1L;
        if (hkey == -2147483646) {
            rc = WinRegistry.deleteValue(systemRoot, hkey, key, value);
        } else if (hkey == -2147483647) {
            rc = WinRegistry.deleteValue(userRoot, hkey, key, value);
        }
        if (rc != 0L) {
            throw new IllegalArgumentException("rc=" + rc + "  key=" + key + "  value=" + value);
        }
    }

    private static long deleteValue(Preferences root, int hkey, String key, String value) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        long[] handles = WinRegistry.WindowsRegOpenKey(root, hkey, WinRegistry.toCstr(key), 983103);
        if (handles[1] != 0L) {
            return handles[1];
        }
        int rc = WinRegistry.WindowsRegDeleteValue(root, handles[0], WinRegistry.toCstr(value));
        WinRegistry.WindowsRegCloseKey(root, handles[0]);
        return rc;
    }

    private static int deleteKey(Preferences root, int hkey, String key) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        int rc = WinRegistry.WindowsRegDeleteKey(root, hkey, WinRegistry.toCstr(key));
        return rc;
    }

    private static String readString(Preferences root, int hkey, String key, String value) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        long[] handles = WinRegistry.WindowsRegOpenKey(root, hkey, WinRegistry.toCstr(key), 131097);
        if (handles[1] != 0L) {
            return null;
        }
        byte[] valb = WinRegistry.WindowsRegQueryValueEx(root, handles[0], WinRegistry.toCstr(value));
        WinRegistry.WindowsRegCloseKey(root, handles[0]);
        return valb != null ? new String(valb).trim() : null;
    }

    private static Map<String, String> readStringValues(Preferences root, int hkey, String key) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        HashMap<String, String> results = new HashMap<String, String>();
        long[] handles = WinRegistry.WindowsRegOpenKey(root, hkey, WinRegistry.toCstr(key), 131097);
        if (handles[1] != 0L) {
            return null;
        }
        long[] info = WinRegistry.WindowsRegQueryInfoKey1(root, handles[0]);
        long count = info[0];
        int maxlen = (int)info[3];
        int index = 0;
        while ((long)index < count) {
            byte[] name = WinRegistry.WindowsRegEnumValue(root, handles[0], index, maxlen + 1);
            String value = WinRegistry.readString(hkey, key, new String(name));
            results.put(new String(name).trim(), value);
            ++index;
        }
        WinRegistry.WindowsRegCloseKey(root, handles[0]);
        return results;
    }

    private static List<String> readStringSubKeys(Preferences root, int hkey, String key) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        ArrayList<String> results = new ArrayList<String>();
        long[] handles = WinRegistry.WindowsRegOpenKey(root, hkey, WinRegistry.toCstr(key), 131097);
        if (handles[1] != 0L) {
            return null;
        }
        long[] info = WinRegistry.WindowsRegQueryInfoKey1(root, handles[0]);
        long count = info[0];
        int maxlen = (int)info[3];
        int index = 0;
        while ((long)index < count) {
            byte[] name = WinRegistry.WindowsRegEnumKeyEx(root, handles[0], index, maxlen + 1);
            results.add(new String(name).trim());
            ++index;
        }
        WinRegistry.WindowsRegCloseKey(root, handles[0]);
        return results;
    }

    private static long[] createKey(Preferences root, long hkey, String key) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        return WinRegistry.WindowsRegCreateKeyEx(root, hkey, WinRegistry.toCstr(key));
    }

    private static void writeStringValue(Preferences root, int hkey, String key, String valueName, String value) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        long[] handles = WinRegistry.WindowsRegOpenKey(root, hkey, WinRegistry.toCstr(key), 983103);
        WinRegistry.WindowsRegSetValueEx(root, handles[0], WinRegistry.toCstr(valueName), WinRegistry.toCstr(value));
        WinRegistry.WindowsRegCloseKey(root, handles[0]);
    }

    private static byte[] toCstr(String str) {
        byte[] result = new byte[str.length() + 1];
        for (int i = 0; i < str.length(); ++i) {
            result[i] = (byte)str.charAt(i);
        }
        result[str.length()] = 0;
        return result;
    }

    static {
        try {
            regOpenKey = userClass.getDeclaredMethod("WindowsRegOpenKey", Long.TYPE, byte[].class, Integer.TYPE);
            regOpenKey.setAccessible(true);
            regCloseKey = userClass.getDeclaredMethod("WindowsRegCloseKey", Long.TYPE);
            regCloseKey.setAccessible(true);
            regQueryValueEx = userClass.getDeclaredMethod("WindowsRegQueryValueEx", Long.TYPE, byte[].class);
            regQueryValueEx.setAccessible(true);
            regEnumValue = userClass.getDeclaredMethod("WindowsRegEnumValue", Long.TYPE, Integer.TYPE, Integer.TYPE);
            regEnumValue.setAccessible(true);
            regQueryInfoKey = userClass.getDeclaredMethod("WindowsRegQueryInfoKey1", Long.TYPE);
            regQueryInfoKey.setAccessible(true);
            regEnumKeyEx = userClass.getDeclaredMethod("WindowsRegEnumKeyEx", Long.TYPE, Integer.TYPE, Integer.TYPE);
            regEnumKeyEx.setAccessible(true);
            regCreateKeyEx = userClass.getDeclaredMethod("WindowsRegCreateKeyEx", Long.TYPE, byte[].class);
            regCreateKeyEx.setAccessible(true);
            regSetValueEx = userClass.getDeclaredMethod("WindowsRegSetValueEx", Long.TYPE, byte[].class, byte[].class);
            regSetValueEx.setAccessible(true);
            regDeleteValue = userClass.getDeclaredMethod("WindowsRegDeleteValue", Long.TYPE, byte[].class);
            regDeleteValue.setAccessible(true);
            regDeleteKey = userClass.getDeclaredMethod("WindowsRegDeleteKey", Long.TYPE, byte[].class);
            regDeleteKey.setAccessible(true);
        }
        catch (Exception e) {
            Log.error(e);
        }
    }
}

