/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.java.utils.log;

import com.silabs.java.utils.Time;
import com.silabs.java.utils.enums.Severity;
import com.silabs.java.utils.log.ILogger;
import com.silabs.java.utils.log.ITopicLogControl;
import com.silabs.java.utils.log.Log;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.List;

public final class TopicLog
implements ILogger {
    private static final long LOG_FILE_LIMIT_BYTES = 0x3200000L;
    private volatile PrintWriter writer;
    private final Object semaphore = new Object();
    private final String name;
    private final ITopicLogControl logControl;
    private boolean dontBother = false;

    public TopicLog(ITopicLogControl logControl, String name) {
        this.name = name;
        this.logControl = logControl;
    }

    public TopicLog(ITopicLogControl logControl) {
        this(logControl, "new");
    }

    public final void log(String text) {
        for (PrintWriter pw : this.readyToWrite()) {
            pw.println(this.ts() + text);
            pw.flush();
        }
    }

    public final void log(Throwable t) {
        for (PrintWriter pw : this.readyToWrite()) {
            pw.println(this.ts() + "Exception: " + t.getMessage());
            t.printStackTrace(pw);
            pw.flush();
        }
    }

    @Override
    public final void log(Severity severity, String message, Throwable throwable) {
        for (PrintWriter pw : this.readyToWrite()) {
            if (severity != null) {
                pw.println(this.ts() + severity.name() + ": " + message);
            }
            if (throwable != null) {
                throwable.printStackTrace(pw);
            }
            pw.flush();
        }
    }

    public final void log(String text, Throwable t) {
        for (PrintWriter pw : this.readyToWrite()) {
            if (text != null) {
                pw.println(this.ts() + text);
            }
            if (t != null) {
                pw.println(this.ts() + "Exception: " + t.getMessage());
                t.printStackTrace(pw);
            }
            pw.flush();
        }
    }

    public final void shutdown() {
        PrintWriter localWriter = this.writer;
        if (localWriter != null) {
            localWriter.close();
            this.writer = null;
        }
        this.logControl.consoleWriter().ifPresent(PrintWriter::close);
    }

    private String ts() {
        return Time.formatMillisecondDayTime(System.currentTimeMillis()) + ": ";
    }

    private List<PrintWriter> readyToWrite() {
        ArrayList<PrintWriter> writers = new ArrayList<PrintWriter>();
        PrintWriter consoleWriter = this.readyToWriteConsole();
        if (consoleWriter != null) {
            writers.add(consoleWriter);
        }
        if (this.readyToWriteFile()) {
            writers.add(this.writer);
        }
        return writers;
    }

    private PrintWriter readyToWriteConsole() {
        PrintWriter consoleWriter = this.logControl.consoleWriter().orElse(null);
        return this.logControl.isConsoleLoggingEnabled() ? consoleWriter : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean readyToWriteFile() {
        boolean ready;
        PrintWriter localWriter = this.writer;
        if (this.logControl.isLoggingEnabled()) {
            if (localWriter == null) {
                Object object = this.semaphore;
                synchronized (object) {
                    localWriter = this.writer;
                    if (localWriter == null) {
                        File logfile = this.logControl.resolvePath(false).toFile();
                        try {
                            if (logfile.exists() && logfile.length() > 0x3200000L) {
                                File backup = this.logControl.resolvePath(true).toFile();
                                if (backup.exists()) {
                                    Files.delete(backup.toPath());
                                }
                                if (!logfile.renameTo(backup)) {
                                    if (!this.dontBother) {
                                        this.dontBother = true;
                                        Log.error("Logging Disabled! Failed to move primary log to backup log for " + this.name + " at " + logfile);
                                    }
                                    localWriter = null;
                                    return false;
                                }
                            }
                            localWriter = new PrintWriter(new FileOutputStream(logfile, true));
                            localWriter.println(this.ts() + "Log started.");
                            localWriter.flush();
                            ready = true;
                        }
                        catch (Exception e) {
                            Log.error("Could not create " + this.name + " log at: " + logfile + ": " + e.getMessage());
                            localWriter = null;
                            ready = false;
                        }
                    } else {
                        ready = true;
                    }
                    this.writer = localWriter;
                }
            } else {
                ready = true;
            }
        } else {
            if (localWriter != null) {
                Object object = this.semaphore;
                synchronized (object) {
                    if (localWriter != null) {
                        localWriter.close();
                        this.writer = null;
                    }
                }
            }
            ready = false;
        }
        return ready;
    }

    public final File getPrimaryLogFile() {
        return this.logControl.resolvePath(false).toFile();
    }

    public final File getBackupLogFile() {
        return this.logControl.resolvePath(true).toFile();
    }
}

