/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.java.utils.preferences;

import com.silabs.java.utils.extension.Extension;
import com.silabs.java.utils.preferences.IPreferences;
import com.silabs.java.utils.preferences.IPreferencesProvider;
import java.util.stream.Collectors;

public class PreferenceUtils {
    private static final String EXTENSION_ID = "com.silabs.java.utils.studioPreferences";
    private static final String PROVIDER = "provider";
    private static IPreferencesProvider provider;

    public static IPreferences createForWorkspace(String prefsName) {
        PreferenceUtils.setupProvider();
        IPreferences prefs = provider.createForWorkspace(prefsName);
        return prefs;
    }

    public static IPreferences createForInstall(String prefsName) {
        PreferenceUtils.setupProvider();
        IPreferences prefs = provider.createForInstall(prefsName);
        return prefs;
    }

    private static void setupProvider() {
        if (provider != null) {
            return;
        }
        Extension.instance().extensions(EXTENSION_ID, m -> {
            if (PROVIDER.equals(m.getName())) {
                provider = (IPreferencesProvider)m.instantiateClass(m.getAttribute("class"));
            }
            return null;
        }).collect(Collectors.toList());
        if (provider == null) {
            throw new IllegalStateException("No preference provider!");
        }
    }
}

