/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.java.utils.variables;

import com.silabs.java.utils.variables.IVariableLookup;
import java.util.Collection;
import java.util.LinkedHashSet;

public class ChainedVariableLookup
implements IVariableLookup {
    private IVariableLookup first;
    private IVariableLookup second;

    public ChainedVariableLookup(IVariableLookup first, IVariableLookup second) {
        this.first = first;
        this.second = second;
    }

    public String toString() {
        return this.first + "\nthen:\n" + this.second;
    }

    @Override
    public Object getValue(String var) {
        Object v = this.first.getValue(var);
        if (v == null && !this.first.getVariableNames().contains(var)) {
            v = this.second.getValue(var);
        }
        return v;
    }

    @Override
    public Collection<String> getVariableNames() {
        LinkedHashSet<String> names = new LinkedHashSet<String>(this.first.getVariableNames());
        names.addAll(this.second.getVariableNames());
        return names;
    }
}

