/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.java.utils.variables;

import com.silabs.java.utils.variables.IKeyedVariableStore;
import com.silabs.java.utils.variables.IVariableKey;
import com.silabs.java.utils.variables.VariableKey;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;

public class KeyedVariableLookup
implements IKeyedVariableStore {
    private Map<IVariableKey, Object> namesToValues;

    public KeyedVariableLookup() {
        this.namesToValues = new HashMap<IVariableKey, Object>();
    }

    public KeyedVariableLookup(Map<IVariableKey, Object> map) {
        this.namesToValues = map;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (String name : this.getVariableNames()) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(name).append('=').append('\'').append(this.getValue(name)).append('\'');
        }
        return sb.toString();
    }

    @Override
    public Object getValue(IVariableKey var) {
        Object val = this.namesToValues.get(var);
        return val != null ? val : null;
    }

    @Override
    public Collection<IVariableKey> getVariables() {
        return this.namesToValues.keySet();
    }

    @Override
    public void setValue(IVariableKey key, Object value) {
        this.namesToValues.put(key, value);
    }

    @Override
    public void resetValue(IVariableKey key) {
        this.namesToValues.remove(key);
    }

    @Override
    public Object getValue(String var) {
        return this.getValue(VariableKey.get(var));
    }

    @Override
    public Collection<String> getVariableNames() {
        return this.getVariables().parallelStream().map(IVariableKey::key).collect(Collectors.toSet());
    }

    @Override
    public void setValue(String name, Object value) {
        this.setValue(VariableKey.get(name), value);
    }

    @Override
    public void resetValue(String name) {
        this.resetValue(VariableKey.get(name));
    }
}

