/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.java.utils.variables;

import com.silabs.java.utils.variables.IVariableScope;
import com.silabs.java.utils.variables.IVariableStore;
import com.silabs.java.utils.variables.IWritableVariableScope;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;

public class VariableScope
implements IWritableVariableScope {
    private IWritableVariableScope parent;
    private IVariableStore store;

    public VariableScope(IWritableVariableScope parent, IVariableStore store) {
        this.parent = parent;
        this.store = store;
    }

    public String toString() {
        return this.getClass().getSimpleName() + ": " + this.store.toString();
    }

    @Override
    public IWritableVariableScope getParent() {
        return this.parent;
    }

    @Override
    public Object findLocalValue(String name) {
        return this.store.getValue(name);
    }

    @Override
    public Object getValue(String name) {
        for (IVariableScope scope = this; scope != null; scope = scope.getParent()) {
            Object val = scope.findLocalValue(name);
            if (val == null) continue;
            return val;
        }
        return null;
    }

    @Override
    public IVariableStore getVariableStore() {
        return this.store;
    }

    @Override
    public void setVariableStore(IVariableStore store) {
        this.store = store;
    }

    @Override
    public void setValue(String name, Object value) {
        this.store.setValue(name, value);
    }

    @Override
    public Collection<String> getVariableNames() {
        if (this.getParent() == null) {
            return this.store.getVariableNames();
        }
        ArrayList<String> names = new ArrayList<String>(this.store.getVariableNames());
        names.addAll(this.getParent().getVariableNames());
        return names;
    }

    @Override
    public Collection<String> getLocalNames() {
        return Collections.unmodifiableCollection(this.store.getVariableNames());
    }

    @Override
    public void mergeFrom(IVariableScope from, boolean overwrite) {
        Collection<String> local = this.getLocalNames();
        for (String name : from.getLocalNames()) {
            if (!overwrite && local.contains(name)) continue;
            this.setValue(name, from.findLocalValue(name));
        }
    }
}

