/*
 * Decompiled with CFR 0.152.
 */
package slc.launcher;

import com.silabs.java.utils.HostUtils;
import com.silabs.java.utils.Pair;
import com.silabs.java.utils.TextUtils;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import org.fusesource.jansi.AnsiConsole;
import slc.launcher.ISlcLauncher;
import slc.launcher.context.SlcCliArgs;
import slc.launcher.context.SlcCliContext;
import slc.launcher.context.SlcTimer;
import slc.launcher.utils.VerifyJvm;

public abstract class BaseSlcLauncher
implements ISlcLauncher {
    public static final String SLC_NAME_BASE = "slc-cli";
    protected final SlcCliContext context;
    protected final SlcCliArgs slcArgs;

    protected BaseSlcLauncher(SlcCliContext context) {
        this.context = context;
        this.slcArgs = context.args();
    }

    protected int terminalWidth() {
        if (!this.slcArgs.ignoreTerminalWidth) {
            int width = AnsiConsole.getTerminalWidth();
            if (width <= 0) {
                return -1;
            }
            return width;
        }
        return -1;
    }

    protected Path getSlcBinLoc() {
        String slcInputLoc = this.slcArgs.slcCliLocation;
        if (TextUtils.isEmpty(slcInputLoc)) {
            slcInputLoc = "bin/slc-cli";
        }
        Path defaultSlcLoc = this.context.resolveInstallationPath(slcInputLoc);
        return defaultSlcLoc;
    }

    protected File getSlcLaunchLoc() {
        Path slcBinLoc = this.getSlcBinLoc();
        Path defaultSlcLoc = slcBinLoc.resolve(SLC_NAME_BASE);
        if (HostUtils.isOSX()) {
            defaultSlcLoc = slcBinLoc.resolve("slc-cli.app").resolve("Contents/MacOS/").resolve(SLC_NAME_BASE);
        } else if (HostUtils.isWindows()) {
            defaultSlcLoc = slcBinLoc.resolve("slc-clic.exe");
        } else if (!HostUtils.isLinux()) {
            this.context.print("Unhandled OS: assuming Linux naming rules.");
        }
        this.context.debugPrint("Launching " + defaultSlcLoc);
        return defaultSlcLoc.toFile();
    }

    protected List<String> launchArgs() {
        ArrayList<String> launchArgs = new ArrayList<String>();
        launchArgs.add(this.getSlcLaunchLoc().getAbsolutePath());
        launchArgs.add("-vm");
        launchArgs.add(this.getJvmLocation());
        if (this.slcArgs.workspaceLoc != null) {
            launchArgs.add("-data");
            launchArgs.add(this.slcArgs.workspaceLoc);
        }
        launchArgs.addAll(this.slcArgs.slcCmds);
        launchArgs.add("--launcher.appendVmargs");
        launchArgs.add("-vmargs");
        launchArgs.add("-Duc.workingdirectory=" + this.getWorkingDirArg(this.context));
        return launchArgs;
    }

    protected String getJvmLocation() {
        SlcTimer timer = this.context.timer("Verifying JVM");
        Pair<String, Boolean> jvm = this.findJvm();
        VerifyJvm.verifyJvm(this.context, (String)jvm.first, (Boolean)jvm.second);
        timer.done();
        return (String)jvm.first;
    }

    protected Pair<String, Boolean> findJvm() {
        String javaExe = HostUtils.isWindows() ? "java.exe" : "java";
        String javaHome = null;
        Boolean externalJvm = false;
        if (TextUtils.hasContent(this.slcArgs.slcJavaLocation)) {
            externalJvm = true;
            Path javaPath = this.context.resolvePath(this.slcArgs.slcJavaLocation);
            javaHome = javaPath.toString();
            if (javaExe.equals(javaPath.getFileName().toString())) {
                return new Pair<String, Boolean>(javaPath.toString(), externalJvm);
            }
        }
        if (TextUtils.isEmpty(javaHome)) {
            javaHome = System.getProperties().getProperty("java.home");
        }
        if (TextUtils.isEmpty(javaHome)) {
            throw new IllegalStateException("Failed to find java runtime location!");
        }
        return new Pair<String, Boolean>(Path.of(javaHome, new String[0]).resolve("bin/").resolve(javaExe).toString(), externalJvm);
    }

    private String getWorkingDirArg(SlcCliContext context) {
        return context.workingDirectory().toString();
    }
}

