/*
 * Decompiled with CFR 0.152.
 */
package slc.launcher;

import com.silabs.uc.cli.internal.daemon.shared.CliDaemon;
import com.silabs.uc.cli.internal.daemon.shared.DaemonSearchResult;
import com.silabs.uc.cli.internal.daemon.shared.DaemonUtils;
import com.silabs.uc.cli.internal.daemon.shared.DaemonVersionInfo;
import com.silabs.uc.cli.internal.daemon.shared.IDataDirectory;
import com.silabs.uc.cli.internal.daemon.shared.ISlcDaemon;
import com.silabs.uc.cli.internal.daemon.shared.MainStudioDaemon;
import com.silabs.uc.cli.internal.daemon.shared.RunningFileWaitTimeExceededException;
import com.silabs.uc.cli.internal.daemon.shared.SlcDaemonSharedData;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import org.json.JSONObject;
import slc.launcher.BaseSlcLauncher;
import slc.launcher.ISlcLauncher;
import slc.launcher.SlcDirectLauncher;
import slc.launcher.connection.SocketCommunicationThread;
import slc.launcher.context.SlcCliArgs;
import slc.launcher.context.SlcCliContext;
import slc.launcher.context.SlcTimer;
import slc.launcher.instrumented.JavaLauncherTelemetryUtils;
import slc.launcher.utils.ExecutionUtils;
import slc.launcher.utils.ISlcExitCode;
import slc.launcher.utils.ISlcLogger;
import slc.launcher.utils.SlcExitCodes;

public class SlcDaemonLauncher
extends BaseSlcLauncher
implements ISlcLauncher {
    private static final String VERSION_FILE = ".version";

    public static ISlcExitCode generateVersion(SlcCliContext context) {
        DaemonVersionInfo versionData = new SlcDaemonLauncher(context).loadVersionData();
        if (versionData == null) {
            context.printErr("Failed to write the version data!");
            return SlcExitCodes.GENERAL_ERROR;
        }
        return SlcExitCodes.EXIT_OK;
    }

    public SlcDaemonLauncher(SlcCliContext context) {
        super(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ISlcExitCode launch() {
        this.context.debugPrint("Using daemonised command line");
        DaemonVersionInfo ourVersion = this.loadVersionData();
        boolean ignoreVersions = this.slcArgs.devTest || ourVersion == null;
        DaemonVersionInfo paramVersion = ignoreVersions ? null : ourVersion;
        this.context.debugPrint("Starting SLC Daemon.");
        SlcTimer timer = this.context.timer("Starting Daemon Process");
        try {
            Optional<ISlcExitCode> exitCode;
            if (this.slcArgs.simplicityStudio && !this.slcArgs.shutdownDaemon) {
                exitCode = this.findDaemon(paramVersion, this.defaultMainDaemon());
                if (exitCode.isPresent()) {
                    ISlcExitCode iSlcExitCode = exitCode.get();
                    return iSlcExitCode;
                }
                this.context.printErr("Problems trying to find a Simplicity Studio instance to connect to. Falling back to a basic daemon search and/or launch.");
            }
            if ((exitCode = this.findDaemon(paramVersion, this.defaultDaemon())).isPresent()) {
                ISlcExitCode iSlcExitCode = exitCode.get();
                return iSlcExitCode;
            }
            if (this.slcArgs.doNotLaunchDaemon) {
                this.context.print("No running SLC Daemon found but requested not to launch a new daemon.");
                this.context.print("If you expected a connection, turn on -debug and make sure the shared files match the server version (or that both the server and the script are using no version)");
                SlcExitCodes slcExitCodes = SlcExitCodes.MISSING_SLC_DAEMON;
                return slcExitCodes;
            }
            this.context.printErr("Problems trying to find and/or launch a Daemon instance to connect to.");
        }
        finally {
            timer.done();
        }
        if (this.slcArgs.shutdownDaemon) {
            this.context.print("Could not contact running Daemon. Is it already shutdown?");
            return SlcExitCodes.EXIT_OK;
        }
        if (this.slcArgs.daemonOnly) {
            this.context.print("SLC Daemon launch/connection failed, and we were requested to NOT fallback to direct call. Command failed.");
            return SlcExitCodes.MISSING_SLC_DAEMON;
        }
        this.context.print("SLC Daemon could not be started. Falling back to direct call.");
        return this.newDirectLauncher(this.context).launch();
    }

    private boolean launchSlcDaemon(ISlcDaemon creator) {
        if (this.slcArgs.doNotLaunchDaemon || this.slcArgs.shutdownDaemon) {
            return false;
        }
        List<String> daemonArgs = super.launchArgs();
        daemonArgs.add("-Dslc_daemon=true");
        daemonArgs.add("-Dslc_cli_dev_testing=" + this.slcArgs.devTest);
        if (this.slcArgs.hasDaemonTimeout) {
            daemonArgs.add("-Dslc_cli_servlet_shutdown_minutes=" + this.slcArgs.daemonTimeout);
        }
        try {
            DaemonUtils.ensureCreatedNewAwaitingDataDirectory(creator, this.context.logger());
            ExecutionUtils.launchSlcProcess(this.context, true, false, daemonArgs);
            this.context.debugPrint("SLC Daemon has so far appeared to start normally");
            return true;
        }
        catch (FileNotFoundException e) {
            this.context.printErr(daemonArgs.get(0) + " not found -- daemon process cannot start.");
        }
        catch (IOException e) {
            this.context.printErr("SLC process failed. See error log for more information.", e);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Optional<ISlcExitCode> findDaemon(DaemonVersionInfo ourVersion, ISlcDaemon creator) {
        if (creator == this.defaultMainDaemon() && this.slcArgs.shutdownDaemon) {
            this.context.print("A shutdown command cannot be sent when connecting to a main Simplicity Studio instance.");
            return Optional.empty();
        }
        SlcTimer timer = this.context.timer("Finding Running Daemon");
        try {
            for (int attempts = 0; attempts < 3; ++attempts) {
                boolean failedResultRedo = false;
                int redo = 0;
                do {
                    failedResultRedo = false;
                    DaemonSearchResult result = DaemonUtils.searchForMatchingOrAwaiting(creator, ourVersion, this.context.logger());
                    if (result instanceof DaemonSearchResult.AcceptableDaemon) {
                        DaemonSearchResult.AcceptableDaemon acceptableDaemon = (DaemonSearchResult.AcceptableDaemon)result;
                        Optional<ISlcExitCode> exitCode = this.contactRunningDaemon(acceptableDaemon.daemon());
                        if (exitCode.isPresent()) {
                            Optional<ISlcExitCode> optional = exitCode;
                            return optional;
                        }
                        this.context.logger().daemonLog(() -> "Unacceptable or Overloaded Daemon at Start: " + acceptableDaemon.daemon().processId());
                        DaemonUtils.cleanupIfNeeded(acceptableDaemon.daemon(), this.context.logger());
                        failedResultRedo = true;
                        continue;
                    }
                    if (result instanceof DaemonSearchResult.AwaitingFiles) {
                        block18: {
                            Optional<SlcDaemonSharedData> nextResult;
                            DaemonSearchResult.AwaitingFiles awaitingResult = (DaemonSearchResult.AwaitingFiles)result;
                            List<Path> awaitingFiles = awaitingResult.awaiting().stream().map(IDataDirectory::runningFile).collect(Collectors.toList());
                            try {
                                nextResult = DaemonUtils.waitForRunning(awaitingFiles, ourVersion, this.context.runningFileTimeout(), this.context.logger());
                                if (!nextResult.isPresent()) break block18;
                                Optional<ISlcExitCode> exitCode = this.contactRunningDaemon(nextResult.get());
                                if (exitCode.isPresent()) {
                                    Optional<ISlcExitCode> optional = exitCode;
                                    return optional;
                                }
                            }
                            catch (RunningFileWaitTimeExceededException e) {
                                this.context.printErr("Too much time spent waiting for a Daemon to fill a .running file. " + e.getMessage(), e);
                                continue;
                            }
                            this.context.logger().daemonLog(() -> "Unacceptable or Overloaded Daemon after awaiting. Process Id: " + ((SlcDaemonSharedData)nextResult.get()).processId());
                            DaemonUtils.cleanupIfNeeded(nextResult.get(), this.context.logger());
                            failedResultRedo = true;
                            continue;
                        }
                        if (this.launchSlcDaemon(creator)) continue;
                        Optional<ISlcExitCode> optional = Optional.empty();
                        return optional;
                    }
                    if (!this.launchSlcDaemon(creator)) return Optional.empty();
                } while (++redo < 5 && failedResultRedo);
            }
        }
        catch (IOException e) {
            this.context.printErr("Problems occurred whilst trying to find a running daemon: " + e.getMessage(), e);
        }
        finally {
            timer.done();
        }
        this.context.printErr("Tried too many times to attempt to find and launch a daemon only to keep finding invalid .running files.");
        return Optional.empty();
    }

    private Optional<ISlcExitCode> contactRunningDaemon(SlcDaemonSharedData sharedFile) {
        SlcTimer timer = this.context.timer("Total Connection time");
        String uuid = UUID.randomUUID().toString();
        Optional<ISlcExitCode> exitCode = this.createSocketConnection(sharedFile, uuid, this.createSlcPayload(uuid));
        timer.done();
        return exitCode;
    }

    protected Optional<ISlcExitCode> createSocketConnection(SlcDaemonSharedData sharedFile, String uuid, JSONObject payload) {
        SocketCommunicationThread socketThread = new SocketCommunicationThread(this.context, sharedFile, uuid, payload);
        if (!socketThread.run()) {
            return Optional.empty();
        }
        return Optional.ofNullable(socketThread.getResult());
    }

    private JSONObject createSlcPayload(String uuid) {
        JSONObject payload = new JSONObject();
        payload.put("action", "command");
        payload.put("working_dir", this.context.workingDirectory().toString());
        payload.put("output_properties", Map.of("width", super.terminalWidth(), "colour", this.slcArgs.isColor));
        payload.put("command_line", this.slcArgs.slcCmds);
        payload.put("context", uuid);
        JavaLauncherTelemetryUtils.injectContextInJson(payload);
        return payload;
    }

    protected ISlcDaemon defaultDaemon() {
        return CliDaemon.INSTANCE;
    }

    protected ISlcDaemon defaultMainDaemon() {
        return MainStudioDaemon.INSTANCE;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public DaemonVersionInfo loadVersionData() {
        Path slcBinLocation = this.getSlcBinLoc();
        Path versionFile = slcBinLocation.resolve(VERSION_FILE);
        Path slcVersionLockFile = slcBinLocation.resolve(".lock");
        if (Files.isRegularFile(versionFile, new LinkOption[0])) return DaemonVersionInfo.create(versionFile);
        if (Files.isRegularFile(slcVersionLockFile, new LinkOption[0])) {
            this.context.print("Another process is writing our .version file. Waiting on them...");
        }
        try (DaemonUtils.DataDirLock versionLock = DaemonUtils.acquireLock(slcVersionLockFile, this.context.logger());){
            if (this.makeDirectCallForVersionFile(versionFile)) return DaemonVersionInfo.create(versionFile);
            DaemonVersionInfo daemonVersionInfo = null;
            return daemonVersionInfo;
        }
        catch (IOException e) {
            this.couldNotCreateVersionFileError(versionFile);
            this.context.logger().log(ISlcLogger.SlcLogging.ERROR, "Could not create .version file " + versionFile, e);
            this.context.printErr(e.getMessage());
            return null;
        }
    }

    protected boolean makeDirectCallForVersionFile(Path versionFile) throws IOException {
        if (!Files.isRegularFile(versionFile, new LinkOption[0])) {
            this.context.print("First SLC CLI run: need to create local .version file for future daemon connections...");
            SlcCliContext directContext = this.context.newContextWithDifferentArgs(this.argsForVersionRequest(versionFile));
            ISlcLauncher directVersionLauncher = this.newDirectLauncher(directContext);
            this.context.logger().log(ISlcLogger.SlcLogging.DEBUG, "Launching a direct version write call with new context. New context args: " + directContext.args().slcCmds, null);
            ISlcExitCode result = directVersionLauncher.launch();
            if (result.exitCode() != 0) {
                this.couldNotCreateVersionFileError(versionFile);
                return false;
            }
            if (!Files.isRegularFile(versionFile, new LinkOption[0])) {
                this.context.print("Zero-Exit code for SLC version creation, but expected .version file not there.");
                this.couldNotCreateVersionFileError(versionFile);
                return false;
            }
        }
        return true;
    }

    protected ISlcLauncher newDirectLauncher(SlcCliContext newContext) {
        return new SlcDirectLauncher(newContext);
    }

    private SlcCliArgs argsForVersionRequest(Path versionFile) {
        return this.context.args().directCallFromExisting(List.of("write-version", versionFile.toAbsolutePath().toString()));
    }

    private void couldNotCreateVersionFileError(Path versionFile) {
        this.context.printErr("No .version file for SLC CLI itself, and failed to create one at: " + versionFile + " . Launching or connecting to daemon without version checking.");
    }
}

