/*
 * Decompiled with CFR 0.152.
 */
package slc.launcher.connection;

import com.silabs.uc.cli.internal.daemon.shared.SlcDaemonSharedData;
import java.net.URI;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.concurrent.CompletableFuture;
import org.json.JSONObject;
import slc.launcher.connection.ConnectionUtils;
import slc.launcher.context.SlcCliContext;
import slc.launcher.context.SlcTimer;

public final class SlcRestRequest {
    private SlcRestRequest() {
    }

    public static void run(SlcCliContext context, SlcDaemonSharedData sharedFile, JSONObject slcPayload) {
        SlcTimer timer = context.timer("Sending REST request");
        URI uri = ConnectionUtils.restCmd(sharedFile);
        context.debugPrint("Sending request to " + uri);
        context.debugPrint(slcPayload.toString());
        HttpRequest request = HttpRequest.newBuilder().uri(uri).header("Content-Type", "application/json").header("Accept", "application/json").POST(HttpRequest.BodyPublishers.ofString(slcPayload.toString())).build();
        CompletableFuture<HttpResponse<String>> responseFuture = ConnectionUtils.httpclient().sendAsync(request, HttpResponse.BodyHandlers.ofString());
        context.debugPrint("Request Sent to " + uri);
        responseFuture.whenComplete((response, except) -> {
            if (except != null) {
                if (context.args().debug) {
                    context.printErr("Could not communicate with SLC Daemon Server: Connection Refused at port " + sharedFile.portNumber() + ". If you still get results, this could had been a stale .running file that was not cleaned up, and this issue should not appear on the next command line run.", (Throwable)except);
                }
            } else if (response == null || response.statusCode() != 200) {
                context.printErr("Could not communicate with Daemon Server at " + uri);
                if (response != null) {
                    context.printErr((String)response.body());
                }
            } else if (context.args().debug && !((String)response.body()).isEmpty()) {
                JSONObject msg = new JSONObject((String)response.body());
                context.debugPrint("Recieved return message from command. Return code: " + msg.getString("return_code"));
            }
        });
        timer.done();
    }
}

