/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.uc.cli.internal.analytics.uploader;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.silabs.java.utils.runtime.RuntimeUtils;
import com.silabs.ss.framework.uc.core.internal.api.log.UcCoreLogger;
import com.silabs.ss.platform.api.analytics.core.IAnalyticsContentUpload;
import com.silabs.ss.platform.api.rcp.core.analytics.route.BuiltInAnalyticsRoutes;
import com.silabs.ss.platform.api.rcp.core.analytics.route.IAnalyticsRoute;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class SlcCliFileBasedPerformanceUploader
implements IAnalyticsContentUpload {
    private static final String PERFORMANCE_PREFIX = "perf_";
    private boolean junitFallbackDebug = false;
    private static final int PANIC = 500;
    private static final int MAX_RECORDS = 200;

    public void sendContent(String content, IAnalyticsRoute route) throws Exception {
        if (BuiltInAnalyticsRoutes.performance().equals(route)) {
            this.handlePerformance(content, route.outgoing());
        }
    }

    public int priority() {
        return 50;
    }

    private synchronized void handlePerformance(String content, Path localStorage) {
        assert (localStorage != null);
        Path storage = localStorage.resolve(this.timestampFileName());
        try {
            if (!Files.exists(localStorage, new LinkOption[0])) {
                Files.createDirectories(localStorage, new FileAttribute[0]);
            }
            if (Files.exists(storage, new LinkOption[0])) {
                storage = this.determineNextFile(storage);
            }
            Files.createFile(storage, new FileAttribute[0]);
            Throwable throwable = null;
            Object var5_7 = null;
            try (BufferedWriter writer = Files.newBufferedWriter(storage, StandardCharsets.UTF_8, new OpenOption[0]);){
                writer.write(content);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            this.checkAndCleanSize(localStorage);
        }
        catch (IOException e) {
            UcCoreLogger.unifiedLogger().internalError("Unable to write an anlaytic performance event to disk at " + String.valueOf(storage) + ": " + e.getLocalizedMessage(), (Throwable)e);
        }
    }

    public static Stream<Path> perfFilterSort(Stream<Path> listing) {
        return listing.filter(p -> p.getFileName().toString().startsWith(PERFORMANCE_PREFIX)).sorted(SlcCliFileBasedPerformanceUploader::perfComparator);
    }

    private static int perfComparator(Path p1, Path p2) {
        return p1.getFileName().toString().compareTo(p2.getFileName().toString());
    }

    private synchronized Path determineNextFile(Path original) {
        Path parent = original.getParent();
        String name = original.getFileName().toString();
        int i = 0;
        while (i < 500) {
            String stringyNumber = String.valueOf(i);
            String padded = Strings.padStart((String)stringyNumber, (int)4, (char)'0');
            Path tryPath = parent.resolve(name + "+" + padded);
            if (!Files.exists(tryPath, new LinkOption[0])) {
                return tryPath;
            }
            ++i;
        }
        return original;
    }

    private void checkAndCleanSize(Path localStorage) throws IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (Stream<Path> fileStream = Files.list(localStorage);){
            List listing = SlcCliFileBasedPerformanceUploader.perfFilterSort(fileStream).collect(Collectors.toList());
            if (listing.size() > 200) {
                Iterator iter = listing.stream().limit(100L).iterator();
                while (iter.hasNext()) {
                    Files.delete((Path)iter.next());
                }
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private String timestampFileName() {
        return this.junitFallbackDebug ? "perf_fallback" : PERFORMANCE_PREFIX + Strings.padStart((String)String.valueOf(System.currentTimeMillis()), (int)20, (char)'0');
    }

    public void junitSetFallbackDebug(boolean debug) {
        Preconditions.checkState((boolean)RuntimeUtils.isJUnitRunning(), (Object)"Cannot set debugging data outside of JUnit Tests");
        this.junitFallbackDebug = debug;
    }
}

