/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.uc.cli.internal.command;

import com.google.common.base.Stopwatch;
import com.silabs.java.utils.log.ILogger;
import com.silabs.java.utils.log.Log;
import com.silabs.ss.framework.uc.core.api.UcFramework;
import com.silabs.uc.cli.internal.command.CliRoot;
import com.silabs.uc.cli.internal.command.exception.SdkRequiredException;
import com.silabs.uc.cli.internal.command.mixin.BaseOptions;
import com.silabs.uc.cli.internal.command.mixin.CliSdk;
import com.silabs.uc.cli.internal.model.ICliOutput;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import org.eclipse.equinox.app.IApplication;
import picocli.CommandLine;

@CommandLine.Command(name="tuning", hidden=true, description={"Runs a tuning test where a variable number of threads are used to load an sdk. Timing results are output."})
public class SlcTuning
implements Callable<Integer> {
    @CommandLine.Mixin
    private BaseOptions cliConfig;
    @CommandLine.Mixin
    private CliSdk sdkBase;
    @CommandLine.ParentCommand
    private CliRoot root;
    @CommandLine.Option(names={"-o", "--output"}, required=true, paramLabel="DESTINATION_FILE", description={"Destination of .csv file with generated timings"})
    private String output;
    @CommandLine.Option(names={"-t", "--threads"}, defaultValue="4", paramLabel="THREADS", description={"number of threads. Default is ${DEFAULT-VALUE}"})
    private int threads;
    @CommandLine.Option(names={"-r", "--runs"}, defaultValue="20", paramLabel="NUMBER_OF_RUNS", description={"number of times to run framework load. Default is ${DEFAULT-VALUE}"})
    private int runs;
    @CommandLine.Option(names={"-c", "--cache"}, paramLabel="CACHE_NAME", description={"if set, a cache will be used with the given name in the current directory, and created if it does not exist. If 'clear' is set to true, then an existing cache will be removed."})
    private String useCacheName;
    @CommandLine.Option(names={"-x", "--clear"}, description={"clears the cache if it exists before attempting tuning test."})
    private boolean clearCache;
    private static final String LF = System.lineSeparator();

    @Override
    public Integer call() {
        Path checkParent;
        ICliOutput feedback = this.root.feedback(this.cliConfig);
        Path outputLocation = feedback.resolve(this.output);
        if (outputLocation.getParent() != null && !Files.isDirectory(checkParent = outputLocation.getParent(), new LinkOption[0])) {
            feedback.err().println("Cannot run test: output location not accessible");
            return -1;
        }
        return this.sdkBase.calculatedSdkLocation(feedback).map(superLoc -> SlcTuning.timeReading(superLoc, outputLocation, this.threads, this.runs, this.useCacheName, this.clearCache, feedback)).orElseThrow(() -> new SdkRequiredException());
    }

    public static int timeReading(Path superLoc, Path output, int nThreads, int nRuns, String cache, boolean clear, ICliOutput feedback) {
        try {
            Path cacheLoc;
            if (clear && Files.exists(cacheLoc = superLoc.resolve(cache), new LinkOption[0])) {
                Files.delete(cacheLoc);
            }
            File f = superLoc.toFile();
            UcFramework.fromFileTune((File)f, (int)1, (int)1, null, (boolean)true, (ILogger)feedback.unifiedLogger());
            StringBuilder csv = new StringBuilder().append("Threads,Run #,Time").append(LF);
            int run = 0;
            while (run < nRuns) {
                Stopwatch ucLoad = Stopwatch.createStarted();
                UcFramework.fromFileTune((File)f, (int)nThreads, (int)nThreads, (String)cache, (boolean)true, (ILogger)feedback.unifiedLogger());
                ucLoad.stop();
                long elapsed = ucLoad.elapsed(TimeUnit.MILLISECONDS);
                String result = nThreads + "," + run + "," + elapsed + LF;
                feedback.out().print(result);
                csv.append(result);
                ++run;
            }
            feedback.out().println("entire csv contents: ");
            String results = csv.toString();
            feedback.out().println(results);
            Throwable throwable = null;
            Object var11_16 = null;
            try (BufferedWriter os = Files.newBufferedWriter(output, new OpenOption[0]);){
                os.write(results);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            String msg = "Tuning could not be completed due to " + e.getClass().getCanonicalName() + " " + e.getMessage();
            feedback.out().println(msg);
            Log.error((String)msg);
        }
        return IApplication.EXIT_OK;
    }
}

