/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.uc.cli.internal.command;

import com.silabs.ss.framework.uc.api.sdk.IUcSdk;
import com.silabs.ss.platform.api.apack.core.model.AdapterPackManager;
import com.silabs.ss.platform.api.apack.core.model.IAdapterPack;
import com.silabs.ss.platform.api.apack.core.model.external.ExternalAdapterPack;
import com.silabs.uc.cli.internal.command.CliRoot;
import com.silabs.uc.cli.internal.command.mixin.BaseOptions;
import com.silabs.uc.cli.internal.command.mixin.CliExternalTools;
import com.silabs.uc.cli.internal.command.mixin.CliSdk;
import com.silabs.uc.cli.internal.command.mixin.CliSlcSdk;
import com.silabs.uc.cli.internal.model.ICliOutput;
import com.silabs.uc.cli.internal.model.ShowSdkWarnings;
import java.nio.file.Path;
import java.util.List;
import java.util.concurrent.Callable;
import picocli.CommandLine;

@CommandLine.Command(name="adapter-packs", description={"Displays a list of all adapter packs registered, based on the form of the command. An SLT Config File can be supplied and if so this will print out all the packs found after parsing the `adapter-packs` or `tool-data` sections (as well as if either of those are supplied via command line to this call). Otherwise, this command will require an sdk reference and will output the adapter packs relevant to the sdk. Be aware these are considered exclusive -- whilst it is not an error to define both, the apack listings coming from an SLT-aware run supercede the sdk, so if you wish to know what the sdk provides only in a non-SLT environment, do not pass in the `adapter-pack` suite of options and either don't supply an slt configuration file, or use `--ignore-slt` to forcibly shut that feature off."})
public class UcCliAdapterPack
implements Callable<Integer> {
    @CommandLine.Mixin
    private BaseOptions cliConfig;
    @CommandLine.Mixin
    private CliExternalTools cliExtTools;
    @CommandLine.Mixin
    private CliSdk sdkCmd;
    @CommandLine.Mixin
    private CliSlcSdk ptcSdk;
    @CommandLine.ParentCommand
    private CliRoot root;

    @Override
    public Integer call() {
        ICliOutput feedback = this.root.feedback(this.cliConfig);
        IUcSdk loaded = this.ptcSdk.loadPtcSdk(feedback, this.sdkCmd, ShowSdkWarnings.DO_NOT_SHOW_WARNINGS).orElse(null);
        return this.listApacks(this.cliExtTools.customsDefined(), (List<Path>)this.cliExtTools.customAdapterPacks(feedback), loaded, feedback);
    }

    private Integer listApacks(boolean useCustoms, List<Path> customs, IUcSdk sdk, ICliOutput feedback) {
        if (useCustoms) {
            feedback.out().println("SLT-Awareness Detected. Using directly provided custom external tool listing.");
            customs.forEach(custom -> feedback.out().println("- " + String.valueOf(custom)));
            return 0;
        }
        if (sdk != null) {
            feedback.out().println("No SLT Detected. Using Adapter Pack Tool data from SDK and Global Configuration.");
            IAdapterPack[] iAdapterPackArray = AdapterPackManager.instance().adapterPacks();
            int n = iAdapterPackArray.length;
            int n2 = 0;
            while (n2 < n) {
                IAdapterPack apack = iAdapterPackArray[n2];
                if (apack instanceof ExternalAdapterPack) {
                    ExternalAdapterPack studioApack = (ExternalAdapterPack)apack;
                    String sdkId = (String)studioApack.studioProperties().get("contributingSdk");
                    if (sdkId == null || sdk.getName().equals(sdkId)) {
                        feedback.out().println("- " + this.apackLocToString(apack));
                    }
                } else {
                    feedback.out().println("- " + this.apackLocToString(apack));
                }
                ++n2;
            }
            return 0;
        }
        feedback.err().println("Requested to print adapter pack paths, but without an SLT Configuration or provided sdk, this query cannot be answered.");
        return 1;
    }

    private String apackLocToString(IAdapterPack apack) {
        return apack.source().toString().toLowerCase() + ": " + (String)(apack.root() != null ? apack.root().getAbsolutePath() : apack.label() + "(no path)");
    }
}

