/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.uc.cli.internal.command;

import com.silabs.uc.cli.internal.command.CliRoot;
import com.silabs.uc.cli.internal.command.exception.SdkRequiredException;
import com.silabs.uc.cli.internal.command.mixin.BaseOptions;
import com.silabs.uc.cli.internal.command.mixin.CliSdk;
import com.silabs.uc.cli.internal.command.mixin.CliSlcSdk;
import com.silabs.uc.cli.internal.model.ICliOutput;
import com.silabs.uc.cli.internal.model.ShowSdkWarnings;
import java.util.concurrent.Callable;
import picocli.CommandLine;

@CommandLine.Command(name="cache_update", hidden=true, description={"Loads up the sdk, and updates the cache if needed. Performs no other operation. The request to update the cache can be augmented with a path to a cache file."})
public class UcCliCacheUpdate
implements Callable<Integer> {
    @CommandLine.Mixin
    private BaseOptions cliConfig;
    @CommandLine.Mixin
    private CliSdk sdkBase;
    @CommandLine.Mixin
    private CliSlcSdk ptcSdkBase;
    @CommandLine.ParentCommand
    private CliRoot root;

    @Override
    public Integer call() {
        ICliOutput feedback = this.root.feedback(this.cliConfig);
        return this.ptcSdkBase.loadPtcSdk(feedback, this.sdkBase, ShowSdkWarnings.DO_NOT_SHOW_WARNINGS).map(x -> 0).orElseThrow(() -> {
            feedback.out().println("Due to sdk loading issues, the cache was not updated.");
            return new SdkRequiredException();
        });
    }
}

