/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.uc.cli.internal.command;

import com.google.common.base.Stopwatch;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.silabs.ss.framework.uc.core.api.IUcFramework;
import com.silabs.ss.framework.uc.core.api.IUcSharedMetadata;
import com.silabs.ss.framework.uc.core.api.comp.ApiPartaker;
import com.silabs.ss.framework.uc.core.api.comp.IUcProjectComponent;
import com.silabs.ss.framework.uc.core.api.context.IUcSdkContent;
import com.silabs.ss.framework.uc.core.api.exception.UcConfigurationException;
import com.silabs.ss.framework.uc.core.api.model.IUcProject;
import com.silabs.ss.framework.uc.core.api.validate.FilterAccessibleResult;
import com.silabs.ss.framework.uc.core.api.validate.UcApiUtils;
import com.silabs.uc.cli.internal.command.CliRoot;
import com.silabs.uc.cli.internal.command.exception.SdkRequiredException;
import com.silabs.uc.cli.internal.command.mixin.BaseOptions;
import com.silabs.uc.cli.internal.command.mixin.CliForce;
import com.silabs.uc.cli.internal.command.mixin.CliProjectImplicit;
import com.silabs.uc.cli.internal.command.mixin.CliSdk;
import com.silabs.uc.cli.internal.command.mixin.CliSlcSdk;
import com.silabs.uc.cli.internal.command.model.SltSdkFeatures;
import com.silabs.uc.cli.internal.command.util.CliProjectUtils;
import com.silabs.uc.cli.internal.model.ICliOutput;
import com.silabs.uc.cli.internal.model.ShowSdkWarnings;
import com.silabs.uc.cli.internal.util.CliUtility;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import picocli.CommandLine;

@CommandLine.Command(name="prune", description={"prunes the sdk of components incompatible (providing conflicting apis) with the project's components, as well as any components rendered unreachable due to incompatibility checks. This MAY be used without a project -- if so, you must supply at least one component using --with."})
public final class UcCliDependencyPrune
implements Callable<Integer> {
    @CommandLine.Mixin
    private BaseOptions cliConfig;
    @CommandLine.Mixin
    private CliSdk sdkBase;
    @CommandLine.Mixin
    private CliSlcSdk ptcSdkBase;
    @CommandLine.Mixin
    private CliProjectImplicit projectBase;
    @CommandLine.Mixin
    private CliForce force;
    @CommandLine.ParentCommand
    private CliRoot root;
    @CommandLine.Option(names={"-time", "--time"}, hidden=true, description={"Times how long the pruning algorithm takes"})
    private boolean time;
    @CommandLine.Option(names={"-trace", "--trace"}, description={"Displays more information about what was filtered out and what apis were never provided and what other apis they were waiting on. Intended to help trace why something might had been removed if it is otherwise non-obvious."})
    private boolean trace;
    @CommandLine.Option(names={"-focus", "--focus"}, paramLabel="API_LIST", description={"Displays detailed information of the algorithm process with regards to the given api(s). This can assist in finding out why a particular api was unlocked/not unlocked."}, split=",")
    private List<String> focus = new ArrayList<String>();

    @Override
    public Integer call() {
        ICliOutput feedback = this.root.feedback(this.cliConfig);
        return this.ptcSdkBase.loadPtcSdk(feedback, this.sdkBase, ShowSdkWarnings.DO_NOT_SHOW_WARNINGS).map(sdk -> this.runDependencyPrune((IUcSdkContent)sdk, feedback)).orElseThrow(SdkRequiredException::new);
    }

    public int runDependencyPrune(IUcSdkContent sdk, ICliOutput feedback) {
        IUcProject project = this.projectBase.loadProject(sdk, feedback, SltSdkFeatures.fromMixin(this.sdkBase, feedback), false, false, this.force.forceOperations()).orElse(null);
        ArrayList<ApiPartaker> selected = new ArrayList<ApiPartaker>();
        if (project != null) {
            UcApiUtils.SelectedWithApis calc = UcApiUtils.calculateSelected((IUcProject)project);
            selected.addAll((Collection<ApiPartaker>)calc.everythingSelected());
        } else {
            try {
                Set<IUcProjectComponent> addedComps = CliProjectUtils.computeComponentList(this.projectBase.withinComponents(), true, false, sdk.framework(), feedback);
                addedComps.stream().map(IUcSharedMetadata::id).distinct().map(arg_0 -> ((IUcFramework)sdk.framework()).findComponent(arg_0)).flatMap(Optional::stream).forEach(selected::add);
            }
            catch (UcConfigurationException e) {
                feedback.unifiedLogger().userError("Could not compute added components properly due to " + e.getMessage(), (Throwable)e);
            }
        }
        Set alreadySelected = selected.stream().map(ApiPartaker::id).collect(Collectors.toSet());
        ImmutableSet focused = (ImmutableSet)this.focus.stream().collect(ImmutableSet.toImmutableSet());
        FilterAccessibleResult result = this.runFilter(selected, sdk.framework(), this.time, (ImmutableSet<String>)focused, feedback);
        List<String> filteredIds = result.result().stream().filter(comp -> !alreadySelected.contains(comp.id())).sorted((c1, c2) -> c1.id().compareTo(c2.id())).map(IUcSharedMetadata::id).collect(Collectors.toList());
        feedback.out().println("Components you may add given initial selections: ");
        int consoleWidth = feedback.session().consoleWidth();
        CliUtility.printStringsNicely(filteredIds, feedback.out(), it -> it, consoleWidth, "");
        if (this.trace) {
            feedback.out().println("========== Additional Tracing Info ========= ");
            feedback.out().println("On first pass, the following components were removed due to providing at least one conflicting api: ");
            CliUtility.printStringsNicely(result.initialExclusivity().stream().map(IUcSharedMetadata::id).sorted().collect(Collectors.toList()), feedback.out(), it -> it, consoleWidth, "");
            feedback.out().println("The following apis were never provided. The following lists each api, and below it a number of requirement lists. Only one requirement list containing only those requirements that were not available to allow the given provide. If a component was filtered out, it dependenced on something that was never properly provided in the first place.");
            ImmutableMultimap providesToUnlocks = result.lockedProvides();
            List provsSorted = providesToUnlocks.keySet().stream().sorted().collect(Collectors.toList());
            for (String prov : provsSorted) {
                feedback.out().println(prov);
                for (List reqs : providesToUnlocks.get((Object)prov)) {
                    feedback.out().println(" - " + reqs.stream().collect(Collectors.joining(", ")));
                }
            }
        }
        return 0;
    }

    private FilterAccessibleResult runFilter(List<ApiPartaker> selected, IUcFramework framework, boolean time, ImmutableSet<String> focused, ICliOutput feedback) {
        Stopwatch stopWatch = Stopwatch.createUnstarted();
        if (time) {
            stopWatch.start();
        }
        FilterAccessibleResult result = UcApiUtils.filterAccessible(selected, (Collection)framework.allComponents().collect(Collectors.toList()), focused, feedback.outPrintln());
        if (time) {
            stopWatch.stop();
            long elapsed = stopWatch.elapsed(TimeUnit.MILLISECONDS);
            feedback.out().println("Timing complete: " + elapsed + " ms");
        }
        return result;
    }
}

