/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.uc.cli.internal.command;

import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.Multimaps;
import com.silabs.ss.framework.uc.api.sdk.IUcSdk;
import com.silabs.ss.framework.uc.core.api.IUcFramework;
import com.silabs.ss.framework.uc.core.api.comp.IUcComponent;
import com.silabs.ss.framework.uc.core.api.comp.Instantiability;
import com.silabs.ss.framework.uc.core.api.comp.RecommendedInstance;
import com.silabs.ss.framework.uc.core.api.context.IUcSdkContent;
import com.silabs.ss.framework.uc.core.api.model.IUcProject;
import com.silabs.uc.cli.internal.command.CliRoot;
import com.silabs.uc.cli.internal.command.exception.SdkRequiredException;
import com.silabs.uc.cli.internal.command.mixin.BaseOptions;
import com.silabs.uc.cli.internal.command.mixin.CliExtensionMixin;
import com.silabs.uc.cli.internal.command.mixin.CliForce;
import com.silabs.uc.cli.internal.command.mixin.CliProject;
import com.silabs.uc.cli.internal.command.mixin.CliSdk;
import com.silabs.uc.cli.internal.command.mixin.CliSlcSdk;
import com.silabs.uc.cli.internal.command.model.SltSdkFeatures;
import com.silabs.uc.cli.internal.command.util.FoundComponent;
import com.silabs.uc.cli.internal.command.util.UcCliUtils;
import com.silabs.uc.cli.internal.model.CliSessionData;
import com.silabs.uc.cli.internal.model.ICliOutput;
import com.silabs.uc.cli.internal.model.ShowSdkWarnings;
import com.silabs.uc.cli.internal.util.CliColour;
import com.silabs.uc.cli.internal.util.ComponentRender;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import org.eclipse.equinox.app.IApplication;
import picocli.CommandLine;

@CommandLine.Command(name="examine", description={"examines a given component and returns a summary of that entire component, including the .slcc file it is from."})
public class UcCliExamine
implements Callable<Integer> {
    @CommandLine.Mixin
    private BaseOptions cliConfig;
    @CommandLine.Mixin
    private CliSdk sdkCmd;
    @CommandLine.Mixin
    private CliSlcSdk ptcSdk;
    @CommandLine.Mixin
    private CliProject projectBase;
    @CommandLine.Mixin
    private CliExtensionMixin ifExt;
    @CommandLine.Mixin
    private CliForce force;
    @CommandLine.ParentCommand
    private CliRoot root;
    @CommandLine.Option(names={"-q", "--quick"}, description={"Only examines information that can be gleamed from the .slcc file itself. By default, some information, such as recommended instance names, require examining the entire sdk and will take extra time to process. This option disables any data output about a component that would otherwise take much longer to compute."})
    private boolean quick;
    @CommandLine.Parameters(index="0")
    String componentName;

    @Override
    public Integer call() {
        ICliOutput feedback = this.root.feedback(this.cliConfig);
        return this.ptcSdk.loadPtcSdk(feedback, this.sdkCmd, ShowSdkWarnings.DO_NOT_SHOW_WARNINGS).map(ptc -> this.runExamine((IUcSdk)ptc, feedback)).orElseThrow(SdkRequiredException::new);
    }

    private int runExamine(IUcSdk sdk, ICliOutput feedback) {
        IUcProject project = this.projectBase.loadProject((IUcSdkContent)sdk, feedback, SltSdkFeatures.fromMixin(this.sdkCmd, feedback), false, false, this.force.forceOperations()).orElse(null);
        Optional<IUcComponent> found = UcCliUtils.findComponent(this.componentName, this.ifExt, sdk, project, feedback).map(FoundComponent::component);
        if (found.isPresent()) {
            ComponentRender.renderComponent(found.get(), sdk.framework(), new ComponentRender.PrintOptions().useColour(feedback.session().isColour()), feedback.out());
            if (!this.quick) {
                this.renderExtras(found.get(), sdk.framework(), feedback);
            }
        } else {
            Optional<String> extValue = this.ifExt.value();
            feedback.out().println("Component " + this.componentName + " could not be found" + (String)(extValue.isPresent() ? " via extension " + extValue.get() : "") + ". It may not exist. If there are previous errors, refer to them for cause.");
            return -1;
        }
        return IApplication.EXIT_OK;
    }

    public void renderExtras(IUcComponent component, IUcFramework framework, ICliOutput feedback) {
        CliSessionData session = feedback.session();
        List recs = Instantiability.calculateRecommendedInstances((IUcComponent)component, (IUcFramework)framework);
        if (!recs.isEmpty()) {
            ImmutableListMultimap groupedRecs = Multimaps.index((Iterable)recs, RecommendedInstance::instanceName);
            feedback.out().println("This instantiable component has some recommended instance names: ");
            for (String instaName : groupedRecs.keySet()) {
                String allNames = groupedRecs.get((Object)instaName).stream().map(rec -> rec.recommender().id()).collect(Collectors.joining(", "));
                feedback.out().println(session.colourIfNeeded(instaName, CliColour.YELLOW) + " from " + session.colourIfNeeded(allNames, CliColour.GREEN));
            }
        }
    }
}

