/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.uc.cli.internal.command;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Streams;
import com.silabs.ss.framework.uc.api.sdk.IUcSdk;
import com.silabs.ss.framework.uc.core.api.IUcAdditionalFramework;
import com.silabs.ss.framework.uc.core.api.IUcFrameworkCommon;
import com.silabs.ss.framework.uc.core.api.comp.IUcComponent;
import com.silabs.ss.framework.uc.core.api.comp.IUcSdkReference;
import com.silabs.ss.framework.uc.core.api.context.IUcSdkContent;
import com.silabs.ss.framework.uc.core.api.log.IUnifiedLogger;
import com.silabs.ss.framework.uc.core.api.model.IUcProject;
import com.silabs.ss.framework.uc.core.api.sdkextension.IUcSdkExtensionId;
import com.silabs.ss.framework.uc.core.api.validate.UcApiUtils;
import com.silabs.uc.cli.internal.command.CliRoot;
import com.silabs.uc.cli.internal.command.exception.SdkRequiredException;
import com.silabs.uc.cli.internal.command.mixin.BaseOptions;
import com.silabs.uc.cli.internal.command.mixin.CliForce;
import com.silabs.uc.cli.internal.command.mixin.CliProject;
import com.silabs.uc.cli.internal.command.mixin.CliSdk;
import com.silabs.uc.cli.internal.command.mixin.CliSlcSdk;
import com.silabs.uc.cli.internal.command.model.SltSdkFeatures;
import com.silabs.uc.cli.internal.filter.FilterEngine;
import com.silabs.uc.cli.internal.filter.SearchableComponent;
import com.silabs.uc.cli.internal.filter.generated.FilterGrammerLexer;
import com.silabs.uc.cli.internal.filter.generated.FilterGrammerParser;
import com.silabs.uc.cli.internal.model.ICliOutput;
import com.silabs.uc.cli.internal.model.SearchedComponent;
import com.silabs.uc.cli.internal.model.ShowSdkWarnings;
import com.silabs.uc.cli.internal.util.CliColour;
import com.silabs.uc.cli.internal.util.CliGenerator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.ANTLRInputStream;
import org.antlr.v4.runtime.BaseErrorListener;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.Recognizer;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.misc.ParseCancellationException;
import org.eclipse.equinox.app.IApplication;
import picocli.CommandLine;

@CommandLine.Command(name="filter", description={"filter components using a custom expression. Expression are of a form 'key[=/~]value' where key is a metadata piece (provides, name, category) and value is text to search in that key. '=' means exact equality, whereas '~' just means contains. This expression supports 'and', 'or', and parenthesis for order of operations. If a project is supplied, then this filter operation will only run against the project selected components.\n If searching on a term with spaces, you must wrap the entire search parameter in quotes and the value itself in single quotes. So, search \"label='GPIO Init Core'\" not \"label=GPIO Init Core\""})
public class UcCliFilter
implements Callable<Integer> {
    @CommandLine.Mixin
    private BaseOptions cliConfig;
    @CommandLine.Mixin
    private CliSdk sdkBase;
    @CommandLine.Mixin
    private CliSlcSdk ptcSdkBase;
    @CommandLine.Mixin
    private CliProject projectBase;
    @CommandLine.Mixin
    private CliForce force;
    @CommandLine.ParentCommand
    private CliRoot root;
    @CommandLine.Parameters(parameterConsumer=AntlrConsumer.class)
    private String antlrExpression;

    @Override
    public Integer call() {
        ICliOutput feedback = this.root.feedback(this.cliConfig);
        IUcSdk ptcSdk = this.ptcSdkBase.loadPtcSdk(feedback, this.sdkBase, ShowSdkWarnings.DO_NOT_SHOW_WARNINGS).orElseThrow(SdkRequiredException::new);
        IUcProject project = this.projectBase.loadProject((IUcSdkContent)ptcSdk, feedback, SltSdkFeatures.fromMixin(this.sdkBase, feedback), false, false, this.force.forceOperations()).orElse(null);
        Stream<SearchableComponent> components = this.decideComponentUniverse(ptcSdk, project, feedback);
        feedback.unifiedLogger().internalInfo("Parsed ANTLR expression: " + this.antlrExpression, null);
        int result = UcCliFilter.filterAndPrint(this.antlrExpression, components, feedback);
        return result;
    }

    private Stream<SearchableComponent> decideComponentUniverse(IUcSdk sdk, IUcProject project, ICliOutput feedback) {
        if (project != null) {
            IUcSdkReference mainSdkReference = sdk.framework().frameworkReference();
            return this.projectComponentStream(project, feedback).map(comp -> {
                String extId = project.ucFramework().frameworkForComponent(comp.id()).map(IUcFrameworkCommon::frameworkReference).filter(ref -> !ref.equals(mainSdkReference)).map(Object::toString).orElse("");
                return new SearchableComponent((IUcComponent)comp, extId);
            });
        }
        return Streams.concat((Stream[])new Stream[]{sdk.framework().allComponents().map(c -> new SearchableComponent((IUcComponent)c, "")), sdk.framework().sdkExtensions().entrySet().stream().flatMap(UcCliFilter::allSearchableComponentsInExtension)});
    }

    private static Stream<SearchableComponent> allSearchableComponentsInExtension(Map.Entry<IUcSdkExtensionId, IUcAdditionalFramework> idAndExtPair) {
        String extId = idAndExtPair.getKey().toString();
        return idAndExtPair.getValue().allComponents().map(comp -> new SearchableComponent((IUcComponent)comp, extId));
    }

    private Stream<IUcComponent> projectComponentStream(IUcProject project, ICliOutput feedback) {
        boolean apiValidationSucceeded = CliGenerator.internalValidationApi(project, feedback);
        if (!apiValidationSucceeded) {
            feedback.out().println("Some components may not be present due to invalid project state.");
            feedback.out().println("Continuing with filter based on incomplete component selection:");
        }
        return UcApiUtils.calculateSelected((IUcProject)project).trulySelectedStream();
    }

    public static int filterAndPrint(String expression, Stream<SearchableComponent> mainFramework, ICliOutput feedback) {
        if ("".equals(expression = expression.trim())) {
            feedback.err().println("Cannot call filter without something to filter on");
        }
        boolean colour = feedback.session().isColour();
        try {
            for (SearchedComponent comp : UcCliFilter.filter(expression, mainFramework, feedback.unifiedLogger())) {
                String compId = comp.component().id();
                String metadataString = comp.metadata().stream().collect(Collectors.joining(System.lineSeparator() + Strings.repeat((String)" ", (int)(compId.length() + 1))));
                if (colour) {
                    feedback.out().println(comp.displayableId() + " " + CliColour.YELLOW.applyColourANSI(metadataString));
                    continue;
                }
                feedback.out().println(comp.displayableId() + " [ " + metadataString + " ] ");
            }
            return IApplication.EXIT_OK;
        }
        catch (ParseCancellationException parseCancellationException) {
            return 1;
        }
    }

    public static ImmutableList<SearchedComponent> filter(String expression, Stream<SearchableComponent> components, final IUnifiedLogger logger) throws ParseCancellationException {
        ANTLRInputStream inputStream = new ANTLRInputStream(expression.trim());
        FilterGrammerLexer lexer = new FilterGrammerLexer((CharStream)inputStream);
        CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
        FilterGrammerParser parser = new FilterGrammerParser((TokenStream)tokens);
        parser.addErrorListener((ANTLRErrorListener)new BaseErrorListener(){

            public void syntaxError(Recognizer<?, ?> recognizer, Object offendingSymbol, int line, int charPositionInLine, String msg, RecognitionException e) {
                String fullMessage = "Cannot perform filter: line " + line + ":" + charPositionInLine + " " + msg;
                logger.userWarning(fullMessage, null);
                throw new ParseCancellationException(fullMessage);
            }
        });
        ImmutableList.Builder found = new ImmutableList.Builder();
        Iterator iter = components.iterator();
        while (iter.hasNext()) {
            SearchableComponent next = (SearchableComponent)iter.next();
            FilterGrammerParser.ProcessWithInputContext proc = parser.processWithInput(next, logger);
            SearchedComponent searched = UcCliFilter.singleFilter(next, proc);
            parser.reset();
            if (searched == null) continue;
            found.add((Object)searched);
        }
        return found.build();
    }

    private static SearchedComponent singleFilter(SearchableComponent component, FilterGrammerParser.ProcessWithInputContext proc) {
        if (proc.value instanceof FilterEngine.Compatible) {
            FilterEngine.Compatible procValue = (FilterEngine.Compatible)proc.value;
            boolean ret = procValue.isTrue();
            if (ret) {
                return new SearchedComponent(component, procValue.metadata());
            }
            return null;
        }
        if (Boolean.TRUE.equals(proc.value)) {
            return new SearchedComponent(component, (List<String>)ImmutableList.of());
        }
        if (Boolean.FALSE.equals(proc.value)) {
            return null;
        }
        throw new IllegalStateException("Failed to parse the expression, got " + String.valueOf(proc.value));
    }

    private static class AntlrConsumer
    implements CommandLine.IParameterConsumer {
        private AntlrConsumer() {
        }

        public void consumeParameters(Stack<String> args, CommandLine.Model.ArgSpec argSpec, CommandLine.Model.CommandSpec commandSpec) {
            StringBuilder exp = new StringBuilder();
            while (!args.isEmpty()) {
                String next = args.pop();
                String space = args.isEmpty() ? "" : " ";
                exp.append(next).append(space);
            }
            argSpec.setValue((Object)exp.toString());
        }
    }
}

