/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.uc.cli.internal.command;

import com.silabs.java.utils.Result;
import com.silabs.java.utils.TextUtils;
import com.silabs.ss.framework.uc.api.sdk.IUcSdk;
import com.silabs.ss.framework.uc.core.api.exception.UcException;
import com.silabs.ss.framework.uc.core.api.model.slcw.IUcWorkspace;
import com.silabs.ss.framework.uc.core.api.model.slcw.IUcWorkspaceIncludedProject;
import com.silabs.ss.framework.uc.core.api.model.slcw.IUcWorkspaceMutable;
import com.silabs.uc.cli.internal.command.CliRoot;
import com.silabs.uc.cli.internal.command.exception.SdkRequiredException;
import com.silabs.uc.cli.internal.command.mixin.CliForce;
import com.silabs.uc.cli.internal.command.mixin.CliGenerate;
import com.silabs.uc.cli.internal.command.mixin.CliProjectOrWorkspaceImplicit;
import com.silabs.uc.cli.internal.command.mixin.CliSdk;
import com.silabs.uc.cli.internal.command.mixin.CliSlcSdk;
import com.silabs.uc.cli.internal.command.model.SltSdkFeatures;
import com.silabs.uc.cli.internal.model.ICliOutput;
import com.silabs.uc.cli.internal.model.ShowSdkWarnings;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import picocli.CommandLine;

@CommandLine.Command(name="generate", description={"Generate a single project or workspace with specified projects based on an 'sdk' location and 'proj' project file/folder location."})
public final class UcCliGenerate
implements Callable<Integer> {
    @CommandLine.Mixin
    private CliGenerate cliGenerate;
    @CommandLine.Mixin
    private CliProjectOrWorkspaceImplicit projectOrWorkspaceBase;
    @CommandLine.Mixin
    private CliSdk sdkBase;
    @CommandLine.Mixin
    private CliSlcSdk ptcSdkBase;
    @CommandLine.Mixin
    private CliForce force;
    @CommandLine.ParentCommand
    private CliRoot root;

    @Override
    public Integer call() throws Exception {
        ICliOutput feedback = this.root.feedback(this.cliGenerate.getCliConfig());
        IUcSdk sdk = this.getSdk(feedback);
        if (!this.cliGenerate.validateExtraArgs(this.root)) {
            return -1;
        }
        boolean isWorkspaceOperation = this.projectOrWorkspaceBase.isWorkspaceOperation();
        SltSdkFeatures sltFeatures = SltSdkFeatures.fromMixin(this.sdkBase, feedback);
        if (isWorkspaceOperation) {
            return this.runWorkspaceGeneration(sdk, feedback, sltFeatures);
        }
        return this.cliGenerate.runProjectGenerationNoWorkspace(this.projectOrWorkspaceBase, sdk, feedback, sltFeatures, this.force.forceOperations());
    }

    public IUcSdk getSdk(ICliOutput feedback) {
        return this.ptcSdkBase.loadPtcSdk(feedback, this.sdkBase, ShowSdkWarnings.DO_NOT_SHOW_WARNINGS).orElseThrow(SdkRequiredException::new);
    }

    private Integer runWorkspaceGeneration(IUcSdk sdk, ICliOutput feedback, SltSdkFeatures sltFeatures) {
        Result<IUcWorkspace, ? extends UcException> workspace = this.projectOrWorkspaceBase.loadWorkspace(sdk, feedback, this.force.forceOperations());
        if (!workspace.isOK()) {
            return ((UcException)workspace.error()).exitCode();
        }
        IUcWorkspaceMutable loadedWorkspace = (IUcWorkspaceMutable)((IUcWorkspace)workspace.okValue()).mutable().orElseThrow(() -> new UcException("Failed to load mutable workspace.", -5));
        String dest = this.projectOrWorkspaceBase.destination();
        if (!TextUtils.isEmpty((String)dest)) {
            loadedWorkspace.mutable().ifPresent(mutableWorkspace -> {
                Path wrkDest = feedback.resolve(dest);
                mutableWorkspace.setGenerationDirectory(wrkDest);
            });
        }
        List<String> projectIds = this.projectOrWorkspaceBase.projectIdsInWorkspace();
        ArrayList<IUcWorkspaceIncludedProject> projectsToGenerate = new ArrayList<IUcWorkspaceIncludedProject>();
        if (projectIds == null) {
            projectsToGenerate.addAll((Collection<IUcWorkspaceIncludedProject>)loadedWorkspace.projects());
        } else {
            for (String projectId : projectIds) {
                IUcWorkspaceIncludedProject projInWorkspace = (IUcWorkspaceIncludedProject)loadedWorkspace.projectById(projectId).orElseThrow(() -> this.missingProjectException(projectId));
                projectsToGenerate.add(projInWorkspace);
            }
        }
        Path workspaceLocation = (Path)loadedWorkspace.backingFile().orElseThrow(() -> new UcException("Missing workspace file path! This is likely an internal error.", -5));
        return this.cliGenerate.runProjectGenerationWithWorkspace(this.projectOrWorkspaceBase, loadedWorkspace, sdk, projectsToGenerate, workspaceLocation.getParent(), this.projectOrWorkspaceBase.destination(), feedback, sltFeatures, this.force.forceOperations());
    }

    private UcException missingProjectException(String projectId) {
        Object msg = projectId == null ? "all projects" : "project '" + projectId + "'";
        return new UcException("Failed to load " + (String)msg + " from workspace at " + this.projectOrWorkspaceBase.workspaceLocation(), -6);
    }
}

