/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.uc.cli.internal.command;

import com.silabs.java.utils.FileUtils;
import com.silabs.java.utils.TextUtils;
import com.silabs.java.utils.preferences.PropertyReference;
import com.silabs.ss.framework.uc.core.api.exception.UcException;
import com.silabs.ss.platform.api.content.core.asset.AssetUtilities;
import com.silabs.ss.platform.api.demos.core.DemoModelUtils;
import com.silabs.ss.platform.api.demos.core.DemoProperties;
import com.silabs.ss.platform.api.demos.core.IDemoDescriptor;
import com.silabs.ss.platform.api.descriptor.core.DescriptorUtils;
import com.silabs.ss.platform.api.descriptor.core.IDescriptor;
import com.silabs.ss.platform.api.descriptor.core.IVersionedDescriptor;
import com.silabs.ss.platform.api.descriptor.core.property.CoreProperties;
import com.silabs.ss.platform.api.descriptor.core.registry.IRegistry;
import com.silabs.ss.platform.api.descriptor.core.registry.RegistryUtils;
import com.silabs.ss.platform.api.descriptor.core.type.CoreTypes;
import com.silabs.ss.platform.api.rcp.core.IPathUtils;
import com.silabs.ss.platform.api.sdk.core.ISDKDescriptor;
import com.silabs.ss.platform.api.sdk.core.SDKProperties;
import com.silabs.ss.platform.api.sdk.core.protocol.IProtocolDescriptor;
import com.silabs.ss.platform.api.sdk.core.protocol.Protocol;
import com.silabs.ss.platform.api.sdk.core.protocol.ProtocolProperties;
import com.silabs.uc.cli.internal.command.CliRoot;
import com.silabs.uc.cli.internal.command.exception.SdkRequiredException;
import com.silabs.uc.cli.internal.command.mixin.BaseOptions;
import com.silabs.uc.cli.internal.command.mixin.CliSdk;
import com.silabs.uc.cli.internal.model.CliSessionData;
import com.silabs.uc.cli.internal.model.ICliOutput;
import com.silabs.uc.cli.internal.model.SdkDescriptorWithPath;
import com.silabs.uc.cli.internal.util.CliColour;
import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.core.runtime.IPath;
import org.osgi.framework.Version;
import picocli.CommandLine;

@CommandLine.Command(name="demo-sdk", hidden=true, description={"Generate the Demos-Only SDK layout from a released Silabs SDK"})
public final class UcCliGenerateDemoSdk
implements Callable<Integer> {
    private static final String DEMO_SDK_ID = "com.silabs.sdk.demo_sdk";
    private static final String DEMO_SDK_LABEL = "Simplicity Demos";
    private static final String DEMO_SDK_DESCRIPTION = "SDK that provides demos from the latest Silicon Labs SDK release";
    private static final String DEMO_SDK_PART_COMPAT = "mcu.arm.*";
    private static final String DEMO_SDK_BOARD_COMPAT = ".*";
    private static final String DEMO_FILES_KEY = "prop.file.demosFile";
    private static final String CONNECTIVITY_FIRMWARE_KEY = "prop.file.connectivityFirmwareFolders";
    private static final String CONNECTIVITY_FIRMWARE_ASSET_VALUE = "asset://extension.wiseconnect_%s/connectivity_firmware";
    @CommandLine.Mixin
    private BaseOptions cliConfig;
    @CommandLine.Option(names={"-d", "--destination"}, required=true, description={"The location to generate the SDK into. If a demo sdk already exists, then the demos files will be merged."})
    private String destination;
    @CommandLine.Mixin
    public CliSdk sdkBase;
    @CommandLine.Option(names={"-e", "--extension-paths"}, description={"Paths to any extensions that should be "})
    private List<String> extensions = List.of();
    @CommandLine.ParentCommand
    private CliRoot root;

    @Override
    public Integer call() throws Exception {
        Properties demoSdkProperties;
        ICliOutput feedback = this.root.feedback(this.cliConfig);
        Path outputFolder = feedback.resolve(this.destination);
        if (!outputFolder.getParent().toFile().isDirectory()) {
            throw new UcException("Destination folder should exist at " + this.destination, -8);
        }
        Files.createDirectories(outputFolder, new FileAttribute[0]);
        Optional<ISDKDescriptor> sdkOpt = this.sdkBase.loadSdkDescriptor(feedback).flatMap(SdkDescriptorWithPath::sdkDescriptor);
        if (sdkOpt.isEmpty() && TextUtils.hasContent((String)this.sdkBase.sdkPath())) {
            throw new SdkRequiredException();
        }
        Collection<IProtocolDescriptor> protocols = this.loadProtocols(sdkOpt, feedback);
        File sdkDefinitionFile = outputFolder.resolve(".properties").toFile();
        Properties properties = demoSdkProperties = sdkDefinitionFile.isFile() ? FileUtils.readProperties((File)sdkDefinitionFile) : new Properties();
        if (!sdkDefinitionFile.isFile() && sdkOpt.isEmpty()) {
            throw new SdkRequiredException();
        }
        Collection existingDemoFiles = (Collection)SDKProperties.DEMOS_FILES.type().convert(demoSdkProperties.getProperty(DEMO_FILES_KEY));
        Map<File, SdkDemoContainer> demoFiles = existingDemoFiles.stream().map(IPath::toString).map(outputFolder::resolve).collect(Collectors.toMap(Path::toFile, SdkDemoContainer::new));
        demoSdkProperties.put("id", DEMO_SDK_ID);
        sdkOpt.ifPresent(sdk -> {
            Object object = demoSdkProperties.put("version", sdk.getVersionLabel());
        });
        demoSdkProperties.put("label", DEMO_SDK_LABEL);
        demoSdkProperties.put("description", DEMO_SDK_DESCRIPTION);
        demoSdkProperties.put("prop.partCompatibility", DEMO_SDK_PART_COMPAT);
        demoSdkProperties.put("prop.boardCompatibility", DEMO_SDK_BOARD_COMPAT);
        this.printHeader(feedback, "~~~~~ Generating Demos SDK Content ~~~~~");
        UcCliGenerateDemoSdk.println(feedback, "SDK File: ", sdkDefinitionFile.getAbsolutePath());
        sdkOpt.ifPresent(sdk -> {
            this.injectDemos(feedback, outputFolder, (IVersionedDescriptor)sdk, demoFiles);
            this.injectProperties(feedback, demoSdkProperties, protocols);
        });
        for (IProtocolDescriptor protocol : protocols) {
            this.injectDemos(feedback, outputFolder, (IVersionedDescriptor)protocol, demoFiles);
        }
        List<IPath> demoPaths = demoFiles.values().stream().map(this::writeDemos).flatMap(Optional::stream).sorted().peek(c -> c.printStatus(feedback)).map(SdkDemoContainer::demoPath).toList();
        demoSdkProperties.put(DEMO_FILES_KEY, SDKProperties.DEMOS_FILES.type().stringize(demoPaths));
        sdkDefinitionFile.createNewFile();
        FileUtils.writeProperties((Properties)demoSdkProperties, (File)sdkDefinitionFile);
        return 0;
    }

    private Collection<IProtocolDescriptor> loadProtocols(Optional<ISDKDescriptor> sdkOpt, ICliOutput feedback) {
        LinkedHashSet<IProtocolDescriptor> protocols = new LinkedHashSet<IProtocolDescriptor>();
        ISDKDescriptor sdk = sdkOpt.orElse(null);
        if (sdk != null) {
            Stream.of(Protocol.registry().getForSDK(sdk)).filter(p -> this.isExternalProtocol(sdk, (IProtocolDescriptor)p)).forEachOrdered(protocols::add);
        }
        for (String extension : this.extensions) {
            Path extFile = feedback.resolve(extension);
            IProtocolDescriptor[] protos = (IProtocolDescriptor[])RegistryUtils.detectInDirectory((IRegistry)Protocol.registry(), (File)extFile.toFile(), (boolean)false, null);
            if (protos.length == 0) {
                throw new UcException("Extension cannot be loaded from " + String.valueOf(extFile), -8);
            }
            protocols.addAll(Arrays.asList(protos));
        }
        return protocols;
    }

    private boolean isExternalProtocol(ISDKDescriptor sdk, IProtocolDescriptor proto) {
        return DescriptorUtils.getInstallPath((IDescriptor)sdk).map(IPath::toFile).filter(p -> !this.isFromExternalProtocol((IVersionedDescriptor)sdk, (File)p)).isPresent();
    }

    private void injectDemos(ICliOutput feedback, Path outputFolder, IVersionedDescriptor sdk, Map<File, SdkDemoContainer> demoFiles) {
        List<IDemoDescriptor> demos = ((Collection)sdk.getProperty(SDKProperties.DEMOS_FILES)).stream().map(IPath::toFile).filter(File::isFile).filter(f -> this.isFromExternalProtocol(sdk, (File)f)).flatMap(this::loadDemos).filter(d -> this.warnNonAssetDemo(feedback, d.demo)).map(d -> this.handleExtraFiles(feedback, outputFolder, (DemoModel)d)).map(DemoModel::demo).toList();
        File demoFile = outputFolder.resolve(this.labelToName(sdk.getUnversionedId())).toFile();
        demoFiles.compute(demoFile, (f, c) -> SdkDemoContainer.merge(f, sdk, c)).demos().addAll(demos);
    }

    private String createConnectivityFirmwareProperty(IProtocolDescriptor protocol) {
        Version v = protocol.getVersion();
        if (v != null) {
            return String.format(CONNECTIVITY_FIRMWARE_ASSET_VALUE, new Version(v.getMajor(), v.getMinor(), v.getMicro()));
        }
        return "";
    }

    private void injectProperties(ICliOutput feedback, Properties properties, Collection<IProtocolDescriptor> protocols) {
        ArrayList<String> allProps = new ArrayList<String>();
        for (IProtocolDescriptor protocol : protocols) {
            Collection props = (Collection)protocol.getProperty(ProtocolProperties.CONNECTIVITY_FIRMWARE);
            if (props == null) continue;
            allProps.addAll(props.stream().map(u -> u.toString().startsWith("asset://") ? u.toString() : this.createConnectivityFirmwareProperty(protocol)).toList());
        }
        if (!allProps.isEmpty()) {
            properties.put(CONNECTIVITY_FIRMWARE_KEY, String.join((CharSequence)" ", allProps));
        }
    }

    private Optional<SdkDemoContainer> writeDemos(SdkDemoContainer container) {
        Collection<IDemoDescriptor> demos = container.demos();
        File demoFile = container.demoFile();
        if (demos.isEmpty()) {
            if (demoFile.isFile()) {
                demoFile.delete();
            }
            return Optional.empty();
        }
        try {
            DemoModelUtils.saveDescriptorsToFile((File)demoFile, demos);
        }
        catch (IOException e) {
            throw new UcException("Failed to write demo file: " + demoFile.toString(), (Throwable)e);
        }
        return Optional.of(container);
    }

    private boolean isFromExternalProtocol(IVersionedDescriptor desc, File demoFile) {
        if (desc instanceof IProtocolDescriptor) {
            return true;
        }
        Path sdkInstallPath = DescriptorUtils.getInstallPath((IDescriptor)desc).map(p -> p.toFile().toPath()).orElse(null);
        if (sdkInstallPath == null) {
            return true;
        }
        Path demoPath = demoFile.toPath().normalize();
        if (!demoPath.startsWith(sdkInstallPath)) {
            return false;
        }
        Path extensionFolder = sdkInstallPath.resolve("extension").normalize();
        return !demoPath.startsWith(extensionFolder);
    }

    private Stream<DemoModel> loadDemos(File file) {
        return DemoModelUtils.createDescriptorsFromFile((File)file).stream().map(d -> new DemoModel((IDemoDescriptor)d, file));
    }

    private boolean warnNonAssetDemo(ICliOutput feedback, IDemoDescriptor demo) {
        String demoLoc = demo.getPropertyAccess().getValueString(DemoProperties.IMAGE_FILE);
        if (!demoLoc.startsWith("asset:")) {
            String demoInstall = demo.getPropertyAccess().getValueString(CoreProperties.INSTALLATION_PATH);
            feedback.unifiedLogger().userWarning("Non asset demo " + demo.getLabel() + " found at " + demoInstall, null);
            return false;
        }
        return true;
    }

    private DemoModel handleExtraFiles(ICliOutput feedback, Path outputFolder, DemoModel demo) {
        this.updateReadme(feedback, outputFolder, demo);
        this.copyPropertyFile(feedback, outputFolder, demo, DemoProperties.ENCRYPTION_KEY);
        this.copyPropertyFile(feedback, outputFolder, demo, DemoProperties.SIGNING_KEY);
        return demo;
    }

    private void updateReadmeImages(ICliOutput feedback, Path outputFile, Path readmeFolder, String subFolder) {
        Path imageFolder = readmeFolder.resolve(subFolder);
        if (Files.isDirectory(imageFolder, new LinkOption[0])) {
            try {
                FileUtils.copyTree((File)imageFolder.toFile(), (File)outputFile.resolve(subFolder).toFile(), null);
            }
            catch (IOException e) {
                feedback.err().println("Failed to copy readme images from " + String.valueOf(imageFolder));
                feedback.unifiedLogger().internalError("Failed to copy readme images from " + String.valueOf(imageFolder), (Throwable)e);
            }
        }
    }

    private DemoModel updateReadme(ICliOutput feedback, Path outputFolder, DemoModel demo) {
        String readmeProp = demo.demo.getPropertyAccess().getValueString(CoreProperties.README_FILES);
        Collection readmeFiles = (Collection)CoreTypes.STRING_LIST.convert(readmeProp);
        for (String readme : readmeFiles) {
            Path readmeFile = this.copyPropertyFile(feedback, outputFolder, readme, demo).orElse(null);
            if (readmeFile == null) continue;
            Path readmeFolder = readmeFile.getParent();
            Path outputFile = outputFolder.resolve(readme).getParent();
            Stream.of(readmeFolder.toFile().listFiles()).filter(f -> f.getName().endsWith(".png")).forEach(p -> {
                boolean bl = this.copyFile(feedback, p.toPath(), outputFile.resolve(p.getName()));
            });
            this.updateReadmeImages(feedback, outputFile, readmeFolder, "image");
            this.updateReadmeImages(feedback, outputFile, readmeFolder, "resources/readme");
        }
        return demo;
    }

    private void copyPropertyFile(ICliOutput feedback, Path outputFolder, DemoModel demo, PropertyReference<?> prop) {
        String file = demo.demo.getPropertyAccess().getValueString(prop);
        if (TextUtils.isEmpty((String)file)) {
            return;
        }
        this.copyPropertyFile(feedback, outputFolder, file, demo);
    }

    private Optional<Path> copyPropertyFile(ICliOutput feedback, Path outputFolder, String fileStr, DemoModel demo) {
        if (AssetUtilities.isAssetURI((String)fileStr)) {
            return Optional.empty();
        }
        Path realFile = new File(demo.root.getParent(), fileStr).toPath();
        if (!Files.isRegularFile(realFile, new LinkOption[0])) {
            feedback.err().println("Missing data file " + String.valueOf(realFile));
            return Optional.empty();
        }
        Path outputFile = outputFolder.resolve(fileStr);
        if (this.copyFile(feedback, realFile, outputFile)) {
            return Optional.of(realFile);
        }
        return Optional.empty();
    }

    private boolean copyFile(ICliOutput feedback, Path toCopy, Path outputFile) {
        if (Files.isRegularFile(outputFile, new LinkOption[0])) {
            return false;
        }
        try {
            Files.createDirectories(outputFile.getParent(), new FileAttribute[0]);
            Files.copy(toCopy, outputFile, new CopyOption[0]);
        }
        catch (IOException iOException) {
            feedback.err().println("Failed to copy readme content from " + String.valueOf(toCopy));
            return false;
        }
        return true;
    }

    private String labelToName(String label) {
        String baseId = label.replace("com.silabs.sdk.stack.", "").replace("com.silabs.sdk.", "").replace("uc.extension.", "").replaceAll("\\W", "_");
        return baseId + ".demos";
    }

    private void printHeader(ICliOutput feedback, String header) {
        CliSessionData session = feedback.session();
        feedback.out().println(session.colourIfNeeded(header, CliColour.GREEN));
    }

    private static void println(ICliOutput feedback, String label, String info) {
        CliSessionData session = feedback.session();
        String output = session.colourIfNeeded(label, CliColour.YELLOW) + info;
        feedback.out().println(output);
    }

    private record DemoModel(IDemoDescriptor demo, File root) {
    }

    private record SdkDemoContainer(IVersionedDescriptor sdk, File demoFile, Collection<IDemoDescriptor> demos, IPath demoPath) implements Comparable<SdkDemoContainer>
    {
        public SdkDemoContainer(Path demoFile) {
            this(demoFile.toFile(), null);
        }

        public SdkDemoContainer(File demoFile, IVersionedDescriptor sdk) {
            this(sdk, demoFile, new LinkedHashSet<IDemoDescriptor>(), IPathUtils.create((String)demoFile.getName()));
        }

        public void printStatus(ICliOutput feedback) {
            Object message = "SDK Demos File: ";
            if (this.sdk instanceof IProtocolDescriptor) {
                message = this.sdk.getLabel() + " Demos File: ";
            }
            UcCliGenerateDemoSdk.println(feedback, (String)message, this.demoFile.getAbsolutePath());
        }

        public static SdkDemoContainer merge(File demoFile, IVersionedDescriptor sdk, SdkDemoContainer oldContainer) {
            if (oldContainer == null) {
                return new SdkDemoContainer(demoFile, sdk);
            }
            SdkDemoContainer container = oldContainer;
            if (oldContainer.sdk == null) {
                container = new SdkDemoContainer(demoFile, sdk);
                container.demos.addAll(oldContainer.demos);
            }
            return container;
        }

        @Override
        public int compareTo(SdkDemoContainer o) {
            if (this.sdk instanceof IProtocolDescriptor) {
                return 1;
            }
            if (o.sdk instanceof IProtocolDescriptor) {
                return -1;
            }
            return this.demoFile.compareTo(o.demoFile);
        }
    }
}

