/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.uc.cli.internal.command;

import com.google.common.base.Strings;
import com.silabs.java.utils.StreamUtils;
import com.silabs.ss.framework.uc.api.python.validator.ConfigValidationIssue;
import com.silabs.ss.framework.uc.core.api.comp.ValidationScript;
import com.silabs.ss.framework.uc.core.api.log.IUnifiedLogger;
import com.silabs.ss.framework.uc.internal.api.project.setup.UcConfigurationValidator;
import com.silabs.ss.framework.uc.internal.api.python.validator.PyProjectValidation;
import com.silabs.ss.platform.api.rcp.core.CommonSplitters;
import com.silabs.uc.cli.internal.command.CliRoot;
import com.silabs.uc.cli.internal.command.UcCliPythonDryRunner;
import com.silabs.uc.cli.internal.command.mixin.BaseOptions;
import com.silabs.uc.cli.internal.command.mixin.PythonDryRunnerCommonOptions;
import com.silabs.uc.cli.internal.command.pyvalidate.PyComponentIdDryRun;
import com.silabs.uc.cli.internal.command.pyvalidate.PyConfigurableDryRun;
import com.silabs.uc.cli.internal.command.pyvalidate.PyValidationProjectDryRun;
import com.silabs.uc.cli.internal.model.ICliOutput;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.eclipse.equinox.app.IApplication;
import picocli.CommandLine;

@CommandLine.Command(name="validation-unit-test", description={"Dry run in unit test mode: no sdk is loaded so all component, #define, and additional metadata information must be from the command line. Intended for automated scripts for unit testing. Prefer validation_test if just trying to quickly test drive a validation script manually."})
public class UcCliPythonUnitDryRunner
implements Callable<Integer> {
    @CommandLine.Mixin
    private BaseOptions cliConfig;
    @CommandLine.Mixin
    private PythonDryRunnerCommonOptions dryOptions;
    @CommandLine.ParentCommand
    private CliRoot root;
    @CommandLine.Option(names={"-tie-comp", "--tie-component"}, description={"comma separated list of #define names, along with a space and the component that houses the #define. (e.g -tie \"OS_ENABLE_SEMAPHORES micriumos, CLK_SPEED some_clk_component_thing\")"}, paramLabel="TIE_COMPONENTS")
    private String tieComponents;
    @CommandLine.Option(names={"-tie-config", "--tie-configuration"}, description={"comma separated list of #define names, along with a space and the configuration file name they come from. This sets the file_name()"}, paramLabel="TIE_CONFIGURATION")
    private String tieConfiguration;
    @CommandLine.Option(names={"-unsel", "--unselected"}, description={"comma separated list component ids that should exist but are not selected by the project"}, paramLabel="UNSELECTED")
    private String unselected;

    @Override
    public Integer call() {
        ICliOutput feedback = this.root.feedback(this.cliConfig);
        return this.handleTest(feedback);
    }

    private int handleTest(ICliOutput feedback) {
        String defineName;
        List tieList;
        PyValidationProjectDryRun pyProject = new PyValidationProjectDryRun(null);
        Path validationScript = feedback.resolve(this.dryOptions.scriptPath());
        if (!Files.exists(validationScript, new LinkOption[0])) {
            feedback.out().println(validationScript.toAbsolutePath().toString() + "Does not exist.");
            return -1;
        }
        Set<ValidationScript> libraries = UcCliPythonDryRunner.parseLibraries(this.dryOptions.libraries(), feedback);
        for (ValidationScript lib : libraries) {
            if (Files.exists(lib.script(), new LinkOption[0])) continue;
            feedback.out().println(lib.script().toAbsolutePath().toString() + "Does not exist.");
            return -1;
        }
        pyProject.setProvided(this.dryOptions.apiAdd().stream().collect(Collectors.toSet()));
        this.cutCsv(this.unselected).forEach(pyProject::registerComponentToSdk);
        this.cutCsv(this.dryOptions.componentIds()).forEach(sel -> {
            Iterator compInsta = UcCliPythonDryRunner.SPACE.split((CharSequence)sel).iterator();
            String componentName = (String)compInsta.next();
            PyComponentIdDryRun pyComp = pyProject.selectComponent(componentName);
            ArrayList<String> instances = new ArrayList<String>();
            while (compInsta.hasNext()) {
                String nextInstance = (String)compInsta.next();
                instances.add(nextInstance);
                pyComp.addInstance(nextInstance);
            }
        });
        HashMap<String, PyConfigurableDryRun> generatedConfigs = new HashMap<String, PyConfigurableDryRun>();
        UcCliPythonDryRunner.parseDefines(this.dryOptions.componentDefines(), pyProject, generatedConfigs, feedback);
        for (String tie : StreamUtils.iterableOf(this.cutCsv(this.tieComponents))) {
            tieList = UcCliPythonDryRunner.SPACE.splitToList((CharSequence)tie);
            if (tieList.size() != 2) {
                feedback.out().println("Incorrect syntax: one #define separated by a space with one component name, but got " + tie);
                return -1;
            }
            defineName = (String)tieList.get(0);
            String componentId = (String)tieList.get(1);
            if (!generatedConfigs.containsKey(defineName)) {
                feedback.out().println("Define " + defineName + " not listed in 'define' list");
                return -1;
            }
            PyComponentIdDryRun pyComponent = pyProject.component(componentId);
            if (pyComponent == null) {
                feedback.out().println("Component " + componentId + " should be listed in either -sel or -unsel");
                return -1;
            }
            PyConfigurableDryRun configurable = pyProject.config(defineName);
            configurable.tieToComponent(pyComponent);
        }
        for (String tieConfig : StreamUtils.iterableOf(this.cutCsv(this.tieConfiguration))) {
            tieList = UcCliPythonDryRunner.SPACE.splitToList((CharSequence)tieConfig);
            if (tieList.size() != 2) {
                feedback.out().println("Incorrect syntax: one #define separated by a space with one config file name, but got " + tieConfig);
                return -1;
            }
            defineName = (String)tieList.get(0);
            String configFileName = (String)tieList.get(1);
            if (!generatedConfigs.containsKey(defineName)) {
                feedback.out().println("Define " + defineName + " not listed in 'define' list");
                return -1;
            }
            PyConfigurableDryRun configurable = pyProject.config(defineName);
            configurable.tieToFile(configFileName);
        }
        Path reportDestination = this.dryOptions.report() != null ? feedback.workingDirectory().resolve(this.dryOptions.report()) : null;
        String output = UcConfigurationValidator.customValidate(Collections.singletonList(ValidationScript.fromFile((Path)validationScript)), libraries, (PyProjectValidation)pyProject, (IUnifiedLogger)feedback.unifiedLogger()).map(ConfigValidationIssue::message).collect(Collectors.joining(System.lineSeparator()));
        feedback.out().println(output);
        UcCliPythonDryRunner.reportResults(reportDestination, output, feedback);
        return Strings.isNullOrEmpty((String)output) ? IApplication.EXIT_OK : -1;
    }

    private Stream<String> cutCsv(String optionValue) {
        if (Strings.isNullOrEmpty((String)optionValue)) {
            return Stream.empty();
        }
        return StreamSupport.stream(CommonSplitters.CSV.split((CharSequence)optionValue).spliterator(), false);
    }
}

