/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.uc.cli.internal.command;

import com.google.common.collect.ImmutableList;
import com.silabs.java.utils.TextUtils;
import com.silabs.ss.framework.uc.api.sdk.IUcSdk;
import com.silabs.ss.framework.uc.core.api.IComparableId;
import com.silabs.ss.framework.uc.core.api.IConditional;
import com.silabs.ss.framework.uc.core.api.IUcAdditionalFramework;
import com.silabs.ss.framework.uc.core.api.IUcCoreFramework;
import com.silabs.ss.framework.uc.core.api.IUcFramework;
import com.silabs.ss.framework.uc.core.api.IUcFrameworkCommon;
import com.silabs.ss.framework.uc.core.api.IUcProjectFramework;
import com.silabs.ss.framework.uc.core.api.UcProjectFramework;
import com.silabs.ss.framework.uc.core.api.comp.IUcComponent;
import com.silabs.ss.framework.uc.core.api.comp.IUcComponentContainer;
import com.silabs.ss.framework.uc.core.api.context.IUcSdkContent;
import com.silabs.ss.framework.uc.core.api.exception.UcConfigurationException;
import com.silabs.ss.framework.uc.core.api.exception.UcException;
import com.silabs.ss.framework.uc.core.api.log.IUnifiedLogger;
import com.silabs.ss.framework.uc.core.api.model.IUcProject;
import com.silabs.ss.framework.uc.core.api.model.IUcProjectMutable;
import com.silabs.ss.framework.uc.core.api.model.slcw.ISlcwRegistryMutable;
import com.silabs.ss.framework.uc.core.api.model.slcw.SlcwRegistryManager;
import com.silabs.ss.framework.uc.core.api.sbom.JinjaSbomOutput;
import com.silabs.ss.framework.uc.core.api.sbom.UcSbomGenerator;
import com.silabs.ss.framework.uc.core.api.sbom.UcSbomOutputTypes;
import com.silabs.ss.framework.uc.core.api.sdkextension.IUcSdkExtensionId;
import com.silabs.ss.framework.uc.core.api.sdkextension.IUcSdkExtensionSoftReference;
import com.silabs.ss.framework.uc.core.api.validate.sdk.SbomComponentValidation;
import com.silabs.ss.framework.uc.core.api.validate.sdk.SdkValidationIssue;
import com.silabs.ss.framework.uc.core.api.validate.sdk.SdkValidationResult;
import com.silabs.ss.framework.uc.core.api.validate.sdk.ValidationType;
import com.silabs.ss.framework.uc.core.internal.context.UcContext;
import com.silabs.uc.cli.internal.command.CliRoot;
import com.silabs.uc.cli.internal.command.exception.SdkRequiredException;
import com.silabs.uc.cli.internal.command.mixin.BaseOptions;
import com.silabs.uc.cli.internal.command.mixin.CliForce;
import com.silabs.uc.cli.internal.command.mixin.CliProject;
import com.silabs.uc.cli.internal.command.mixin.CliSdk;
import com.silabs.uc.cli.internal.command.mixin.CliSlcSdk;
import com.silabs.uc.cli.internal.command.model.SltSdkFeatures;
import com.silabs.uc.cli.internal.model.ICliOutput;
import com.silabs.uc.cli.internal.model.ShowSdkWarnings;
import com.silabs.uc.cli.internal.util.CliGenerator;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import picocli.CommandLine;

@CommandLine.Command(name="sbom", description={"Generate an SBOM file for the input components or project"})
public final class UcCliSbom
implements Callable<Integer> {
    @CommandLine.Mixin
    private BaseOptions cliConfig;
    @CommandLine.Mixin
    private CliProject projectBase;
    @CommandLine.Mixin
    private CliSdk sdkBase;
    @CommandLine.Mixin
    private CliSlcSdk ptcSdkBase;
    @CommandLine.Mixin
    private CliForce force;
    @CommandLine.ParentCommand
    private CliRoot root;
    @CommandLine.ArgGroup(exclusive=false, multiplicity="1..*")
    OutputFormats outputFormats;
    @CommandLine.Option(names={"-o", "--output"}, required=true, description={"The output folder to generate the SBOM files into."})
    private String outputFolder;
    @CommandLine.Option(names={"--no-autoselection"}, negatable=true, description={"Disable SLCC autoselection to only use the explicitly requested components. This will also disable any warnings about autoselection."})
    private boolean noAutoselection;
    @CommandLine.Option(names={"--all-components"}, split=",", description={"Add every component from a comma separated list of input SDK or extension path to the SBOM. This is a  utility command that's fully equivalent to '--with=<every_component>'. This cannot be specified with the -p command."})
    private List<String> allSdkComponents = List.of();

    @Override
    public Integer call() throws Exception {
        IUcSdk sdk;
        ICliOutput feedback = this.root.feedback(this.cliConfig);
        if (!this.allSdkComponents.isEmpty() && TextUtils.hasContent((String)this.projectBase.projectLocation())) {
            feedback.unifiedLogger().userError("--all-components and --project cannot both be specified.", null);
            return -8;
        }
        List<Object> templatePaths = List.of();
        if (this.outputFormats.templatePaths != null) {
            templatePaths = this.outputFormats.templatePaths.stream().map(feedback::resolve).toList();
            List<Path> errors = templatePaths.stream().filter(t -> !Files.isRegularFile(t, new LinkOption[0])).toList();
            if (!errors.isEmpty()) {
                throw new IllegalArgumentException("Requested template(s) do not exist at " + String.valueOf(errors));
            }
        }
        if (!UcSbomGenerator.canRun((IUcFrameworkCommon)(sdk = this.ptcSdkBase.loadPtcSdk(feedback, this.sdkBase, ShowSdkWarnings.DO_NOT_SHOW_WARNINGS).orElseThrow(SdkRequiredException::new)).framework())) {
            feedback.unifiedLogger().userError("SBOM is not supported outside of SLC Specification version 12. Please update your SDK.", null);
            return -8;
        }
        List<IUcComponent> components = this.findComponents(sdk, feedback);
        this.validateComponents(components, feedback);
        Path outputPath = feedback.resolve(this.outputFolder);
        Files.createDirectories(outputPath, new FileAttribute[0]);
        Collection<Path> outputFiles = this.runSbom(outputPath, templatePaths, components, feedback);
        if (!outputFiles.isEmpty()) {
            feedback.out().println("Generated:");
            outputFiles.forEach(p -> feedback.out().println(" - " + String.valueOf(p)));
        }
        return 0;
    }

    private List<IUcComponent> findComponents(IUcSdk sdk, ICliOutput feedback) throws UcConfigurationException {
        if (this.allSdkComponents.isEmpty()) {
            return this.projectComponents(sdk, feedback);
        }
        this.noAutoselection = true;
        List<IUcComponent> allComponents = this.allSdkComponents.stream().map(feedback::resolve).map(Path::normalize).map(p -> this.frameworkFromPath(sdk.framework(), (Path)p)).flatMap(IUcComponentContainer::allComponents).sorted(this::compareComps).toList();
        return allComponents;
    }

    private List<IUcComponent> projectComponents(IUcSdk sdk, ICliOutput feedback) throws UcConfigurationException {
        SltSdkFeatures sltFeatures = SltSdkFeatures.fromMixin(this.sdkBase, feedback);
        Optional<IUcProjectMutable> projOpt = this.projectBase.loadProject((IUcSdkContent)sdk, feedback, sltFeatures, true, false, true, this.force.forceOperations());
        if (projOpt.isEmpty() && TextUtils.hasContent((String)this.projectBase.projectLocation())) {
            throw new UcException("Failed to load requested project. Exiting.", -8);
        }
        IUcProjectMutable project = projOpt.orElseGet(() -> this.createFakeProject(sdk, feedback));
        IUcProjectFramework framework = this.framework(sdk, (IUcProject)project, feedback);
        project.setUcFramework(framework);
        this.projectBase.runCliProjectModifications(project, sltFeatures, true, this.force.forceOperations(), false, feedback);
        return this.projectComponents((IUcProject)project, feedback);
    }

    private IUcProjectMutable createFakeProject(IUcSdk sdk, ICliOutput feedback) {
        Path fakeDir = feedback.resolve("temp.slcp");
        IUcProjectMutable project = (IUcProjectMutable)UcContext.existingContext((IUcSdkContent)sdk, (boolean)false, (Path)fakeDir, (Path)fakeDir, (boolean)false, (ISlcwRegistryMutable)SlcwRegistryManager.primaryRegistry(), (IUnifiedLogger)feedback.unifiedLogger()).setupData(IUcProject.SETUP_ID);
        return project;
    }

    private IUcProjectFramework framework(IUcSdk sdk, IUcProject project, ICliOutput feedback) {
        ImmutableList sdkExts = project.requestedSdkExtensions();
        HashMap<IUcSdkExtensionSoftReference, IUcAdditionalFramework> exts = new HashMap<IUcSdkExtensionSoftReference, IUcAdditionalFramework>();
        for (Map.Entry entry : sdk.framework().sdkExtensions().entrySet()) {
            exts.compute(((IUcSdkExtensionId)entry.getKey()).softRef(), (k, e) -> {
                if (e == null) {
                    return (IUcAdditionalFramework)entry.getValue();
                }
                if (sdkExts.contains((Object)e.extensionId())) {
                    return e;
                }
                if (sdkExts.contains(entry.getKey())) {
                    return (IUcAdditionalFramework)entry.getValue();
                }
                if (((IUcAdditionalFramework)entry.getValue()).semVersion().compareTo(e.semVersion()) > 0) {
                    return (IUcAdditionalFramework)entry.getValue();
                }
                return e;
            });
        }
        return UcProjectFramework.createWithSdkExtensions((IUcFramework)sdk.framework(), exts.values(), (boolean)false);
    }

    private IUcFrameworkCommon frameworkFromPath(IUcFramework fwk, Path fwkPath) {
        if (Objects.equals(fwk.directory().toPath(), fwkPath)) {
            return fwk;
        }
        return (IUcFrameworkCommon)fwk.sdkExtensions().values().stream().filter(f -> Objects.equals(f.directory().toPath(), fwkPath)).findFirst().orElseThrow(() -> new UcException("Failed to find SDK or Extension for " + String.valueOf(fwkPath), -8));
    }

    private List<IUcComponent> projectComponents(IUcProject project, ICliOutput feedback) {
        project.autoSelect();
        Stream<String> projectComponentStream = project.selectedComponents().map(IConditional::data);
        if (this.noAutoselection) {
            projectComponentStream = projectComponentStream.filter(c -> project.selectionMetaFor(c).isUserSelected());
        } else if (!CliGenerator.internalValidationApi(project, feedback) && !this.force.forceOperations()) {
            throw new UcException("Component autoselection errors exist. Either fix them, list every required component and use '--no-autoselection', or use '--force' to ignore the errors");
        }
        return projectComponentStream.flatMap(c -> project.ucFramework().findComponent(c).stream()).sorted(this::compareComps).toList();
    }

    private int compareComps(IUcComponent comp1, IUcComponent comp2) {
        if (!Objects.equals(comp1.framework(), comp2.framework())) {
            if (comp1.framework() instanceof IUcCoreFramework) {
                return -1;
            }
            if (comp2.framework() instanceof IUcCoreFramework) {
                return 1;
            }
            return comp1.framework().frameworkId().compareTo((IComparableId)comp2.framework().frameworkId());
        }
        return comp1.id().compareTo(comp2.id());
    }

    private void validateComponents(Collection<IUcComponent> components, ICliOutput feedback) {
        if (components.isEmpty()) {
            return;
        }
        SdkValidationResult results = SbomComponentValidation.validate(components);
        if (results.passed()) {
            return;
        }
        feedback.out().println("WARNING: Some Components had invalid SBOM metadata");
        feedback.out().println("The output SBOM files may be invalid or incomplete.");
        for (SdkValidationIssue issue : results.isssuesForType(ValidationType.SBOM_METADATA)) {
            List affectedComponents = issue.affected().stream().limit(3L).collect(Collectors.toList());
            StringBuilder sb = new StringBuilder(" - ").append(issue.issueOnly()).append(issue.partialMessage(affectedComponents));
            feedback.out().println(sb);
        }
        feedback.out().println();
    }

    private Collection<Path> runSbom(Path outputPath, Collection<Path> templatePaths, List<IUcComponent> components, ICliOutput feedback) {
        UcSbomGenerator generator = UcSbomGenerator.create().addComponent(components);
        this.outputFormats.outputs().stream().map(c -> c.create(outputPath)).forEachOrdered(arg_0 -> ((UcSbomGenerator)generator).addOutput(arg_0));
        templatePaths.stream().map(t -> new JinjaSbomOutput(t, outputPath.resolve(t.getFileName().toString().replace(".jinja", "")))).forEachOrdered(arg_0 -> ((UcSbomGenerator)generator).addOutput(arg_0));
        return generator.generate();
    }

    static class OutputFormats {
        @CommandLine.Option(names={"--cyclone-xml"}, description={"The CycloneDX XML output format."})
        private boolean cycloneXml;
        @CommandLine.Option(names={"--cyclone-json"}, description={"The CycloneDX JSON output format."})
        private boolean cycloneJson;
        @CommandLine.Option(names={"--spdx-default"}, description={"The SPDX default (tag:value) output format."})
        private boolean spdxDefault;
        @CommandLine.Option(names={"--spdx-json"}, description={"The SPDX JSON output format."})
        private boolean spdxJson;
        @CommandLine.Option(names={"--template"}, description={"A custom Jinja formatted template to generate for."})
        private List<String> templatePaths;

        OutputFormats() {
        }

        private Collection<UcSbomOutputTypes> outputs() {
            ArrayList<UcSbomOutputTypes> outputs = new ArrayList<UcSbomOutputTypes>();
            if (this.cycloneJson) {
                outputs.add(UcSbomOutputTypes.CycloneDX_Json);
            }
            if (this.cycloneXml) {
                outputs.add(UcSbomOutputTypes.CycloneDX_Xml);
            }
            if (this.spdxDefault) {
                outputs.add(UcSbomOutputTypes.SPDX_Default);
            }
            if (this.spdxJson) {
                outputs.add(UcSbomOutputTypes.SPDX_JSON);
            }
            if (UcSbomOutputTypes.values().length != 4) {
                throw new IllegalStateException("New SBOM output type not added. Please add a CLI command for it.");
            }
            return outputs;
        }
    }
}

