/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.uc.cli.internal.command;

import com.silabs.java.utils.FileUtils;
import com.silabs.ss.framework.uc.api.sdk.IUcSdk;
import com.silabs.ss.platform.api.sdk.core.ISDKDescriptor;
import com.silabs.ss.platform.api.sdk.core.SDKUtils;
import com.silabs.ss.platform.api.sdk.core.protocol.IProtocolDescriptor;
import com.silabs.ss.platform.api.sdk.core.protocol.Protocol;
import com.silabs.uc.cli.internal.command.CliRoot;
import com.silabs.uc.cli.internal.command.exception.SdkRequiredException;
import com.silabs.uc.cli.internal.command.mixin.BaseOptions;
import com.silabs.uc.cli.internal.command.mixin.CliSdk;
import com.silabs.uc.cli.internal.command.mixin.CliSlcSdk;
import com.silabs.uc.cli.internal.model.CliSessionData;
import com.silabs.uc.cli.internal.model.ICliOutput;
import com.silabs.uc.cli.internal.model.ShowSdkWarnings;
import com.silabs.uc.cli.internal.util.CliColour;
import java.io.IOException;
import java.nio.file.Path;
import java.util.concurrent.Callable;
import java.util.stream.Stream;
import org.eclipse.equinox.app.IApplication;
import picocli.CommandLine;

@CommandLine.Command(name="summarize-sdk", aliases={"summarise-sdk"}, description={"Prints a summary of the input SDK"})
public class UcCliSdkSummary
implements Callable<Integer> {
    @CommandLine.Mixin
    private BaseOptions cliConfig;
    @CommandLine.Mixin
    private CliSdk sdkBase;
    @CommandLine.Mixin
    private CliSlcSdk ptcSdkBase;
    @CommandLine.ParentCommand
    private CliRoot root;

    @Override
    public Integer call() {
        ICliOutput feedback = this.root.feedback(this.cliConfig);
        IUcSdk sdk = this.ptcSdkBase.loadPtcSdk(feedback, this.sdkBase, ShowSdkWarnings.DO_NOT_SHOW_WARNINGS).orElseThrow(SdkRequiredException::new);
        ISDKDescriptor parentSdk = UcCliSdkSummary.printSdkInformation(sdk, feedback);
        if (parentSdk == null) {
            return IApplication.EXIT_OK;
        }
        IProtocolDescriptor[] protocols = Protocol.registry().getForSDK(parentSdk);
        if (protocols.length > 0) {
            UcCliSdkSummary.printHeader(feedback, "--------- Protocols ---------");
            Stream.of(protocols).forEach(p -> {
                UcCliSdkSummary.println(feedback, "- Protocol: ", p.getLabel());
                UcCliSdkSummary.println(feedback, "- Version: ", p.getVersionLabel());
                UcCliSdkSummary.println(feedback, "- Relative Location: ", UcCliSdkSummary.getRelativeLoc(parentSdk, p));
                feedback.out().println("");
            });
        }
        return IApplication.EXIT_OK;
    }

    public static ISDKDescriptor printSdkInformation(IUcSdk sdk, ICliOutput feedback) {
        ISDKDescriptor parentSdk = sdk.parentSdk();
        if (parentSdk == null) {
            feedback.out().println("SLC .slcs detected, but no real Simplicity Studio sdk detected. Only printing id: " + sdk.getId());
            return null;
        }
        UcCliSdkSummary.printHeader(feedback, "--------- SDK ---------");
        UcCliSdkSummary.println(feedback, "SDK Label: ", SDKUtils.getSimpleLabelWithVersion((ISDKDescriptor)parentSdk));
        UcCliSdkSummary.println(feedback, "SDK Version: ", parentSdk.getVersionLabel());
        feedback.out().println("");
        UcCliSdkSummary.println(feedback, "SLC SDK Label: ", sdk.getLabel());
        UcCliSdkSummary.println(feedback, "SLC SDK Version: ", sdk.getVersionLabel());
        feedback.out().println("");
        return parentSdk;
    }

    private static String getRelativeLoc(ISDKDescriptor parentSdk, IProtocolDescriptor protocol) {
        try {
            Path sdkPath = parentSdk.getInstallationPath().toFile().toPath();
            Path protoPath = protocol.getInstallationPath().toFile().toPath();
            return FileUtils.tryRelativise((Path)sdkPath, (Path)protoPath).map(String::valueOf).orElse("<Error relativizing install paths>");
        }
        catch (IOException iOException) {
            return "<Error loading install paths>";
        }
    }

    private static void printHeader(ICliOutput feedback, String header) {
        CliSessionData session = feedback.session();
        feedback.out().println(session.colourIfNeeded(header, CliColour.GREEN));
    }

    private static void println(ICliOutput feedback, String label, String info) {
        CliSessionData session = feedback.session();
        String output = session.colourIfNeeded(label, CliColour.YELLOW) + info;
        feedback.out().println(output);
    }
}

