/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.uc.cli.internal.command;

import com.silabs.ss.platform.api.sdk.core.ISDKDescriptor;
import com.silabs.uc.cli.internal.command.CliRoot;
import com.silabs.uc.cli.internal.command.UcCliSignatureDisavow;
import com.silabs.uc.cli.internal.command.UcCliSignatureSign;
import com.silabs.uc.cli.internal.command.UcCliSignatureTrust;
import com.silabs.uc.cli.internal.command.UcCliSignatureVerify;
import com.silabs.uc.cli.internal.command.exception.SdkRequiredException;
import com.silabs.uc.cli.internal.command.mixin.BaseOptions;
import com.silabs.uc.cli.internal.command.mixin.CliSdk;
import com.silabs.uc.cli.internal.model.ICliOutput;
import com.silabs.uc.cli.internal.model.SdkDescriptorWithPath;
import java.util.concurrent.Callable;
import picocli.CommandLine;

@CommandLine.Command(name="signature", description={"Groups signing and verification commands."}, subcommands={UcCliSignatureSign.class, UcCliSignatureVerify.class, UcCliSignatureTrust.class, UcCliSignatureDisavow.class})
public final class UcCliSignature
implements Callable<Integer> {
    @CommandLine.Mixin
    private BaseOptions cliConfig;
    @CommandLine.ParentCommand
    private CliRoot root;
    @CommandLine.Spec
    CommandLine.Model.CommandSpec spec;

    public ICliOutput session() {
        return this.root.feedback(this.cliConfig);
    }

    @Override
    public Integer call() {
        this.spec.commandLine().usage(this.spec.commandLine().getOut());
        return 1;
    }

    public ISDKDescriptor getDescriptor(CliSdk sdkBase, ICliOutput feedback) {
        SdkDescriptorWithPath sdkContainer = sdkBase.loadSdkDescriptor(feedback).orElseThrow(SdkRequiredException::new);
        if (sdkContainer.sdkDescriptor().isEmpty()) {
            feedback.err().println("An sdk path is defined at " + String.valueOf(sdkContainer.sdkLocation()) + " but this is not a valid sdk. ");
            return null;
        }
        return sdkContainer.sdkDescriptor().get();
    }
}

