/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.uc.cli.internal.command;

import com.silabs.ss.platform.api.sdk.core.ISDKDescriptor;
import com.silabs.uc.cli.internal.command.UcCliSignature;
import com.silabs.uc.cli.internal.command.mixin.BaseOptions;
import com.silabs.uc.cli.internal.command.mixin.CliSdk;
import com.silabs.uc.cli.internal.command.mixin.UcCliTrustMixin;
import com.silabs.uc.cli.internal.command.trust.SignatureTrustOrDisavow;
import com.silabs.uc.cli.internal.model.ICliOutput;
import java.util.concurrent.Callable;
import picocli.CommandLine;

@CommandLine.Command(name="trust", description={"trusts the sdk or extension at the given location, even if it is unsigned. With further options, this can even trust extensions with invalid signatures. This is only intended for trusting extensions that don't or otherwise cannot have a signature. For non-extension-development operation, prefer the sign/verify flow."})
public class UcCliSignatureTrust
implements Callable<Integer> {
    @CommandLine.Mixin
    private BaseOptions cliConfig;
    @CommandLine.Mixin
    private CliSdk sdkBase;
    @CommandLine.ParentCommand
    private UcCliSignature signatureCommand;
    @CommandLine.Mixin
    private UcCliTrustMixin trustMixin;

    @Override
    public Integer call() {
        ICliOutput feedback = this.signatureCommand.session();
        ISDKDescriptor descriptor = this.signatureCommand.getDescriptor(this.sdkBase, feedback);
        if (descriptor == null) {
            return 1;
        }
        SignatureTrustOrDisavow helperCommand = new SignatureTrustOrDisavow(this.trustMixin, descriptor, feedback);
        return helperCommand.doTrust();
    }
}

