/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.uc.cli.internal.command;

import com.google.common.collect.ImmutableList;
import com.silabs.ss.platform.api.sdk.core.ISDKDescriptor;
import com.silabs.ss.platform.api.security.core.ISecurityCheckpoint;
import com.silabs.ss.platform.api.security.core.ISecuritySummary;
import com.silabs.ss.platform.api.security.core.ISignatureCheckedSecurity;
import com.silabs.ss.platform.api.security.core.RichText;
import com.silabs.ss.platform.api.security.core.trust.ISignable;
import com.silabs.ss.platform.api.security.core.trust.ITrustedDescriptorStorage;
import com.silabs.uc.cli.internal.command.UcCliSignature;
import com.silabs.uc.cli.internal.command.mixin.BaseOptions;
import com.silabs.uc.cli.internal.command.mixin.CliSdk;
import com.silabs.uc.cli.internal.command.mixin.security.CliInternalSignOptimisation;
import com.silabs.uc.cli.internal.command.mixin.security.FileSummaryOutputMixin;
import com.silabs.uc.cli.internal.command.util.FeedbackProgressMonitor;
import com.silabs.uc.cli.internal.model.ICliOutput;
import com.silabs.uc.cli.internal.util.CliColour;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Path;
import java.util.SortedSet;
import java.util.concurrent.Callable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.equinox.app.IApplication;
import picocli.CommandLine;

@CommandLine.Command(name="verify", hidden=true, description={"Verifies that a given sdk or extension was signed with a trusted Silicon Labs certificate. This verification process may implicitly take place as well in other contexts where it is relevant. Returns 0 if either the sdk has a valid signature, or it is considered trusted by the system already. "})
public class UcCliSignatureVerify
implements Callable<Integer> {
    @CommandLine.Mixin
    private BaseOptions cliConfig;
    @CommandLine.Mixin
    private CliSdk sdkBase;
    @CommandLine.Mixin
    private CliInternalSignOptimisation cmdOptimisation;
    @CommandLine.Mixin
    private FileSummaryOutputMixin fSummary;
    @CommandLine.ParentCommand
    private UcCliSignature root;

    @Override
    public Integer call() {
        ICliOutput feedback = this.root.session();
        ISDKDescriptor descriptor = this.root.getDescriptor(this.sdkBase, feedback);
        if (descriptor == null) {
            return 1;
        }
        this.cmdOptimisation.apply();
        try {
            FeedbackProgressMonitor monitor = new FeedbackProgressMonitor(feedback);
            feedback.out().println("Beginning verifying of " + descriptor.getInstallationPath().toString());
            ISecuritySummary details = ISecurityCheckpoint.instance().securityDetailsFor((ISignable)descriptor, () -> true, (IProgressMonitor)monitor);
            ISignatureCheckedSecurity summary = (ISignatureCheckedSecurity)details;
            this.reportSignature(summary, feedback);
            this.reportTrust(summary, (ISignable)descriptor, feedback);
            this.fSummary.writeSummaryIfRequested((SortedSet<Path>)summary.state().summary(), feedback);
            return summary.isTrusted() || summary.trustStorage().isTrusted((ISignable)descriptor) ? IApplication.EXIT_OK : 1;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private void reportSignature(ISignatureCheckedSecurity summary, ICliOutput feedback) {
        this.printRichText(feedback, (ImmutableList<RichText>)summary.description());
        this.printRichText(feedback, (ImmutableList<RichText>)summary.getCertificateDescription());
    }

    private void printRichText(ICliOutput feedback, ImmutableList<RichText> richTexts) {
        for (RichText richTxt : richTexts) {
            CliColour color = this.getColour(richTxt);
            String text = color == null ? richTxt.text() : feedback.session().colourIfNeeded(richTxt.text(), color);
            feedback.out().print(text);
        }
    }

    private CliColour getColour(RichText text) {
        switch (text.style()) {
            case ERROR: {
                return CliColour.RED;
            }
            case HIGHLIGHT: {
                return CliColour.BLUE;
            }
            case SUCCESS: {
                return CliColour.GREEN;
            }
            case WARNING: {
                return CliColour.YELLOW;
            }
        }
        return null;
    }

    private void reportTrust(ISignatureCheckedSecurity summary, ISignable sdkDesc, ICliOutput feedback) {
        ITrustedDescriptorStorage trust = summary.trustStorage();
        feedback.out().println(feedback.session().colourIfNeeded("Is this location trusted even if unsigned or broken signature?", CliColour.MAGENTA));
        feedback.out().println("  " + (trust.isTrusted(sdkDesc) ? feedback.session().colourIfNeeded("Yes", CliColour.MAGENTA) : feedback.session().colourIfNeeded("No", CliColour.MAGENTA)));
    }
}

