/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.uc.cli.internal.command;

import com.google.common.collect.ImmutableList;
import com.silabs.ss.framework.uc.api.sdk.IUcSdk;
import com.silabs.ss.framework.uc.core.api.sdkextension.IUcSdkExtensionId;
import com.silabs.uc.cli.internal.command.CliRoot;
import com.silabs.uc.cli.internal.command.UcCliSdkSummary;
import com.silabs.uc.cli.internal.command.exception.SdkRequiredException;
import com.silabs.uc.cli.internal.command.mixin.BaseOptions;
import com.silabs.uc.cli.internal.command.mixin.CliSdk;
import com.silabs.uc.cli.internal.command.mixin.CliSlcSdk;
import com.silabs.uc.cli.internal.model.CliSessionData;
import com.silabs.uc.cli.internal.model.ICliOutput;
import com.silabs.uc.cli.internal.model.ShowSdkWarnings;
import com.silabs.uc.cli.internal.util.CliColour;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.eclipse.equinox.app.IApplication;
import picocli.CommandLine;

@CommandLine.Command(name="summarise-slt", aliases={"summarize-slt"}, description={"Prints a summary of the sdk and extensions that will be used in an SLT aware call. This command does nothing if it does not detect the presence of SLT-aware options (--sdk-package-path, --sdk-extensions). This is primarily intended for debugging or reporting in CI flows as a layer of tool assistance to ensure a command is using what a someone is actually expecting it to be using based on the command inputs."})
public final class UcCliSltSummary
implements Callable<Integer> {
    public static final int EXIT_PREFER_SUMMARISE_SDK = 5;
    @CommandLine.Mixin
    private BaseOptions cliConfig;
    @CommandLine.Mixin
    private CliSdk sdkBase;
    @CommandLine.Mixin
    private CliSlcSdk ptcSdkBase;
    @CommandLine.ParentCommand
    private CliRoot root;

    @Override
    public Integer call() {
        ICliOutput feedback = this.root.feedback(this.cliConfig);
        if (!this.sdkBase.isSltEnabled()) {
            feedback.out().println("No slt-aware options detected -- just use summarise-sdk instead or add slt-aware options.");
            return 5;
        }
        IUcSdk sdk = this.ptcSdkBase.loadPtcSdk(feedback, this.sdkBase, ShowSdkWarnings.DO_NOT_SHOW_WARNINGS).orElseThrow(SdkRequiredException::new);
        return this.summariseSlt(sdk, feedback);
    }

    public Integer summariseSlt(IUcSdk sdk, ICliOutput feedback) {
        ImmutableList<Path> extensionLocations = this.sdkBase.calculatedExtensionLocations(feedback);
        int returnCode = IApplication.EXIT_OK;
        ExecutorService parsePool = Executors.newFixedThreadPool(1);
        ArrayList foundExtensions = new ArrayList();
        for (Path extLoc : extensionLocations) {
            Path slce = CliSdk.checkForExtension(extLoc, feedback);
            if (slce == null) {
                feedback.out().println("Passed extension location " + String.valueOf(extLoc) + " does not resolve to a valid .slce file and will cause failures if used in other commands that make use of extension listings.");
                returnCode = 1;
                continue;
            }
            try {
                Optional<CliSdk.RequestedSdkExtension> loaded = CliSdk.loadSlce(extLoc, sdk.framework(), parsePool, feedback);
                loaded.ifPresent(ext -> {
                    boolean bl = foundExtensions.add(ext.id());
                });
            }
            catch (IOException e) {
                feedback.unifiedLogger().userError("Passed extension location " + String.valueOf(extLoc) + " had I/O errors being parsed: " + e.getMessage(), (Throwable)e);
            }
        }
        CliSessionData session = feedback.session();
        feedback.out().println(session.colourIfNeeded("~~~~ Found SDK ~~~~", CliColour.YELLOW));
        UcCliSdkSummary.printSdkInformation(sdk, feedback);
        if (!foundExtensions.isEmpty()) {
            feedback.out().println(session.colourIfNeeded("~~~~ Extensions Requested ~~~~", CliColour.YELLOW));
            Iterator foundExtIter = foundExtensions.iterator();
            while (foundExtIter.hasNext()) {
                IUcSdkExtensionId foundExt = (IUcSdkExtensionId)foundExtIter.next();
                feedback.out().println("Name   : " + foundExt.name());
                feedback.out().println("Version: " + foundExt.version());
                if (!foundExtIter.hasNext()) continue;
                feedback.out().println();
            }
        }
        if (returnCode != IApplication.EXIT_OK) {
            feedback.out().println(session.colourIfNeeded("~~~~ Issues ~~~~", CliColour.RED));
            feedback.out().println("There were some loading issues when attempting to present all the SLT information. Correct them before using the sdk/extensions with other commands. Issues should have already been printed above. If not, check the logs for more information.");
        }
        return returnCode;
    }
}

