/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.uc.cli.internal.command;

import com.silabs.java.utils.FileUtils;
import com.silabs.java.utils.TextUtils;
import com.silabs.ss.framework.uc.core.api.IUcFrameworkCommon;
import com.silabs.ss.framework.uc.core.api.context.IUcSdkContent;
import com.silabs.ss.framework.uc.core.api.log.IUnifiedLogger;
import com.silabs.ss.framework.uc.core.api.validate.sdk.SdkValidationIssue;
import com.silabs.ss.framework.uc.core.api.validate.sdk.SdkValidationResult;
import com.silabs.ss.framework.uc.core.api.validate.sdk.UcSdkValidationUtils;
import com.silabs.ss.framework.uc.core.api.validate.sdk.ValidationType;
import com.silabs.ss.framework.uc.core.internal.persist.CorePersistables;
import com.silabs.ss.framework.uc.core.internal.persist.PersistEntry;
import com.silabs.ss.framework.uc.core.internal.persist.PersistWarningEnum;
import com.silabs.uc.cli.internal.command.CliRoot;
import com.silabs.uc.cli.internal.command.exception.SdkRequiredException;
import com.silabs.uc.cli.internal.command.mixin.BaseOptions;
import com.silabs.uc.cli.internal.command.mixin.CliExtensionMixin;
import com.silabs.uc.cli.internal.command.mixin.CliSdk;
import com.silabs.uc.cli.internal.command.mixin.CliSlcSdk;
import com.silabs.uc.cli.internal.model.CliSessionData;
import com.silabs.uc.cli.internal.model.ICliOutput;
import com.silabs.uc.cli.internal.model.ShowSdkWarnings;
import com.silabs.uc.cli.internal.util.CliColour;
import com.silabs.uc.cli.internal.util.CliJUnitXmlFormatter;
import java.io.IOException;
import java.nio.file.Path;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import picocli.CommandLine;

@CommandLine.Command(name="validate-sdk", description={"Validates the entire sdk. This suspends all caching and whitelisting to find all issues detected via parsing, and additionally includes some sdk-wide validity algorithms not normally ran in normal cases when the sdk is loaded."})
public final class UcCliValidateSdk
implements Callable<Integer> {
    @CommandLine.Mixin
    private BaseOptions cliConfig;
    @CommandLine.Mixin
    private CliSdk sdkBase;
    @CommandLine.Mixin
    private CliSlcSdk ptcSdkBase;
    @CommandLine.ParentCommand
    private CliRoot root;
    @CommandLine.Mixin
    private CliExtensionMixin extension;
    @CommandLine.ArgGroup(exclusive=true)
    private AffectedOption affected = new AffectedOption();
    @CommandLine.Option(names={"--hanging-provides"}, description={"Whether to show apis provided for, but required by no one. This check is not enabled by default."})
    private boolean hangingProvides;
    @CommandLine.Option(names={"-w", "--warning"}, description={"Dictates the level of warnings that should be shown. This can be ${COMPLETION-CANDIDATES}. Default is 'on' unless explicitly configured by 'configuration'"})
    private PersistWarningEnum warningLevel;
    @CommandLine.Option(names={"--slccverify-release"}, description={"toggles the parsing warnings generated to 'release' level. In this form, parsers \" +\r\nare more strict, such as indicating missing library files. If this is set, -w and configuration will be ignored and warnings will always be shown."})
    private boolean verifyRelease;
    @CommandLine.Option(names={"--xml-output"}, description={"Define where an XML file should be output with the errors listed in JUnit XML format. This can be archived by the Jenkins Junit plugin. When specified, SLC will return a passing exit code unless there are fatal errors."})
    private String junitFormat;

    @Override
    public Integer call() {
        ICliOutput feedback = this.root.feedback(this.cliConfig);
        if (this.warningLevel == null) {
            this.warningLevel = feedback.config().get((PersistEntry)CorePersistables.CLI_WARNING).orElse(PersistWarningEnum.on);
        }
        ShowSdkWarnings show = this.shouldShowWarnings(this.warningLevel, this.verifyRelease);
        return this.ptcSdkBase.loadPtcSdk(feedback, this.sdkBase, show).map(sdk -> this.runValidateSdk((IUcSdkContent)sdk, show, feedback)).orElseThrow(SdkRequiredException::new);
    }

    private ShowSdkWarnings shouldShowWarnings(PersistWarningEnum warn, boolean verifyRelease) {
        if (this.verifyRelease) {
            return ShowSdkWarnings.SHOW_ALL_WARNINGS_AND_VERIFY_RELEASE;
        }
        switch (warn) {
            case silent: {
                return ShowSdkWarnings.DO_NOT_SHOW_WARNINGS;
            }
            case on: {
                return ShowSdkWarnings.SHOW_ALL_WARNINGS;
            }
        }
        throw new RuntimeException("No case to handle new enum " + String.valueOf(warn));
    }

    private int runValidateSdk(IUcSdkContent sdk, ShowSdkWarnings show, ICliOutput feedback) {
        HangingConditions hangingConditions = this.hangingProvides ? HangingConditions.HANGING_EVERYTHING : HangingConditions.NO_HANGING_PROVIDES;
        return UcCliValidateSdk.runValidateSdkExternal(sdk, show, this.extension, this.affected, hangingConditions, this.junitFormat, feedback);
    }

    public static int runValidateSdkExternal(IUcSdkContent sdk, ShowSdkWarnings show, CliExtensionMixin extension, String xmlReportDestination, ICliOutput feedback) {
        AffectedOption affected = new AffectedOption();
        affected.showAllAffected = false;
        return UcCliValidateSdk.runValidateSdkExternal(sdk, show, extension, affected, HangingConditions.NO_HANGING_PROVIDES_NOR_REQUIRES, xmlReportDestination, feedback);
    }

    private static int runValidateSdkExternal(IUcSdkContent sdk, ShowSdkWarnings show, CliExtensionMixin extension, AffectedOption affected, HangingConditions hanging, String xmlReportDestination, ICliOutput feedback) {
        CliSessionData session = feedback.session();
        feedback.out().println(session.colourIfNeeded("Finished parsing sdk -- now performing sdk-wide checks.", CliColour.MAGENTA));
        AffectedLevel affectedLevel = affected.ignoreAffected ? AffectedLevel.NONE : (affected.showAllAffected ? AffectedLevel.LOTS : AffectedLevel.SOME);
        IUcFrameworkCommon validateThis = extension.findExtension(feedback, sdk.framework()).map(IUcFrameworkCommon.class::cast).orElse((IUcFrameworkCommon)sdk.framework());
        SdkValidationResult result = UcSdkValidationUtils.validateSdk((IUcFrameworkCommon)validateThis, hanging.validationSet(), (IUnifiedLogger)feedback.unifiedLogger());
        if (!result.passed()) {
            feedback.out().println(session.colourIfNeeded("There were some sdk issues detected for you to look over...", CliColour.RED));
        } else {
            feedback.out().println(session.colourIfNeeded("SDK Validation Test over -- no issues.", CliColour.GREEN));
        }
        CliJUnitXmlFormatter formatter = CliJUnitXmlFormatter.formatter("SLC_SDK_Validation");
        if (TextUtils.hasContent((String)xmlReportDestination)) {
            if (sdk.warnings().noIssues()) {
                formatter.addSuccess(validateThis.name(), "SDK-Warnings");
            } else if (show.showWarningsWhilstParsing()) {
                sdk.warnings().fileIssues().forEach(p -> {
                    String fileIssues = sdk.warnings().fileIssueFor(p).stream().map(i -> "  - " + String.valueOf(i)).collect(Collectors.joining("\n"));
                    String prettyPath = FileUtils.tryRelativise((Path)validateThis.directory().toPath(), (Path)p).orElse(p).toString();
                    formatter.addFailure("SDK-Warnings", prettyPath, fileIssues);
                });
            }
        }
        ValidationType[] validationTypeArray = ValidationType.values();
        int n = validationTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            ValidationType t = validationTypeArray[n2];
            List issues = result.isssuesForType(t);
            if (issues.isEmpty()) {
                formatter.addSuccess(validateThis.name(), t.cleanTitle());
            } else {
                feedback.out().println(".-----~*~-----.");
                feedback.out().println(session.colourIfNeeded(t.title(), CliColour.MAGENTA));
                feedback.out().println(session.colourIfNeeded(t.preamble(), CliColour.YELLOW));
                feedback.out().println();
                for (SdkValidationIssue issue : issues) {
                    String errorMsg = switch (affectedLevel) {
                        case AffectedLevel.LOTS -> " - " + issue.message();
                        case AffectedLevel.SOME -> " - " + issue.issueOnly() + issue.partialMessage(issue.affected().stream().limit(3L).collect(Collectors.toList()));
                        case AffectedLevel.NONE -> " - " + issue.issueOnly();
                        default -> throw new RuntimeException("Missing case for " + String.valueOf((Object)affectedLevel));
                    };
                    feedback.out().println(errorMsg);
                    formatter.addFailure(t.cleanTitle(), issue.title(), errorMsg);
                }
                feedback.out().println();
            }
            ++n2;
        }
        if (TextUtils.hasContent((String)xmlReportDestination)) {
            try {
                formatter.write(feedback.resolve(xmlReportDestination), "0");
            }
            catch (IOException e) {
                feedback.err().println("Failed to write JUnit XML to '" + xmlReportDestination + "'");
                feedback.err().println(" - " + e.getLocalizedMessage());
                feedback.unifiedLogger().internalError("Failed to write JUnit XML to " + xmlReportDestination, (Throwable)e);
                return -5;
            }
            return 0;
        }
        return result.passed() ? 0 : -1;
    }

    private static enum AffectedLevel {
        LOTS,
        SOME,
        NONE;

    }

    private static final class AffectedOption {
        @CommandLine.Option(names={"-i", "--ignore-affected"}, description={"Displays no affected components list for anything -- intended for very compact display purposes."})
        private boolean ignoreAffected;
        @CommandLine.Option(names={"-a", "--show-all-affected"}, description={"Displays a secondary list after the validation issue indicating which components are affected by the problem. This shows every component affected as opposed to the default which stops at 3 components to reduce noise on larger lists. "})
        private boolean showAllAffected;

        private AffectedOption() {
        }
    }

    private static enum HangingConditions {
        NO_HANGING_PROVIDES{

            @Override
            public Set<ValidationType> validationSet() {
                return EnumSet.complementOf(EnumSet.of(ValidationType.PROVIDES_WITH_NO_REQUIRES));
            }
        }
        ,
        NO_HANGING_PROVIDES_NOR_REQUIRES{

            @Override
            public Set<ValidationType> validationSet() {
                return EnumSet.complementOf(EnumSet.of(ValidationType.PROVIDES_WITH_NO_REQUIRES, ValidationType.REQUIRES_WITH_NO_PROVIDES));
            }
        }
        ,
        HANGING_EVERYTHING{

            @Override
            public Set<ValidationType> validationSet() {
                return EnumSet.allOf(ValidationType.class);
            }
        };


        public abstract Set<ValidationType> validationSet();
    }
}

