/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.uc.cli.internal.command;

import com.silabs.java.utils.Result;
import com.silabs.ss.framework.uc.api.sdk.IUcSdk;
import com.silabs.ss.framework.uc.core.api.exception.UcException;
import com.silabs.ss.framework.uc.core.api.model.IPostBuildScript;
import com.silabs.ss.framework.uc.core.api.model.IUcProject;
import com.silabs.ss.framework.uc.core.api.model.slcw.IUcWorkspace;
import com.silabs.ss.framework.uc.core.api.model.slcw.IUcWorkspaceIncludedProject;
import com.silabs.uc.cli.internal.command.CliRoot;
import com.silabs.uc.cli.internal.command.exception.SdkRequiredException;
import com.silabs.uc.cli.internal.command.mixin.BaseOptions;
import com.silabs.uc.cli.internal.command.mixin.CliForce;
import com.silabs.uc.cli.internal.command.mixin.CliProjectOrWorkspace;
import com.silabs.uc.cli.internal.command.mixin.CliSdk;
import com.silabs.uc.cli.internal.command.mixin.CliSlcSdk;
import com.silabs.uc.cli.internal.command.model.SltSdkFeatures;
import com.silabs.uc.cli.internal.model.ICliOutput;
import com.silabs.uc.cli.internal.model.ShowSdkWarnings;
import java.util.Optional;
import java.util.concurrent.Callable;
import picocli.CommandLine;

@CommandLine.Command(name="workspace-examine", description={"Prints out workspace information from a successfully-loaded workspace."})
public final class UcCliWorkspaceExamine
implements Callable<Integer> {
    @CommandLine.Mixin
    private BaseOptions cliConfig;
    @CommandLine.Mixin
    private CliProjectOrWorkspace workspaceBase;
    @CommandLine.Mixin
    private CliSdk sdkBase;
    @CommandLine.Mixin
    private CliSlcSdk ptcSdkBase;
    @CommandLine.Mixin
    private CliForce force;
    @CommandLine.ParentCommand
    private CliRoot root;

    @Override
    public Integer call() throws Exception {
        ICliOutput feedback = this.root.feedback(this.cliConfig);
        IUcSdk sdk = this.getSdk(feedback);
        if (!this.workspaceBase.isWorkspaceOperation()) {
            feedback.out().println("Invalid parameters for workspace-examine.");
            return -8;
        }
        Result<IUcWorkspace, ? extends UcException> workspace = this.workspaceBase.loadWorkspace(sdk, feedback, null, this.force.forceOperations());
        if (!workspace.isOK()) {
            feedback.err().println("Failed to examine workspace " + this.workspaceBase.workspaceLocation());
            return ((UcException)workspace.error()).exitCode();
        }
        IUcWorkspace loadedWorkspace = (IUcWorkspace)workspace.okValue();
        feedback.out().println("workspace name: " + loadedWorkspace.name());
        feedback.out().println("workspace id: " + loadedWorkspace.id());
        Optional postBuildScript = loadedWorkspace.postBuildScript();
        if (postBuildScript.isPresent()) {
            feedback.out().println("workspace post build script: " + ((IPostBuildScript)postBuildScript.get()).profileName());
        }
        boolean error = false;
        feedback.out().println("workspace included projects:");
        for (IUcWorkspaceIncludedProject project : loadedWorkspace.projects()) {
            Optional<IUcProject> ucProject = this.workspaceBase.getWorkspaceProjectContext(loadedWorkspace, sdk, project, feedback, SltSdkFeatures.fromMixin(this.sdkBase, feedback), false, this.force.forceOperations());
            feedback.out().println("\tproject id: " + project.id());
            feedback.out().println("\tproject file: " + String.valueOf(project.projectFile()));
            if (ucProject.isPresent()) {
                feedback.out().println("\tproject description: " + ucProject.get().description());
                feedback.out().println("\tproject author: " + ucProject.get().author());
                feedback.out().println("\tproject quality: " + String.valueOf(ucProject.get().quality()));
                feedback.out().println("\tproject filters: " + ucProject.get().projectFilters().toString());
            } else {
                feedback.out().println("\t--Failed to completely load the UC Project--");
                error = true;
            }
            feedback.out().println();
        }
        return error ? -3 : 0;
    }

    private IUcSdk getSdk(ICliOutput feedback) {
        return this.ptcSdkBase.loadPtcSdk(feedback, this.sdkBase, ShowSdkWarnings.DO_NOT_SHOW_WARNINGS).orElseThrow(SdkRequiredException::new);
    }
}

