/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.uc.cli.internal.command;

import com.google.common.collect.ImmutableList;
import com.silabs.java.utils.Result;
import com.silabs.ss.framework.uc.api.sdk.IUcSdk;
import com.silabs.ss.framework.uc.core.api.exception.UcException;
import com.silabs.ss.framework.uc.core.api.model.ISharedExport;
import com.silabs.ss.framework.uc.core.api.model.ISharedImport;
import com.silabs.ss.framework.uc.core.api.model.IUcProject;
import com.silabs.ss.framework.uc.core.api.model.slcw.IUcWorkspace;
import com.silabs.ss.framework.uc.core.api.model.slcw.IUcWorkspaceIncludedProject;
import com.silabs.ss.framework.uc.core.internal.api.parse.schema.slcw.SlcwWarningsValidator;
import com.silabs.uc.cli.internal.command.CliRoot;
import com.silabs.uc.cli.internal.command.exception.SdkRequiredException;
import com.silabs.uc.cli.internal.command.mixin.BaseOptions;
import com.silabs.uc.cli.internal.command.mixin.CliExternalTools;
import com.silabs.uc.cli.internal.command.mixin.CliForce;
import com.silabs.uc.cli.internal.command.mixin.CliProjectOrWorkspaceImplicit;
import com.silabs.uc.cli.internal.command.mixin.CliSdk;
import com.silabs.uc.cli.internal.command.mixin.CliSlcSdk;
import com.silabs.uc.cli.internal.command.mixin.CliWithinWithout;
import com.silabs.uc.cli.internal.command.model.SltSdkFeatures;
import com.silabs.uc.cli.internal.model.ICliOutput;
import com.silabs.uc.cli.internal.model.ShowSdkWarnings;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.Callable;
import picocli.CommandLine;

@CommandLine.Command(name="verify", description={"Reads the given workspace in and checks its integrity."})
public final class UcCliWorkspaceVerify
implements Callable<Integer> {
    @CommandLine.Mixin
    private CliProjectOrWorkspaceImplicit projectOrWorkspaceBase;
    @CommandLine.Mixin
    private CliSdk sdkBase;
    @CommandLine.Mixin
    private CliSlcSdk ptcSdkBase;
    @CommandLine.Mixin
    private BaseOptions cliConfig;
    @CommandLine.Mixin
    private CliForce force;
    @CommandLine.ParentCommand
    private CliRoot root;
    private static final String PROJECT_LOAD_ERROR = "Failed to load the project context for project %s";
    private static final String IMPORTED_PROJECT_NOT_IN_WORKSPACE_ERROR = "Failed to find the imported project with id %s inside the workspace for project %s";

    @Override
    public Integer call() throws Exception {
        ICliOutput feedback = this.root.feedback(this.cliConfig);
        IUcSdk sdk = this.getSdk(feedback);
        if (!this.projectOrWorkspaceBase.isWorkspaceOperation()) {
            feedback.out().println("Invalid parameters provided for the verify command. Please provide a -w/--workspace file.");
            return -1;
        }
        return UcCliWorkspaceVerify.doWorkspaceVerification(this.projectOrWorkspaceBase, sdk, SltSdkFeatures.fromMixin(this.sdkBase, feedback), this.force.forceOperations(), feedback);
    }

    public static Integer runWorkspaceVerificationExternal(IUcSdk sdk, String workspacePath, CliWithinWithout withinWithout, CliExternalTools extTools, SltSdkFeatures sltFeatures, ICliOutput feedback) {
        CliProjectOrWorkspaceImplicit cliCommands = CliProjectOrWorkspaceImplicit.createDirectly(workspacePath, withinWithout, true, extTools);
        return UcCliWorkspaceVerify.doWorkspaceVerification(cliCommands, sdk, sltFeatures, true, feedback);
    }

    private static Integer doWorkspaceVerification(CliProjectOrWorkspaceImplicit projectOrWorkspaceBase, IUcSdk sdk, SltSdkFeatures sltFeatures, boolean force, ICliOutput feedback) {
        Result<IUcWorkspace, ? extends UcException> workspace = projectOrWorkspaceBase.loadWorkspace(sdk, feedback, force);
        if (!workspace.isOK()) {
            return ((UcException)workspace.error()).exitCode();
        }
        boolean validWorkspace = UcCliWorkspaceVerify.doWorkspaceVerification(projectOrWorkspaceBase, (IUcWorkspace)workspace.okValue(), sdk, sltFeatures, force, feedback);
        return validWorkspace ? 0 : -1;
    }

    public IUcSdk getSdk(ICliOutput feedback) {
        return this.ptcSdkBase.loadPtcSdk(feedback, this.sdkBase, ShowSdkWarnings.DO_NOT_SHOW_WARNINGS).orElseThrow(SdkRequiredException::new);
    }

    private static boolean doWorkspaceVerification(CliProjectOrWorkspaceImplicit projectOrWorkspaceBase, IUcWorkspace workspace, IUcSdk sdk, SltSdkFeatures features, boolean force, ICliOutput feedback) {
        boolean isValid = UcCliWorkspaceVerify.verifyProjectsLoadWithoutWarnings(projectOrWorkspaceBase, workspace, sdk, features, force, feedback);
        isValid = UcCliWorkspaceVerify.verifySlcwWarnings(workspace, feedback) && isValid;
        isValid = UcCliWorkspaceVerify.verifyInvalidCyclicDependencies(projectOrWorkspaceBase, workspace, sdk, features, force, feedback) && isValid;
        return isValid;
    }

    private static boolean verifyProjectsLoadWithoutWarnings(CliProjectOrWorkspaceImplicit projectOrWorkspaceBase, IUcWorkspace workspace, IUcSdk sdk, SltSdkFeatures sltFeatures, boolean forceOperations, ICliOutput feedback) {
        ImmutableList projects = workspace.projects();
        boolean isError = false;
        for (IUcWorkspaceIncludedProject project : projects) {
            Optional<IUcProject> ucProjectOptional = projectOrWorkspaceBase.loadWorkspaceProject(workspace, sdk, project, feedback, sltFeatures, true, forceOperations);
            if (ucProjectOptional.isPresent()) continue;
            feedback.out().println("Workspace Issue: project '" + String.valueOf(project.projectFile()) + "' could not be loaded");
            isError = true;
        }
        return isError;
    }

    private static boolean verifySlcwWarnings(IUcWorkspace workspace, ICliOutput feedback) {
        List warnings = SlcwWarningsValidator.validateSlcw((IUcWorkspace)workspace);
        if (warnings.isEmpty()) {
            return true;
        }
        feedback.out().println("Workspace Warnings:");
        warnings.stream().map(p -> " - " + p.message()).forEach(feedback.outPrintln());
        return false;
    }

    private static boolean verifyInvalidCyclicDependencies(CliProjectOrWorkspaceImplicit projectOrWorkspaceBase, IUcWorkspace workspace, IUcSdk sdk, SltSdkFeatures sltFeatures, boolean force, ICliOutput feedback) {
        boolean allValid = true;
        ImmutableList projects = workspace.projects();
        int index = 0;
        for (IUcWorkspaceIncludedProject project : projects) {
            Optional<IUcProject> ucProjectOptional = projectOrWorkspaceBase.loadWorkspaceProject(workspace, sdk, project, feedback, sltFeatures, false, force);
            if (ucProjectOptional.isEmpty()) {
                feedback.out().println(String.format(PROJECT_LOAD_ERROR, project.id()));
                allValid = false;
                continue;
            }
            IUcProject ucProject = ucProjectOptional.get();
            ISharedImport ucProjectImports = ucProject.imports();
            ImmutableList importedProjectIds = ucProjectImports.workspaceProjects();
            if (!importedProjectIds.isEmpty()) {
                for (String importedProjId : importedProjectIds) {
                    ImmutableList laterProjects;
                    if (!UcCliWorkspaceVerify.foundProjIdInProjects(importedProjId, (ImmutableList<IUcWorkspaceIncludedProject>)(laterProjects = projects.subList(index + 1, projects.size()))) || !UcCliWorkspaceVerify.laterImportedProjectContainsExportLibOrError(projectOrWorkspaceBase, feedback, sdk, workspace, project, importedProjId, sltFeatures, force)) continue;
                    allValid = false;
                }
            }
            ++index;
        }
        return allValid;
    }

    private static boolean laterImportedProjectContainsExportLibOrError(CliProjectOrWorkspaceImplicit projectOrWorkspaceBase, ICliOutput feedback, IUcSdk sdk, IUcWorkspace workspace, IUcWorkspaceIncludedProject project, String importedProjId, SltSdkFeatures sltFeatures, boolean force) {
        Optional importedProject = workspace.projectById(importedProjId);
        if (importedProject.isEmpty()) {
            feedback.out().println(String.format(IMPORTED_PROJECT_NOT_IN_WORKSPACE_ERROR, importedProjId, project.id()));
            return true;
        }
        Optional<IUcProject> importedUcProjectOptional = projectOrWorkspaceBase.loadWorkspaceProject(workspace, sdk, (IUcWorkspaceIncludedProject)importedProject.get(), feedback, sltFeatures, false, force);
        if (importedUcProjectOptional.isEmpty()) {
            feedback.out().println(String.format(PROJECT_LOAD_ERROR, project.id()));
            return true;
        }
        ISharedExport exports = importedUcProjectOptional.get().exports();
        if (!exports.libraries().isEmpty()) {
            feedback.out().println("Workspace Issue: If two projects depend on each other, and one exports a library, the one exporting the library must come first in this list of projects.");
            feedback.out().println(importedProjId + " must come before " + project.id() + " in this workspace file.\n");
            return true;
        }
        return false;
    }

    private static boolean foundProjIdInProjects(String projIdToFind, ImmutableList<IUcWorkspaceIncludedProject> projects) {
        for (IUcWorkspaceIncludedProject project : projects) {
            if (!projIdToFind.equals(project.id())) continue;
            return true;
        }
        return false;
    }
}

