/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.uc.cli.internal.command;

import com.silabs.java.utils.FileUtils;
import com.silabs.uc.cli.internal.command.CliRoot;
import com.silabs.uc.cli.internal.command.mixin.BaseOptions;
import com.silabs.uc.cli.internal.daemon.creator.CliDaemonCreator;
import com.silabs.uc.cli.internal.daemon.creator.OSGiDaemonVersionInfo;
import com.silabs.uc.cli.internal.model.ICliOutput;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.concurrent.Callable;
import picocli.CommandLine;

@CommandLine.Command(name="write-version", hidden=true, description={"internal method to write out all plugin versions for a given Simplicity Studio installation."})
public class UcCliWriteVersion
implements Callable<Integer> {
    @CommandLine.Mixin
    private BaseOptions cliConfig;
    @CommandLine.ParentCommand
    private CliRoot root;
    @CommandLine.Parameters(index="0", description={"location relative to current working directory to write out .version file"})
    String writeOut;

    @Override
    public Integer call() {
        ICliOutput feedback = this.root.feedback(this.cliConfig);
        Path destination = feedback.resolve(this.writeOut);
        try {
            return UcCliWriteVersion.writeOutVersionFile(feedback.resolve(this.writeOut), feedback);
        }
        catch (IOException e) {
            feedback.unifiedLogger().userError("Errors writing to version file: " + String.valueOf(destination), (Throwable)e);
            return -1;
        }
    }

    private static int writeOutVersionFile(Path destination, ICliOutput feedback) throws IOException {
        Path parent = destination.getParent();
        if (!Files.exists(parent, new LinkOption[0])) {
            Files.createDirectories(parent, new FileAttribute[0]);
        }
        if (Files.exists(destination, new LinkOption[0])) {
            feedback.err().println("File already exists: cannot create version file at " + String.valueOf(destination));
            return -1;
        }
        String content = OSGiDaemonVersionInfo.create(CliDaemonCreator.INSTANCE).versionContent();
        FileUtils.writeFileContents((File)destination.toFile(), (String)content);
        feedback.out().println("Wrote version file to " + String.valueOf(destination));
        return 0;
    }
}

