/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.uc.cli.internal.command.mixin;

import com.silabs.ss.framework.uc.api.sdk.IUcSdk;
import com.silabs.uc.cli.internal.command.mixin.ICliExtensionResolver;
import com.silabs.uc.cli.internal.model.ICliOutput;
import java.nio.file.Path;
import java.util.Optional;
import picocli.CommandLine;

public final class CliExtensionLocation
implements ICliExtensionResolver {
    @CommandLine.Option(names={"-ext", "--extension-path"}, description={"Path to an extension that this component comes from. Omitted if the component does not live in an extension, otherwise this should be the path to extension folder. When provided, validation will resolve component paths rooted at this location instead of the SDK itself."})
    private String extensionPath;

    public Optional<String> extensionPath() {
        return Optional.ofNullable(this.extensionPath);
    }

    @Override
    public Path resolverPath(IUcSdk sdk, ICliOutput feedback) {
        return this.extensionPath().map(feedback::resolve).orElse(sdk.framework().directory().toPath());
    }
}

