/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.uc.cli.internal.command.mixin;

import com.silabs.java.utils.log.ILogger;
import com.silabs.ss.framework.uc.api.sdk.IUcSdk;
import com.silabs.ss.framework.uc.api.sdk.IUcSdkDescriptor;
import com.silabs.ss.framework.uc.api.sdk.UcSdk;
import com.silabs.ss.framework.uc.core.api.UcFramework;
import com.silabs.ss.framework.uc.core.api.log.UcLogging;
import com.silabs.ss.framework.uc.core.api.meta.IMetaParseEngine;
import com.silabs.ss.framework.uc.core.api.meta.ParseIssueGrouper;
import com.silabs.ss.framework.uc.core.internal.api.log.UcCoreLogger;
import com.silabs.ss.framework.uc.core.internal.persist.CorePersistables;
import com.silabs.ss.framework.uc.core.internal.persist.IPersistedCliConfig;
import com.silabs.ss.framework.uc.core.internal.persist.PersistEntry;
import com.silabs.ss.platform.api.descriptor.core.IDescriptor;
import com.silabs.ss.platform.api.descriptor.core.registry.IRegistry;
import com.silabs.ss.platform.api.descriptor.core.registry.RegistryUtils;
import com.silabs.ss.platform.api.descriptor.core.trust.DescriptorTrustUtils;
import com.silabs.ss.platform.api.sdk.core.ISDKDescriptor;
import com.silabs.ss.platform.api.sdk.core.SDK;
import com.silabs.uc.cli.internal.command.exception.UntrustedSdkException;
import com.silabs.uc.cli.internal.command.mixin.CliSdk;
import com.silabs.uc.cli.internal.model.ICliOutput;
import com.silabs.uc.cli.internal.model.SdkDescriptorWithPath;
import com.silabs.uc.cli.internal.model.ShowSdkWarnings;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import picocli.CommandLine;

public class CliSlcSdk {
    @CommandLine.Option(names={"-x", "--clear-cache"}, description={"Clear the component cache if it exists."})
    private boolean clearCache;
    @CommandLine.Option(names={"-F", "--fail"}, description={"(Deprecated) Causes the operation to fail if there are any warnings."})
    private boolean failOnWarning;
    @CommandLine.Option(names={"--no-cache"}, description={"Turn off cache."})
    private boolean noCache;
    @CommandLine.Option(names={"-ch", "--cache-home"}, hidden=true, paramLabel="CACHE_FOLDER", description={"Where the cache should be drawn from. Ignored if caching is disabled. Otherwise, this location will be where the cache is created. This must be the actual file."})
    private String cacheHome;

    private boolean writeOutCache(IPersistedCliConfig config) {
        return config.get((PersistEntry)CorePersistables.PARALLEL_MODE).map(Boolean::valueOf).orElse(Boolean.FALSE) == false;
    }

    public Optional<IUcSdk> loadPtcSdk(ICliOutput feedback, CliSdk sdkBase, ShowSdkWarnings showSdkWarnings) {
        if (this.failOnWarning) {
            feedback.out().println("-F / --fail are deprecated: if needing to validate parse issues for slcc files, use 'validate-sdk' first instead.");
        }
        if (showSdkWarnings.showWarningsWhilstParsing()) {
            this.noCache = true;
        }
        Optional<SdkDescriptorWithPath> parentSdk = sdkBase.loadSdk(feedback);
        return parentSdk.flatMap(x -> this.loadPtcFromRawSdk((SdkDescriptorWithPath)x, showSdkWarnings, feedback));
    }

    private Optional<IUcSdk> loadPtcFromRawSdk(SdkDescriptorWithPath sdkPair, ShowSdkWarnings showSdkWarnings, ICliOutput feedback) {
        IUcSdkDescriptor ucDesc = null;
        if (sdkPair.sdkDescriptor().isEmpty()) {
            try {
                Path ucSdkLocation = CliSlcSdk.resolveTrueSdk(sdkPair.sdkLocation(), feedback);
                IUcSdkDescriptor[] ucSdks = (IUcSdkDescriptor[])RegistryUtils.detectInDirectory((IRegistry)UcSdk.manager(), (File)ucSdkLocation.toFile(), (boolean)false, (IProgressMonitor)new NullProgressMonitor());
                if (ucSdks.length == 0) {
                    feedback.err().println("No sdk found at " + String.valueOf(ucSdkLocation));
                    return Optional.empty();
                }
                ucDesc = ucSdks[0];
                if (UcSdk.manager().findDescriptor(ucDesc.getId()) == null) {
                    UcSdk.manager().registerDescriptor((IDescriptor)ucDesc);
                }
                feedback.out().println("Warning: No parent SDK detected. Using Project Configuration Tools only SDK, some features may not be present.");
            }
            catch (IOException e) {
                feedback.unifiedLogger().userWarning("Error resolving sdk location: " + e.getMessage(), (Throwable)e);
                return Optional.empty();
            }
        } else {
            ISDKDescriptor sdkDescriptor = sdkPair.sdkDescriptor().get();
            if (!DescriptorTrustUtils.hasValidTrustState((IDescriptor)sdkDescriptor, (IAdaptable)SDK.manager(), null)) {
                throw new UntrustedSdkException(sdkDescriptor);
            }
            ucDesc = UcSdk.manager().findDescriptorFromSDK(sdkDescriptor);
            if (ucDesc == null) {
                SDK.manager().registerDescriptor((IDescriptor)sdkDescriptor);
                UcSdk.manager().resetSync();
                ucDesc = UcSdk.manager().findDescriptorFromSDK(sdkDescriptor);
            }
        }
        if (ucDesc == null) {
            feedback.out().println("No Project Configuration Tools SDK found");
            return Optional.empty();
        }
        UcFramework.UcFrameworkConstructor frameworkBuilder = ucDesc.frameworkBuilder().setUseCache(!this.noCache).setWriteCache(this.writeOutCache(feedback.config())).setLogger((ILogger)feedback.unifiedLogger());
        IMetaParseEngine.ParseReportingLevel reportingLevel = showSdkWarnings.verifyRelease() ? IMetaParseEngine.ParseReportingLevel.RELEASE : IMetaParseEngine.ParseReportingLevel.DEV;
        frameworkBuilder.setReportingLevel(reportingLevel);
        if (this.cacheHome != null) {
            UcCoreLogger.logger().log("Overriding cache location with " + this.cacheHome);
            Path cacheLocation = feedback.resolve(this.cacheHome).toAbsolutePath();
            frameworkBuilder.setCacheLocation(cacheLocation.getParent());
            frameworkBuilder.setCacheName(cacheLocation.getFileName().toString());
        } else {
            frameworkBuilder.setCacheLocation(UcFramework.defaultCacheLocation());
            frameworkBuilder.setCacheName(UcFramework.defaultCacheName());
        }
        this.clearCache(frameworkBuilder, feedback);
        return this.loadPtcFromResolvedSdk(sdkPair, ucDesc, showSdkWarnings, feedback);
    }

    private void clearCache(UcFramework.UcFrameworkConstructor frameworkBuilder, ICliOutput feedback) {
        if (!this.clearCache) {
            return;
        }
        Path cache = frameworkBuilder.cacheFile().orElse(null);
        if (cache != null) {
            feedback.out().println("Instructed to delete cache: " + String.valueOf(cache));
            if (Files.exists(cache, new LinkOption[0])) {
                try {
                    Files.delete(cache);
                }
                catch (IOException e) {
                    feedback.unifiedLogger().userWarning("Could not clear cache as requested due to " + e.getMessage(), (Throwable)e);
                }
                feedback.out().println("Deleted");
            } else {
                feedback.out().println("There was no previous cache.");
            }
        }
    }

    private Optional<IUcSdk> loadPtcFromResolvedSdk(SdkDescriptorWithPath sdkPair, IUcSdkDescriptor ucDesc, ShowSdkWarnings showSdkWarnings, ICliOutput feedback) {
        try {
            IUcSdk ucSdk = (IUcSdk)UcSdk.manager().get((IDescriptor)ucDesc);
            if (!ucSdk.errors().isEmpty()) {
                ucSdk.errors().forEach(error -> feedback.unifiedLogger().userError(error.reportedLocation().map(Object::toString).orElse("") + " - " + error.message(), (Throwable)error.cause().orElse(null)));
                feedback.out().println("Errors loading framework: Aborting.");
                return Optional.empty();
            }
            if (!ucSdk.warnings().noIssues() && showSdkWarnings.showWarningsWhilstParsing()) {
                feedback.out().println("SDK warnings:");
                if (!this.printWarnings(ucSdk.warnings(), sdkPair.sdkLocation(), false, this.failOnWarning, feedback)) {
                    return Optional.empty();
                }
            }
            return Optional.of(ucSdk);
        }
        catch (CoreException e) {
            StringBuilder errorMsg = new StringBuilder("Could not load PTC sdk due to ").append(e.getMessage());
            if (UcLogging.shouldLog((UcLogging)UcLogging.DEBUG)) {
                errorMsg.append("\n").append(UcSdk.manager().toString()).append("\n").append(SDK.manager().toString());
            }
            feedback.unifiedLogger().userWarning(errorMsg.toString(), (Throwable)e);
            return Optional.empty();
        }
    }

    public static Path resolveTrueSdk(Path rawSdk, ICliOutput feedback) throws IOException {
        return CliSlcSdk.internalResolveIfTrueSdk(rawSdk, false, ".slcs", feedback).orElse(rawSdk);
    }

    public static Optional<Path> resolveIfTrueSdk(Path potentialPath, ICliOutput feedback) throws IOException {
        return CliSlcSdk.internalResolveIfTrueSdk(potentialPath, true, ".slcs", feedback);
    }

    public static Optional<Path> resolveIfSlce(Path potentialPath, ICliOutput feedback) throws IOException {
        return CliSlcSdk.internalResolveIfTrueSdk(potentialPath, true, ".slce", feedback);
    }

    private static Optional<Path> internalResolveIfTrueSdk(Path potentialPath, boolean shutUp, String ext, ICliOutput feedback) throws IOException {
        if (Files.isDirectory(potentialPath, new LinkOption[0])) {
            List<Path> files;
            Throwable throwable = null;
            Object var6_6 = null;
            try (Stream<Path> stream = Files.list(potentialPath);){
                files = stream.filter(p -> p.getFileName().toString().endsWith(ext)).toList();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            if (files.size() > 1) {
                feedback.err().println("multiple " + ext + "  files found! Please specify exact " + ext + ".");
                return Optional.empty();
            }
            if (files.size() == 1) {
                Path slcsSdk = files.get(0);
                if (!shutUp) {
                    feedback.unifiedLogger().internalInfo("Found slcs file " + String.valueOf(slcsSdk));
                }
                return Optional.of(slcsSdk);
            }
            return Optional.empty();
        }
        String pkgFileName = potentialPath.getFileName().toString();
        if (pkgFileName.endsWith(ext)) {
            return Optional.of(potentialPath);
        }
        return Optional.empty();
    }

    private boolean printWarnings(ParseIssueGrouper warnings, Path sdkRoot, boolean useWhitelist, boolean failOnWarning, ICliOutput feedback) {
        if (!useWhitelist) {
            feedback.out().println("Parsing metadata encountered some warnings");
            feedback.out().println(warnings.toPrettyString());
        } else {
            List whitelist = feedback.config().get((PersistEntry)CorePersistables.CLI_WARNING_WHITELIST).orElse(Collections.emptySet()).stream().map(p -> this.resolveWhitelistPath((String)p, sdkRoot, feedback)).filter(Objects::nonNull).collect(Collectors.toList());
            if (whitelist.isEmpty()) {
                return true;
            }
            Stream<Path> fileErrorsToLook = warnings.fileIssues().filter(path -> whitelist.stream().anyMatch(path::startsWith));
            ParseIssueGrouper reducedIssues = ParseIssueGrouper.fromIssues(fileErrorsToLook.flatMap(p -> warnings.fileIssueFor(p).stream()));
            if (!reducedIssues.noIssues()) {
                feedback.out().println("Parsing metadata encountered some warnings configured to be shown to you regardless of warning ignore level.");
                feedback.out().println(reducedIssues.toPrettyString());
            }
        }
        if (failOnWarning && warnings.size() > 0) {
            feedback.err().println("Warnings detected -- following instruction to proceed no further.");
            feedback.err().println("Either fix metadata issues or re-run without the fail on warnings option.");
            return false;
        }
        return true;
    }

    private Path resolveWhitelistPath(String raw, Path sdkRoot, ICliOutput feedback) {
        try {
            Path whitelistPath = sdkRoot.resolve(raw);
            return whitelistPath;
        }
        catch (InvalidPathException e) {
            String error = "Whitelist path " + raw + " ignored when resolving against sdk due to " + e.getMessage();
            feedback.out().println(error);
            UcCoreLogger.logger().log(error, (Throwable)e);
            return null;
        }
    }
}

