/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.uc.cli.internal.command.mixin;

import java.util.Collections;
import java.util.List;
import picocli.CommandLine;

public final class CliWithinWithout {
    @CommandLine.Option(names={"--with"}, paramLabel="COMPONENT_LIST", split=",", description={"Accepts a comma separated list of component ids, and they will all be added to the project. If using a workspace with this command, then all projects (or if supplying the -pids/--projects option, specific ones) will have this component added to them. You must use a ':' operator for instance capable components after the component name -- each ':' separates one instance name (for example, 'pwm:led0:led1' for led0 and led1 instances with pwm). If a component is to come from an extension, a semicolon should be used first to specify the id of the extension such as 'pwm;arc:led0:led1' if with-ing a component called pwm from an extension called 'arc' with instances 'led0' and 'led1'. The version of the extension is not supplied -- it is inferred from the project state."})
    private List<String> withinComponents;
    @CommandLine.Option(names={"--without"}, paramLabel="COMPONENT_LIST", split=",", description={"Accepts a comma separated list of component ids, and they will all be removed from the project. If using a workspace with this command, then all projects (or if supplying the -pids/--projects option, specific ones) will have this component removed from them. This runs after the --with command, so if something appears in both argument lists, it will ultimately not be in the project(s). Probably not a good idea to do that.Like 'with', instance components MAY use the ':' separator to specify specific instances to remove. If the ':' doesn't exist, all instances are removed. This also uses ';' semantics if the component belongs to an extension; see --with for more details."})
    private List<String> withoutComponents;

    public List<String> withinComponents() {
        return this.withinComponents != null ? Collections.unmodifiableList(this.withinComponents) : Collections.emptyList();
    }

    public List<String> withoutComponents() {
        return this.withoutComponents != null ? Collections.unmodifiableList(this.withoutComponents) : Collections.emptyList();
    }
}

