/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.uc.cli.internal.command.slt;

import com.silabs.ss.framework.uc.core.api.slt.ISltConfigUnit;
import com.silabs.ss.framework.uc.core.api.slt.SlcConfigProperties;
import com.silabs.uc.cli.internal.model.ICliOutput;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import picocli.CommandLine;

public class SltDefaultProvider
implements CommandLine.IDefaultValueProvider {
    private final ISltConfigUnit slt;
    private final ICliOutput feedback;

    public SltDefaultProvider(ISltConfigUnit slt, ICliOutput feedback) {
        this.slt = slt;
        this.feedback = feedback;
    }

    public String defaultValue(CommandLine.Model.ArgSpec argSpec) throws Exception {
        String calculatedDefault = null;
        if (argSpec.isOption()) {
            CommandLine.Model.OptionSpec option = (CommandLine.Model.OptionSpec)argSpec;
            for (String optionName : SltDefaultProvider.sltRelevantNames(option.names())) {
                Map toolchains;
                String pulled = this.pullConfigurable(optionName, option);
                if (pulled != null && calculatedDefault != null && !Objects.equals(pulled, calculatedDefault)) {
                    this.feedback.err().println("Duplicated SLT Config Values -- Check your .slconf. The following names are applicable for the same option: " + Arrays.toString(option.names()) + ". SLC has detected that different names were used for the same value, AND said values were inconsistent. Got both " + calculatedDefault + " and then " + pulled + ". The second value will be ignored -- please fix your .slconf configuration files and pick only one name to use.");
                } else if (pulled != null) {
                    calculatedDefault = pulled;
                }
                if (!SltDefaultProvider.isToolchainLocation(optionName) || (toolchains = this.slt.getValue(SlcConfigProperties.SESSION_TOOLCHAINS).mapError(e -> this.feedback.err().println("Invalid values for toolchain. " + e)).flatMap(t -> t).orElse(Map.of())).isEmpty()) continue;
                calculatedDefault = toolchains.entrySet().stream().map(entry -> (String)entry.getKey() + ":" + (String)entry.getValue()).collect(Collectors.joining(","));
            }
        }
        return calculatedDefault;
    }

    private static boolean isToolchainLocation(String optionName) {
        return "--toolchain-locations".equals(optionName);
    }

    public static boolean isSltConfigurable(String optionName) {
        return optionName.startsWith("--");
    }

    public static List<String> sltRelevantNames(String[] names) {
        ArrayList<String> retNames = new ArrayList<String>(names.length);
        String[] stringArray = names;
        int n = names.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            if (SltDefaultProvider.isSltConfigurable(name)) {
                retNames.add(name);
            }
            ++n2;
        }
        return retNames;
    }

    public static String cmdLineToToml(String option) {
        if (option.startsWith("--")) {
            String removeDashies = option.substring(2);
            return removeDashies;
        }
        if (option.startsWith("-")) {
            throw new IllegalArgumentException("Not a valid TOML convertable command line option. Must start with two dashes or be already converted. Instead got a single dash: " + option);
        }
        return option;
    }

    private String pullConfigurable(String optionName, CommandLine.Model.OptionSpec option) {
        if (SltDefaultProvider.isSltConfigurable(optionName)) {
            String canonicalOptionName = this.canonise(optionName);
            if (option.isMultiValue()) {
                return ((Optional)this.slt.getListString(canonicalOptionName).unwrap(err -> this.yellError(option, (String)err, this.feedback))).map(SltDefaultProvider::stringTheList).orElse(null);
            }
            return ((Optional)this.slt.getString(canonicalOptionName).unwrap(err -> this.yellError(option, (String)err, this.feedback))).orElse(null);
        }
        return null;
    }

    private String canonise(String optionName) {
        String dashRemoved = SltDefaultProvider.cmdLineToToml(optionName);
        if (ISltConfigUnit.coreOptions().contains((Object)dashRemoved)) {
            return "core." + dashRemoved;
        }
        return "slc." + dashRemoved;
    }

    private void yellError(CommandLine.Model.OptionSpec option, String err, ICliOutput feedback) {
        feedback.out().println("Could not determine suitable default for " + option.longestName() + ": " + err);
    }

    private static String stringTheList(List<String> values) {
        return values.stream().collect(Collectors.joining(","));
    }
}

