/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.uc.cli.internal.daemon;

import com.silabs.java.utils.log.Log;
import com.silabs.ss.framework.uc.core.api.servlet.WebConnectionUtils;
import com.silabs.ss.platform.jersey.StudioWebSocketAdapter;
import com.silabs.ss.platform.jetty.server.WebappManager;
import com.silabs.ss.platform.jetty.websocket.PlatformWebSocketServlet;
import com.silabs.uc.cli.internal.daemon.ICliSessionManager;
import com.silabs.uc.cli.internal.daemon.LoggingSocketAdapter;
import com.silabs.uc.cli.internal.daemon.PrintWriterSession;
import jakarta.servlet.http.HttpServlet;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jetty.ee10.websocket.server.JettyServerUpgradeRequest;
import org.eclipse.jetty.ee10.websocket.server.JettyServerUpgradeResponse;
import org.eclipse.jetty.ee10.websocket.server.JettyWebSocketCreator;
import org.json.JSONObject;

public class CliSessionManager
implements ICliSessionManager {
    private List<StudioWebSocketAdapter> connectedClients = new CopyOnWriteArrayList<StudioWebSocketAdapter>();
    private AtomicBoolean createCalled = new AtomicBoolean(false);

    @Override
    public String contextWithoutPreamble() {
        return "uccli/feedback";
    }

    @Override
    public void makeMasterWebSocket() {
        if (!this.createCalled.getAndSet(true)) {
            CliWebSocketCreator creator = new CliWebSocketCreator();
            try {
                PlatformWebSocketServlet platformSocket = new PlatformWebSocketServlet((JettyWebSocketCreator)creator);
                boolean success = WebappManager.registerServlet((HttpServlet)platformSocket, (String)this.context());
                Log.info((String)("Websocket created for CLI at: " + this.context()));
                if (!success) {
                    Log.error((String)"Error occurred during socket creation. See logs.", null);
                }
            }
            catch (CoreException e) {
                Log.error((String)("Cannot create socket: " + e.getMessage()), (Throwable)e);
            }
        }
    }

    @Override
    public PrintWriterSession makeSessionFor(String uuid) {
        PrintStream socketOutWriter = new PrintStream(new SocketOutputStream(uuid, true), true);
        PrintStream socketErrWriter = new PrintStream(new SocketOutputStream(uuid, false), true);
        return new PrintWriterSession(socketOutWriter, socketErrWriter);
    }

    @Override
    public void alertClientsOfTermination(String uuid, int returnCode) {
        JSONObject payload = new JSONObject();
        payload.put("done", (Object)uuid);
        payload.put("return_code", returnCode);
        try {
            WebConnectionUtils.notifyClients((String)payload.toString(), this.connectedClients);
        }
        catch (IOException e) {
            Log.error((String)("Could not alert clients to command termination for " + uuid + " due to " + e.getLocalizedMessage()), (Throwable)e);
        }
    }

    @Override
    public void alertClientsOfShutdown() {
        JSONObject payload = new JSONObject();
        payload.put("server_termination", true);
        try {
            WebConnectionUtils.notifyClients((String)payload.toString(), this.connectedClients);
        }
        catch (IOException e) {
            Log.error((String)("Could not alert clients of process shutdown due to " + e.getLocalizedMessage()), (Throwable)e);
        }
    }

    private final class CliWebSocketCreator
    implements JettyWebSocketCreator {
        private CliWebSocketCreator() {
        }

        public Object createWebSocket(JettyServerUpgradeRequest req, JettyServerUpgradeResponse response) {
            LoggingSocketAdapter socket = new LoggingSocketAdapter("CliWebSocketManager", CliSessionManager.this.connectedClients::remove);
            assert (socket != null) : "If socket wasn't registered this should have thrown exception!";
            CliSessionManager.this.connectedClients.add(socket);
            return socket;
        }
    }

    private final class SocketOutputStream
    extends OutputStream {
        private AtomicReference<ByteArrayOutputStream> os = new AtomicReference<ByteArrayOutputStream>(new ByteArrayOutputStream());
        private final String uuid;
        private final boolean out;

        private SocketOutputStream(String uuid, boolean out) {
            this.uuid = uuid;
            this.out = out;
        }

        @Override
        public void write(int b) throws IOException {
            this.os.get().write(b);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            this.os.get().write(b, off, len);
        }

        @Override
        public void write(byte[] b) throws IOException {
            this.os.get().write(b);
        }

        @Override
        public void flush() throws IOException {
            int oldSize = this.os.get().size();
            String contents = new String(this.os.get().toByteArray());
            if (contents.indexOf(10) < 0) {
                return;
            }
            ByteArrayOutputStream oldOs = this.os.getAndSet(new ByteArrayOutputStream(oldSize));
            if (oldSize != oldOs.size()) {
                contents = new String(oldOs.toByteArray());
            }
            JSONObject payload = new JSONObject();
            payload.put("websocket_context", (Object)this.uuid);
            payload.put(this.out ? "out" : "err", (Object)contents);
            WebConnectionUtils.notifyClientsLog((String)payload.toString(), CliSessionManager.this.connectedClients);
        }
    }
}

