/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.uc.cli.internal.daemon;

import com.silabs.java.utils.log.Log;
import com.silabs.ss.framework.uc.core.internal.api.log.UcCoreLogger;
import com.silabs.ss.platform.jetty.server.WebappManager;
import com.silabs.uc.cli.internal.daemon.creator.ISlcDaemonCreator;
import com.silabs.uc.cli.internal.daemon.creator.SlcDaemonSharedDataCreator;
import com.silabs.uc.cli.internal.daemon.shared.DaemonUtils;
import com.silabs.uc.cli.internal.daemon.shared.SlcDaemonSharedData;
import com.silabs.uc.cli.internal.product.Activator;
import com.silabs.uc.cli.internal.servlet.SlcCliRestEndpoint;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicLong;
import org.osgi.framework.BundleContext;

public final class LaunchDaemon {
    private static AtomicLong state = new AtomicLong(0L);
    private static long minutesToKeepAlive = -1L;
    public static final long MINUTES_TO_KEEP_ALIVE_DEFAULT = 30L;

    private LaunchDaemon() {
        throw new UnsupportedOperationException("Cannot instantiate utility class " + LaunchDaemon.class.getCanonicalName());
    }

    public static boolean checkInstanceAndCreateServlet(ISlcDaemonCreator creator, boolean mainApp) throws IOException {
        int port = WebappManager.getPort();
        Optional<SlcDaemonSharedData> maybeDaemonData = SlcDaemonSharedDataCreator.findExistingOrFillAwaiting(creator, port, UcCoreLogger.unifiedLogger());
        if (maybeDaemonData.isEmpty()) {
            UcCoreLogger.unifiedLogger().internalInfo("Daemon was launched, but it found no awaiting .running files that were candidates (empty files created by launcher code) to add process data to. Daemon servlet will not be created.");
            return false;
        }
        SlcDaemonSharedData daemonData = maybeDaemonData.get();
        if (daemonData.runningFileFilled() || DaemonUtils.isSharedDataOurs(daemonData)) {
            if (!mainApp) {
                LaunchDaemon.holdServlet();
            }
            return true;
        }
        UcCoreLogger.unifiedLogger().internalInfo("Daemon launched but another daemon or process stole the .running file from us.");
        return false;
    }

    private static void holdServlet() throws IOException {
        LaunchDaemon.initialiseServlet();
        Optional<SlcCliRestEndpoint> restOptional = SlcCliRestEndpoint.getRegistered(SlcCliRestEndpoint.contextPath(""));
        if (!restOptional.isPresent()) {
            throw new IllegalStateException("Studio did not properly spin up CLI servlet automatically");
        }
        SlcCliRestEndpoint cliServlet = restOptional.get();
        UcCoreLogger.unifiedLogger().internalInfo("Running CLI service: " + cliServlet.contextPath());
        state.set(1L);
        do {
            try {
                Thread.sleep(4000L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                UcCoreLogger.unifiedLogger().internalInfo("The thread holding the servlet and daemon alive was interrupted: " + e.getMessage() + ". The Daemon will be required to shut down now.", (Throwable)e);
                return;
            }
        } while (LaunchDaemon.isServletAlive(cliServlet, Activator.getContext()));
    }

    private static void initialiseServlet() throws IOException {
        URL url = new URL(WebappManager.getRESTfulUri() + "/uccli/action/commandline");
        Log.info((String)("CLI Rest Endpoint Created: " + String.valueOf(url)));
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        try {
            connection.setDoOutput(true);
            connection.setRequestMethod("POST");
            connection.setRequestProperty("Content-Type", "application/json; utf-8");
            connection.setRequestProperty("Accept", "application/json");
            connection.connect();
            connection.getResponseCode();
        }
        finally {
            connection.disconnect();
        }
    }

    public static boolean isServletAlive(SlcCliRestEndpoint cliServlet, BundleContext context) {
        long localState = state.get();
        if (localState == 2L) {
            cliServlet.notifyShutdown();
            UcCoreLogger.unifiedLogger().internalInfo("Daemon state was set to shutdown. We are now honouring that request.");
            return false;
        }
        LocalDateTime request = cliServlet.lastRequest();
        LocalDateTime now = LocalDateTime.now();
        if (localState == 1L) {
            if (cliServlet.atLeastOneService()) {
                long minutesSinceLastRequest = Math.abs(request.until(now, ChronoUnit.MINUTES));
                return minutesSinceLastRequest < LaunchDaemon.minutesToKeepAlive(context);
            }
            long secondsSinceLastRequest = Math.abs(request.until(now, ChronoUnit.SECONDS));
            return secondsSinceLastRequest < 20L;
        }
        throw new IllegalStateException("invalid state: " + localState);
    }

    public static long minutesToKeepAlive(BundleContext context) {
        if (minutesToKeepAlive == -1L) {
            String minutesOverride = context.getProperty("slc_cli_servlet_shutdown_minutes");
            if (minutesOverride == null) {
                minutesToKeepAlive = 30L;
            } else {
                try {
                    minutesToKeepAlive = Long.parseLong(minutesOverride);
                    Log.info((String)("CLI minutesToKeepAlive has been modified from default to " + minutesToKeepAlive));
                }
                catch (NumberFormatException e) {
                    String msg = "Specified number of minutes (" + minutesOverride + ") to keep inactive CLI REST daemon active is not a valid number: " + e.getMessage();
                    Log.error((String)msg, (Throwable)e);
                    minutesToKeepAlive = 30L;
                }
            }
        }
        assert (minutesToKeepAlive != -1L) : "A missing control flow did not set 'minutesToKeepAlive' properly.";
        return minutesToKeepAlive;
    }

    public static boolean cliShutDownAll() {
        return state.compareAndSet(1L, 2L);
    }
}

