/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.uc.cli.internal.model;

import com.silabs.uc.cli.internal.model.ICliOutput;
import java.io.PrintStream;
import java.util.function.Consumer;

public abstract class LoggingCliOutput
implements ICliOutput {
    protected final UnifiedLoggerOutputStream loggingOutStream;
    protected final UnifiedLoggerOutputStream loggingErrStream;

    public LoggingCliOutput(PrintStream out, PrintStream err) {
        this.loggingOutStream = new UnifiedLoggerOutputStream(out, false);
        this.loggingErrStream = new UnifiedLoggerOutputStream(err, true);
    }

    @Override
    public final PrintStream out() {
        return this.loggingOutStream;
    }

    @Override
    public final PrintStream err() {
        return this.loggingErrStream;
    }

    protected final class UnifiedLoggerOutputStream
    extends PrintStream {
        private final Consumer<String> logIt;

        UnifiedLoggerOutputStream(PrintStream toWrap, boolean isWarning) {
            super(toWrap, true);
            this.logIt = isWarning ? s -> LoggingCliOutput.this.unifiedLogger().internalWarning(s, null) : s -> LoggingCliOutput.this.unifiedLogger().internalInfo(s, null);
        }

        @Override
        public void print(boolean b) {
            this.logIt.accept(String.valueOf(b));
            super.print(b);
        }

        @Override
        public void print(char c) {
            this.logIt.accept(String.valueOf(c));
            super.print(c);
        }

        @Override
        public void print(int i) {
            this.logIt.accept(String.valueOf(i));
            super.print(i);
        }

        @Override
        public void print(long l) {
            this.logIt.accept(String.valueOf(l));
            super.print(l);
        }

        @Override
        public void print(float f) {
            this.logIt.accept(String.valueOf(f));
            super.print(f);
        }

        @Override
        public void print(double d) {
            this.logIt.accept(String.valueOf(d));
            super.print(d);
        }

        @Override
        public void print(char[] s) {
            this.logIt.accept(String.valueOf(s));
            super.print(s);
        }

        @Override
        public void print(String s) {
            this.logIt.accept(s);
            super.print(s);
        }

        @Override
        public void print(Object o) {
            this.logIt.accept(o.toString());
            super.print(o);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void printNoLog(String s) {
            UnifiedLoggerOutputStream unifiedLoggerOutputStream = this;
            synchronized (unifiedLoggerOutputStream) {
                super.print(s);
                super.println();
            }
        }
    }
}

