/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.uc.cli.internal.model;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Streams;
import com.silabs.java.utils.StreamUtils;
import com.silabs.ss.framework.uc.core.api.IUcFramework;
import com.silabs.ss.framework.uc.core.api.comp.IRecommendation;
import com.silabs.ss.framework.uc.core.api.comp.IUcComponent;
import com.silabs.ss.framework.uc.core.api.rule.ApiId;
import com.silabs.ss.framework.uc.core.api.rule.ApiRule;
import com.silabs.ss.framework.uc.core.api.validate.UcApiUtils;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class RecommendedStatus {
    private String api;
    private Multimap<IUcComponent, IUcComponent> recommendsAndSponsers = HashMultimap.create();

    private RecommendedStatus(String api) {
        this.api = api;
    }

    public static Collection<RecommendedStatus> fromConfigurationParts(List<IUcComponent> selected, Set<String> totalApis, IUcFramework framework, Set<String> additionalFailedApis) {
        HashMap recs = new HashMap();
        Streams.concat((Stream[])new Stream[]{totalApis.stream(), additionalFailedApis.stream()}).distinct().forEach(a -> {
            RecommendedStatus recommendedStatus = recs.put(a, new RecommendedStatus((String)a));
        });
        for (IUcComponent sel : selected) {
            Stream<IUcComponent> recommendedComponents = UcApiUtils.satisfyConditionalsRaw((Stream)sel.recommendations().stream(), totalApis).map(IRecommendation::uniqueId).map(arg_0 -> ((IUcFramework)framework).findComponent(arg_0)).filter(Optional::isPresent).map(Optional::get);
            for (IUcComponent rec : StreamUtils.iterableOf(recommendedComponents)) {
                UcApiUtils.satisfyConditionalsRaw(rec.providedApis().map(ApiRule::getProvided), totalApis).map(ApiId::id).forEach(provApi -> {
                    RecommendedStatus recStatus = (RecommendedStatus)recs.get(provApi);
                    if (recStatus != null) {
                        recStatus.recommendsAndSponsers.put((Object)rec, (Object)sel);
                    }
                });
            }
        }
        return recs.values();
    }

    public List<IUcComponent> recommended() {
        return this.recommendsAndSponsers.keySet().stream().collect(Collectors.toList());
    }

    public Collection<IUcComponent> sponsers(IUcComponent recommended) {
        return this.recommendsAndSponsers.get((Object)recommended).stream().collect(Collectors.toList());
    }

    public boolean isEmpty() {
        return this.recommendsAndSponsers.isEmpty();
    }

    public String api() {
        return this.api;
    }

    public String toString() {
        return "Recommendations for " + this.api + System.lineSeparator() + this.recommendsAndSponsers.entries().stream().map(entry -> "  " + ((IUcComponent)entry.getKey()).displayableId() + " - " + String.valueOf(entry.getValue())).collect(Collectors.joining(System.lineSeparator()));
    }
}

