/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.uc.cli.internal.product;

import com.silabs.java.utils.log.Log;
import com.silabs.ss.platform.api.rcp.core.StatusReporter;
import com.silabs.uc.cli.internal.daemon.creator.SlcDaemonSharedDataCreator;
import com.silabs.uc.cli.internal.daemon.shared.SlcDaemonSharedData;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Map;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;

public class Activator
implements BundleActivator {
    private static BundleContext context;
    private static StatusReporter reporter;

    public static StatusReporter reporter() {
        return reporter;
    }

    public static BundleContext getContext() {
        return context;
    }

    public void start(BundleContext bundleContext) throws Exception {
        context = bundleContext;
        reporter = new StatusReporter(context.getBundle());
    }

    public void stop(BundleContext bundleContext) throws Exception {
        for (Map.Entry createdEntry : SlcDaemonSharedDataCreator.whoCreatedFiles().entries()) {
            SlcDaemonSharedData shared = (SlcDaemonSharedData)createdEntry.getValue();
            Path runningFile = shared.runningFile();
            Activator.deleteSharedContent(runningFile, "Shared Daemon File");
            Path versionFile = shared.versionFile();
            Activator.deleteSharedContent(versionFile, "Shared Daemon Version File");
        }
        context = null;
    }

    private static void deleteSharedContent(Path p, String name) {
        try {
            if (Files.exists(p, new LinkOption[0])) {
                Files.delete(p);
                Log.info((String)("Deleted " + name + ": " + String.valueOf(p)));
            }
        }
        catch (IOException e) {
            Log.error((String)("Unable to delete " + name + " " + String.valueOf(p) + " due to " + e.getLocalizedMessage()), (Throwable)e);
        }
    }
}

