/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.uc.cli.internal.util;

import com.google.common.collect.HashMultimap;
import com.silabs.java.utils.function.Caster;
import com.silabs.ss.framework.project.api.core.type.IProjectType;
import com.silabs.ss.framework.uc.api.generation.UcGeneration;
import com.silabs.ss.framework.uc.api.generation.UcParameterizedGenerator;
import com.silabs.ss.framework.uc.api.python.validator.ConfigValidationIssue;
import com.silabs.ss.framework.uc.core.api.IUcFramework;
import com.silabs.ss.framework.uc.core.api.IUcSharedMetadata;
import com.silabs.ss.framework.uc.core.api.comp.IUcComponent;
import com.silabs.ss.framework.uc.core.api.comp.IUcComponentContainer;
import com.silabs.ss.framework.uc.core.api.exception.UcException;
import com.silabs.ss.framework.uc.core.api.log.IUnifiedLogger;
import com.silabs.ss.framework.uc.core.api.meta.MetaFileHeader;
import com.silabs.ss.framework.uc.core.api.model.IUcProject;
import com.silabs.ss.framework.uc.core.api.model.slcw.IUcWorkspaceMutable;
import com.silabs.ss.framework.uc.core.api.project.state.IUcProjectState;
import com.silabs.ss.framework.uc.core.api.project.state.UcHardware;
import com.silabs.ss.framework.uc.core.api.setup.ISetupId;
import com.silabs.ss.framework.uc.core.api.setup.UcSetupModel;
import com.silabs.ss.framework.uc.core.api.validate.ApiValidationIssue;
import com.silabs.ss.framework.uc.core.api.validate.UcApiUtils;
import com.silabs.ss.framework.uc.core.internal.api.parse.SpecVersionMilestones;
import com.silabs.ss.framework.uc.internal.api.project.setup.UcConfigurationValidator;
import com.silabs.ss.platform.api.descriptor.core.IDescribable;
import com.silabs.uc.cli.internal.command.UcCliValidateProject;
import com.silabs.uc.cli.internal.model.ICliOutput;
import com.silabs.uc.cli.internal.model.RecommendedStatus;
import com.silabs.uc.cli.internal.util.CliColour;
import com.silabs.uc.cli.internal.util.CliProjectUtility;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class CliGenerator {
    private CliGenerator() {
        throw new RuntimeException("CliGenerator is a static utility class do not instantiate");
    }

    public static boolean internalValidationApi(IUcProject project, ICliOutput feedback) {
        List validationIssues = project.validationIssues();
        if (!validationIssues.isEmpty()) {
            feedback.out().println("Project is invalid even after autoselecting dependencies. ");
            feedback.out().println(feedback.session().colourIfNeeded("The following issues exist: ", CliColour.RED));
            validationIssues.forEach(feedback.outPrintln());
            feedback.out().println("");
            UcApiUtils.SelectedWithApis calculationResult = UcApiUtils.calculateSelected((IUcProject)project);
            Set<String> failedApis = validationIssues.stream().flatMap(arg_0 -> ((Caster)Caster.with(ApiValidationIssue.class)).stream(arg_0)).map(issue -> issue.failedId().id()).collect(Collectors.toSet());
            Collection recStatus = RecommendedStatus.fromConfigurationParts((List<IUcComponent>)calculationResult.trulySelected(), (Set<String>)UcApiUtils.makeRaw((Set)calculationResult.totalApis().keySet()), project.ucFramework(), failedApis).stream().filter(r -> !r.isEmpty()).collect(Collectors.toList());
            UcCliValidateProject.reportRecommended(recStatus, validationIssues, feedback);
            return false;
        }
        return true;
    }

    public static boolean generate(IUcWorkspaceMutable workspace, UcGeneration options, ICliOutput feedback) {
        return CliGenerator.doGenerate(null, options, feedback);
    }

    public static boolean generate(IUcProject project, UcGeneration options, ICliOutput feedback) {
        return CliGenerator.doGenerate(project, options, feedback);
    }

    private static boolean doGenerate(IUcProject project, UcGeneration options, ICliOutput feedback) {
        options.verify();
        Path exportDestination = options.destination();
        if (project != null) {
            boolean recIssues;
            boolean bl = recIssues = !UcCliValidateProject.reportRecommendsIssues(project, feedback.err()).isEmpty();
            if (recIssues) {
                return false;
            }
            Path existingConfigs = exportDestination.resolve("config");
            boolean apiValidationSucceeded = CliGenerator.internalValidationApi(project, feedback);
            List<ConfigValidationIssue> configIssues = UcConfigurationValidator.validate((IUcProject)project, (Path)existingConfigs, (IUnifiedLogger)feedback.unifiedLogger()).collect(Collectors.toList());
            if (!configIssues.isEmpty()) {
                feedback.out().println("Project configuration is invalid. Check header file configuration. ");
                feedback.out().println("The following issues exist: ");
                configIssues.stream().map(ConfigValidationIssue::message).forEach(feedback.outPrintln());
            }
            boolean configIssuesBlock = CliGenerator.checkIfConfigIssuesBlock(configIssues, project.ucFramework().specVersion());
            if (!apiValidationSucceeded || configIssuesBlock) {
                if (options.generateIfErrors()) {
                    feedback.out().println("Forced Generation was requested -- project generating anyway.");
                } else {
                    feedback.out().println("Refusing to generate. Either fix issues or use '--force' to force generation.");
                    return false;
                }
            }
        }
        feedback.out().println("Generation location: " + exportDestination.toAbsolutePath().toString());
        try {
            UcParameterizedGenerator.run((UcGeneration)options);
        }
        catch (UcException e) {
            feedback.unifiedLogger().userError("Generation issue: " + e.getMessage(), (Throwable)e);
            return false;
        }
        return true;
    }

    private static boolean checkIfConfigIssuesBlock(List<ConfigValidationIssue> configIssues, long specVersion) {
        if (configIssues.isEmpty()) {
            return false;
        }
        boolean pureScriptErrors = configIssues.stream().allMatch(issue -> issue.type() == ConfigValidationIssue.ErrorType.SCRIPT_EXECUTION_FAILURE);
        if (!pureScriptErrors) {
            return true;
        }
        return SpecVersionMilestones.blockGenerationOnScriptErrors((long)specVersion);
    }

    public static boolean handleToolchainComponent(String toolchain, IUcFramework framework, UcGeneration options, ICliOutput feedback) {
        if (toolchain == null) {
            return true;
        }
        Optional<String> comp = framework.findComponent(toolchain).map(IUcSharedMetadata::id);
        if (!comp.isPresent()) {
            comp = UcHardware.toolchain().findComponents((IUcComponentContainer)framework, toolchain).stream().findAny();
        }
        if (!comp.isPresent()) {
            feedback.err().println("Toolchain " + toolchain + " not available");
            feedback.err().println("Available Toolchains " + UcHardware.toolchain().findAllComponents((IUcComponentContainer)framework).stream().collect(Collectors.joining(", ")));
            feedback.err().println("Remember you may (but are not required to) omit the 'toolchain_' prefix when supplying the argument");
            return false;
        }
        options.addComponents(new String[]{comp.get()});
        feedback.out().println("Found valid toolchain component " + comp.get() + " for " + toolchain);
        return true;
    }

    public static final boolean handleProjectTypeSelection(UcGeneration options, IUcProjectState projState, Collection<String> projectTypes, ICliOutput feedback) {
        if (!projectTypes.isEmpty()) {
            ArrayList<IProjectType> customProjectTypes = new ArrayList<IProjectType>();
            List compatibleTypes = projState.compatibleProjectTypes();
            HashMultimap nameToTypes = HashMultimap.create();
            for (IProjectType type : compatibleTypes) {
                for (String keyword : type.matchingKeywords()) {
                    nameToTypes.put((Object)keyword, (Object)type);
                }
            }
            Map<String, IProjectType> idToTypes = compatibleTypes.stream().collect(Collectors.toMap(IDescribable::getId, x -> x));
            boolean allPassed = true;
            for (String projectType : projectTypes) {
                IProjectType singleType;
                List<IProjectType> actualTypes = nameToTypes.get((Object)projectType);
                if (actualTypes.size() > 1) {
                    feedback.out().println("Type " + projectType + " can refer to multiple project types " + actualTypes.stream().map(IDescribable::getId).collect(Collectors.joining(", ")) + " for this generation, it was assumed you wanted both. Use the full id to select only one.");
                }
                if (actualTypes.isEmpty() && (singleType = idToTypes.get(projectType)) != null) {
                    actualTypes = Collections.singletonList(singleType);
                }
                if (!actualTypes.isEmpty()) {
                    feedback.out().println("Found valid project type for " + projectType);
                    customProjectTypes.addAll(actualTypes);
                    continue;
                }
                feedback.err().println("No valid project types for " + projectType);
                allPassed = false;
            }
            if (allPassed) {
                projState.setSelectedProjectTypes(customProjectTypes);
                options.setSelectedTypes(customProjectTypes);
            } else {
                feedback.err().println("At least one requested project type could not be mapped to a valid type.");
                feedback.err().println(CliProjectUtility.formatAvailableProjectTypes(projState.compatibleProjectTypes()));
                feedback.err().println("You may also specify 'nothing' for a pure file-only generation.");
                return false;
            }
        }
        return true;
    }

    public static final Collection<ISetupId> convertToSetups(Collection<String> toolExts, ICliOutput feedback) {
        HashSet<String> tools = new HashSet<String>(toolExts);
        Collection setups = Stream.concat(UcSetupModel.instance().notifyOnStartSetups(), Stream.of(IUcProject.SETUP_ID)).filter(sid -> CliGenerator.isValidSetup(sid, tools)).collect(Collectors.toList());
        if (!tools.isEmpty()) {
            feedback.err().println("Unknown tool extensions present. Ignoring: " + tools.stream().collect(Collectors.joining(", ")));
        }
        return setups;
    }

    private static boolean isValidSetup(ISetupId sid, Set<String> tools) {
        if (tools.remove(sid.id())) {
            return true;
        }
        return UcSetupModel.instance().setup(sid).map(s -> s.savedType(sid)).map(o -> o.orElse(null)).map(MetaFileHeader::type).filter(tools::remove).isPresent();
    }
}

