/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.uc.cli.internal.util;

import com.silabs.java.utils.FileUtils;
import com.silabs.java.utils.TextUtils;
import com.silabs.java.utils.XmlHtmlUtils;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;

public class CliJUnitXmlFormatter {
    private final String suiteName;
    private final List<TestCase> testCases;
    private int errors;

    public static CliJUnitXmlFormatter formatter(String suiteName) {
        return new CliJUnitXmlFormatter(suiteName);
    }

    private CliJUnitXmlFormatter(String suiteName) {
        this.suiteName = suiteName;
        this.testCases = new ArrayList<TestCase>();
    }

    public CliJUnitXmlFormatter addFailure(String groupName, String name, String errorMessage) {
        ++this.errors;
        this.testCases.add(new TestCase(this.suiteName, groupName, name, errorMessage));
        return this;
    }

    public CliJUnitXmlFormatter addSuccess(String groupName, String name) {
        this.testCases.add(new TestCase(this.suiteName, groupName, name, null));
        return this;
    }

    public void write(Path outputLoc, String testTime) throws IOException {
        String xmlFormat = this.create(testTime);
        Files.createDirectories(outputLoc.getParent(), new FileAttribute[0]);
        FileUtils.writeFileContents((File)outputLoc.toFile(), (String)xmlFormat);
    }

    public String create(String testTime) {
        StringBuilder sb = new StringBuilder("<testsuites>\n").append("  <testsuite name=\"").append(this.suiteName).append("\" ").append("time=\"").append(testTime).append("\" ").append("tests=\"").append(this.testCases.size()).append("\" errors=\"0\" skipped=\"0\" failures=\"").append(this.errors).append("\">\n");
        this.testCases.forEach(sb::append);
        sb.append("  </testsuite>\n</testsuites>");
        return sb.toString();
    }

    private static class TestCase {
        final String suiteName;
        final String className;
        final String name;
        final String errorMessage;

        TestCase(String suiteName, String className, String name, String errorMessage) {
            this.suiteName = suiteName;
            this.className = this.format(className).replace(" ", "_");
            this.name = this.format(name);
            this.errorMessage = this.format(errorMessage);
        }

        private String format(String input) {
            if (input == null) {
                return "";
            }
            String formattedContent = input.replace("\"", "'");
            return XmlHtmlUtils.escapeXML((String)formattedContent).replace("\n", "&#10;");
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("    <testcase classname=\"").append(this.suiteName).append(".").append(this.className).append("\" ").append("name=\"").append(this.name).append("\" time=\"0.0\"");
            if (TextUtils.hasContent((String)this.errorMessage)) {
                sb.append(">\n      <error message=\"").append(this.errorMessage).append("\" type=\"validate-sdk-exception\"/>").append("\n    </testcase>");
            } else {
                sb.append("/>");
            }
            return sb.append("\n").toString();
        }
    }
}

