/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.uc.cli.internal.util;

import com.google.common.base.Splitter;
import com.silabs.ss.framework.uc.api.python.validator.ConfigValidationIssue;
import com.silabs.ss.framework.uc.core.api.validate.ExclusivityIssue;
import com.silabs.ss.framework.uc.core.api.validate.UnfulfilledIssue;
import com.silabs.ss.framework.uc.core.api.validate.ValidationIssue;
import com.silabs.uc.cli.internal.model.CliSessionData;
import com.silabs.uc.cli.internal.util.CliColour;
import java.io.PrintStream;
import java.util.Iterator;
import java.util.List;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;

public final class CliUtility {
    public static final Splitter ARGS_SPLITTER = Splitter.on((char)' ').trimResults().omitEmptyStrings();

    private CliUtility() {
    }

    public static String colourIfNeeded(String toColour, CliColour colour, boolean isColour) {
        if (isColour) {
            return colour.applyColourANSI(toColour);
        }
        return toColour;
    }

    public static <T extends ValidationIssue> void printIssuesNicely(List<T> issues, PrintStream output, CliSessionData session) {
        for (ValidationIssue issue : issues) {
            if (issue instanceof UnfulfilledIssue) {
                UnfulfilledIssue apiIssue = (UnfulfilledIssue)issue;
                output.println(session.colourIfNeeded(apiIssue.partaker().displayableId(), CliColour.GREEN) + " needs " + session.colourIfNeeded(apiIssue.failedId().id(), CliColour.MAGENTA));
                continue;
            }
            if (issue instanceof ExclusivityIssue) {
                ExclusivityIssue exc = (ExclusivityIssue)issue;
                output.println("Exclusivity Issue with " + session.colourIfNeeded(exc.partaker().displayableId(), CliColour.GREEN) + " from " + session.colourIfNeeded(exc.failedId().id(), CliColour.MAGENTA) + " within rule [" + session.colourIfNeeded(exc.failedRule().toString(), CliColour.YELLOW) + "]: The following rules are exclusive: " + exc.exclusiveSatisfiers().stream().map(rule -> "Component " + session.colourIfNeeded(rule.component().displayableId(), CliColour.GREEN) + " with api rule [" + session.colourIfNeeded(rule.rule().toString(), CliColour.YELLOW) + "]").collect(Collectors.joining(System.lineSeparator() + " - ", System.lineSeparator() + " - ", System.lineSeparator())));
                continue;
            }
            output.println(issue.message());
        }
    }

    public static CliColour colourForSeverity(ConfigValidationIssue.Severity s) {
        switch (s) {
            case ERROR: {
                return CliColour.RED;
            }
            case WARNING: {
                return CliColour.YELLOW;
            }
        }
        return CliColour.BLUE;
    }

    public static void printStringsNicely(List<String> results, PrintStream writer, UnaryOperator<String> formatter, int width, String padding) {
        if (results.isEmpty()) {
            return;
        }
        int consoleLength = width - 2;
        int maximumStringLength = results.stream().mapToInt(String::length).max().getAsInt() + 2;
        int columns = consoleLength / maximumStringLength;
        if (columns <= 0) {
            columns = 1;
        }
        Iterator<String> resultIter = results.iterator();
        boolean firstLine = true;
        while (resultIter.hasNext()) {
            TransPair[] nextRow = new TransPair[columns];
            int i = 0;
            while (i < columns) {
                if (resultIter.hasNext()) {
                    String raw = resultIter.next();
                    String transformed = (String)formatter.apply(raw);
                    nextRow[i] = new TransPair(raw, transformed);
                } else {
                    nextRow[i] = TransPair.NONE;
                }
                ++i;
            }
            StringBuilder renderedRow = new StringBuilder();
            if (!firstLine) {
                renderedRow.append(padding);
            }
            TransPair[] transPairArray = nextRow;
            int n = nextRow.length;
            int n2 = 0;
            while (n2 < n) {
                TransPair p = transPairArray[n2];
                int rightPadding = maximumStringLength - p.raw.length();
                assert (rightPadding > 0) : "Padding calculated at " + rightPadding + " for " + p.raw + " (transforms to " + p.trans + "). Padding must always be greater than 0";
                renderedRow.append(p.trans);
                int i2 = 0;
                while (i2 < rightPadding) {
                    renderedRow.append(" ");
                    ++i2;
                }
                ++n2;
            }
            writer.println(renderedRow.toString());
            firstLine = false;
        }
    }

    private static final class TransPair {
        private final String raw;
        private final String trans;
        private static final TransPair NONE = new TransPair("", "");

        private TransPair(String raw, String trans) {
            this.raw = raw;
            this.trans = trans;
        }
    }
}

