from pip._vendor.chardet.sbcharsetprober import SingleByteCharSetModel

# 3: Positive
# 2: Likely
# 1: Unlikely
# 0: Negative

HEBREW_LANG_MODEL = {
    50: {  # 'a'
        50: 0,  # 'a'
        60: 1,  # 'c'
        61: 1,  # 'd'
        42: 1,  # 'e'
        53: 1,  # 'i'
        56: 2,  # 'l'
        54: 2,  # 'n'
        49: 0,  # 'o'
        51: 2,  # 'r'
        43: 1,  # 's'
        44: 2,  # 't'
        63: 1,  # 'u'
        34: 0,  # '\xa0'
        55: 0,  # '´'
        48: 0,  # '¼'
        39: 0,  # '½'
        57: 0,  # '¾'
        30: 0,  # 'ְ'
        59: 0,  # 'ֱ'
        41: 0,  # 'ֲ'
        33: 0,  # 'ִ'
        37: 0,  # 'ֵ'
        36: 0,  # 'ֶ'
        31: 0,  # 'ַ'
        29: 0,  # 'ָ'
        35: 0,  # 'ֹ'
        62: 0,  # 'ֻ'
        28: 0,  # 'ּ'
        38: 0,  # 'ׁ'
        45: 0,  # 'ׂ'
        9: 0,  # 'א'
        8: 0,  # 'ב'
        20: 0,  # 'ג'
        16: 0,  # 'ד'
        3: 1,  # 'ה'
        2: 0,  # 'ו'
        24: 0,  # 'ז'
        14: 0,  # 'ח'
        22: 0,  # 'ט'
        1: 0,  # 'י'
        25: 0,  # 'ך'
        15: 0,  # 'כ'
        4: 0,  # 'ל'
        11: 0,  # 'ם'
        6: 1,  # 'מ'
        23: 0,  # 'ן'
        12: 0,  # 'נ'
        19: 0,  # 'ס'
        13: 0,  # 'ע'
        26: 0,  # 'ף'
        18: 0,  # 'פ'
        27: 0,  # 'ץ'
        21: 0,  # 'צ'
        17: 1,  # 'ק'
        7: 0,  # 'ר'
        10: 1,  # 'ש'
        5: 0,  # 'ת'
        32: 0,  # '–'
        52: 1,  # '’'
        47: 0,  # '“'
        46: 1,  # '”'
        58: 0,  # '†'
        40: 1,  # '…'
    },
    60: {  # 'c'
        50: 1,  # 'a'
        60: 1,  # 'c'
        61: 0,  # 'd'
        42: 1,  # 'e'
        53: 1,  # 'i'
        56: 1,  # 'l'
        54: 0,  # 'n'
        49: 1,  # 'o'
        51: 1,  # 'r'
        43: 1,  # 's'
        44: 2,  # 't'
        63: 1,  # 'u'
        34: 0,  # '\xa0'
        55: 0,  # '´'
        48: 0,  # '¼'
        39: 0,  # '½'
        57: 0,  # '¾'
        30: 0,  # 'ְ'
        59: 0,  # 'ֱ'
        41: 0,  # 'ֲ'
        33: 0,  # 'ִ'
        37: 0,  # 'ֵ'
        36: 0,  # 'ֶ'
        31: 0,  # 'ַ'
        29: 0,  # 'ָ'
        35: 0,  # 'ֹ'
        62: 0,  # 'ֻ'
        28: 0,  # 'ּ'
        38: 0,  # 'ׁ'
        45: 0,  # 'ׂ'
        9: 1,  # 'א'
        8: 0,  # 'ב'
        20: 0,  # 'ג'
        16: 0,  # 'ד'
        3: 1,  # 'ה'
        2: 0,  # 'ו'
        24: 0,  # 'ז'
        14: 0,  # 'ח'
        22: 0,  # 'ט'
        1: 0,  # 'י'
        25: 0,  # 'ך'
        15: 0,  # 'כ'
        4: 0,  # 'ל'
        11: 0,  # 'ם'
        6: 1,  # 'מ'
        23: 0,  # 'ן'
        12: 1,  # 'נ'
        19: 0,  # 'ס'
        13: 0,  # 'ע'
        26: 0,  # 'ף'
        18: 0,  # 'פ'
        27: 0,  # 'ץ'
        21: 0,  # 'צ'
        17: 0,  # 'ק'
        7: 0,  # 'ר'
        10: 0,  # 'ש'
        5: 0,  # 'ת'
        32: 0,  # '–'
        52: 0,  # '’'
        47: 0,  # '“'
        46: 1,  # '”'
        58: 0,  # '†'
        40: 1,  # '…'
    },
    61: {  # 'd'
        50: 1,  # 'a'
        60: 0,  # 'c'
        61: 1,  # 'd'
        42: 1,  # 'e'
        53: 1,  # 'i'
        56: 1,  # 'l'
        54: 1,  # 'n'
        49: 2,  # 'o'
        51: 1,  # 'r'
        43: 1,  # 's'
        44: 0,  # 't'
        63: 1,  # 'u'
        34: 0,  # '\xa0'
        55: 0,  # '´'
        48: 0,  # '¼'
        39: 0,  # '½'
        57: 0,  # '¾'
        30: 0,  # 'ְ'
        59: 0,  # 'ֱ'
        41: 0,  # 'ֲ'
        33: 0,  # 'ִ'
        37: 0,  # 'ֵ'
        36: 0,  # 'ֶ'
        31: 0,  # 'ַ'
        29: 0,  # 'ָ'
        35: 0,  # 'ֹ'
        62: 0,  # 'ֻ'
        28: 0,  # 'ּ'
        38: 0,  # 'ׁ'
        45: 0,  # 'ׂ'
        9: 0,  # 'א'
        8: 0,  # 'ב'
        20: 0,  # 'ג'
        16: 0,  # 'ד'
        3: 1,  # 'ה'
        2: 0,  # 'ו'
        24: 0,  # 'ז'
        14: 0,  # 'ח'
        22: 0,  # 'ט'
        1: 0,  # 'י'
        25: 0,  # 'ך'
        15: 0,  # 'כ'
        4: 0,  # 'ל'
        11: 0,  # 'ם'
        6: 0,  # 'מ'
        23: 0,  # 'ן'
        12: 0,  # 'נ'
        19: 0,  # 'ס'
        13: 0,  # 'ע'
        26: 0,  # 'ף'
        18: 0,  # 'פ'
        27: 0,  # 'ץ'
        21: 0,  # 'צ'
        17: 0,  # 'ק'
        7: 0,  # 'ר'
        10: 0,  # 'ש'
        5: 0,  # 'ת'
        32: 1,  # '–'
        52: 1,  # '’'
        47: 0,  # '“'
        46: 1,  # '”'
        58: 0,  # '†'
        40: 1,  # '…'
    },
    42: {  # 'e'
        50: 1,  # 'a'
        60: 1,  # 'c'
        61: 2,  # 'd'
        42: 1,  # 'e'
        53: 1,  # 'i'
        56: 2,  # 'l'
        54: 2,  # 'n'
        49: 1,  # 'o'
        51: 2,  # 'r'
        43: 2,  # 's'
        44: 2,  # 't'
        63: 1,  # 'u'
        34: 1,  # '\xa0'
        55: 0,  # '´'
        48: 0,  # '¼'
        39: 0,  # '½'
        57: 0,  # '¾'
        30: 0,  # 'ְ'
        59: 0,  # 'ֱ'
        41: 0,  # 'ֲ'
        33: 0,  # 'ִ'
        37: 0,  # 'ֵ'
        36: 0,  # 'ֶ'
        31: 0,  # 'ַ'
        29: 0,  # 'ָ'
        35: 0,  # 'ֹ'
        62: 0,  # 'ֻ'
        28: 0,  # 'ּ'
        38: 0,  # 'ׁ'
        45: 0,  # 'ׂ'
        9: 0,  # 'א'
        8: 0,  # 'ב'
        20: 0,  # 'ג'
        16: 0,  # 'ד'
        3: 0,  # 'ה'
        2: 0,  # 'ו'
        24: 0,  # 'ז'
        14: 0,  # 'ח'
        22: 0,  # 'ט'
        1: 0,  # 'י'
        25: 0,  # 'ך'
        15: 0,  # 'כ'
        4: 0,  # 'ל'
        11: 0,  # 'ם'
        6: 0,  # 'מ'
        23: 0,  # 'ן'
        12: 0,  # 'נ'
        19: 0,  # 'ס'
        13: 0,  # 'ע'
        26: 0,  # 'ף'
        18: 1,  # 'פ'
        27: 0,  # 'ץ'
        21: 0,  # 'צ'
        17: 0,  # 'ק'
        7: 0,  # 'ר'
        10: 0,  # 'ש'
        5: 0,  # 'ת'
        32: 1,  # '–'
        52: 2,  # '’'
        47: 0,  # '“'
        46: 1,  # '”'
        58: 0,  # '†'
        40: 1,  # '…'
    },
    53: {  # 'i'
        50: 1,  # 'a'
        60: 2,  # 'c'
        61: 1,  # 'd'
        42: 1,  # 'e'
        53: 0,  # 'i'
        56: 1,  # 'l'
        54: 2,  # 'n'
        49: 2,  # 'o'
        51: 1,  # 'r'
        43: 2,  # 's'
        44: 2,  # 't'
        63: 1,  # 'u'
        34: 0,  # '\xa0'
        55: 1,  # '´'
        48: 0,  # '¼'
        39: 0,  # '½'
        57: 0,  # '¾'
        30: 0,  # 'ְ'
        59: 0,  # 'ֱ'
        41: 0,  # 'ֲ'
        33: 0,  # 'ִ'
        37: 0,  # 'ֵ'
        36: 0,  # 'ֶ'
        31: 0,  # 'ַ'
        29: 0,  # 'ָ'
        35: 0,  # 'ֹ'
        62: 0,  # 'ֻ'
        28: 0,  # 'ּ'
        38: 0,  # 'ׁ'
        45: 0,  # 'ׂ'
        9: 0,  # 'א'
        8: 0,  # 'ב'
        20: 0,  # 'ג'
        16: 0,  # 'ד'
        3: 0,  # 'ה'
        2: 0,  # 'ו'
        24: 0,  # 'ז'
        14: 0,  # 'ח'
        22: 0,  # 'ט'
        1: 0,  # 'י'
        25: 0,  # 'ך'
        15: 0,  # 'כ'
        4: 0,  # 'ל'
        11: 0,  # 'ם'
        6: 0,  # 'מ'
        23: 0,  # 'ן'
        12: 0,  # 'נ'
        19: 0,  # 'ס'
        13: 0,  # 'ע'
        26: 0,  # 'ף'
        18: 0,  # 'פ'
        27: 0,  # 'ץ'
        21: 0,  # 'צ'
        17: 0,  # 'ק'
        7: 0,  # 'ר'
        10: 0,  # 'ש'
        5: 0,  # 'ת'
        32: 0,  # '–'
        52: 1,  # '’'
        47: 0,  # '“'
        46: 0,  # '”'
        58: 0,  # '†'
        40: 0,  # '…'
    },
    56: {  # 'l'
        50: 1,  # 'a'
        60: 1,  # 'c'
        61: 1,  # 'd'
        42: 2,  # 'e'
        53: 2,  # 'i'
        56: 2,  # 'l'
        54: 1,  # 'n'
        49: 1,  # 'o'
        51: 0,  # 'r'
        43: 1,  # 's'
        44: 1,  # 't'
        63: 1,  # 'u'
        34: 0,  # '\xa0'
        55: 0,  # '´'
        48: 0,  # '¼'
        39: 0,  # '½'
        57: 0,  # '¾'
        30: 0,  # 'ְ'
        59: 0,  # 'ֱ'
        41: 0,  # 'ֲ'
        33: 0,  # 'ִ'
        37: 0,  # 'ֵ'
        36: 0,  # 'ֶ'
        31: 0,  # 'ַ'
        29: 0,  # 'ָ'
        35: 0,  # 'ֹ'
        62: 0,  # 'ֻ'
        28: 0,  # 'ּ'
        38: 0,  # 'ׁ'
        45: 0,  # 'ׂ'
        9: 0,  # 'א'
        8: 0,  # 'ב'
        20: 0,  # 'ג'
        16: 0,  # 'ד'
        3: 0,  # 'ה'
        2: 0,  # 'ו'
        24: 0,  # 'ז'
        14: 0,  # 'ח'
        22: 0,  # 'ט'
        1: 0,  # 'י'
        25: 0,  # 'ך'
        15: 0,  # 'כ'
        4: 0,  # 'ל'
        11: 0,  # 'ם'
        6: 0,  # 'מ'
        23: 0,  # 'ן'
        12: 0,  # 'נ'
        19: 0,  # 'ס'
        13: 0,  # 'ע'
        26: 0,  # 'ף'
        18: 0,  # 'פ'
        27: 0,  # 'ץ'
        21: 0,  # 'צ'
        17: 0,  # 'ק'
        7: 0,  # 'ר'
        10: 0,  # 'ש'
        5: 0,  # 'ת'
        32: 0,  # '–'
        52: 1,  # '’'
        47: 0,  # '“'
        46: 1,  # '”'
        58: 0,  # '†'
        40: 1,  # '…'
    },
    54: {  # 'n'
        50: 1,  # 'a'
        60: 1,  # 'c'
        61: 1,  # 'd'
        42: 1,  # 'e'
        53: 1,  # 'i'
        56: 1,  # 'l'
        54: 1,  # 'n'
        49: 1,  # 'o'
        51: 0,  # 'r'
        43: 1,  # 's'
        44: 2,  # 't'
        63: 1,  # 'u'
        34: 0,  # '\xa0'
        55: 0,  # '´'
        48: 0,  # '¼'
        39: 0,  # '½'
        57: 0,  # '¾'
        30: 0,  # 'ְ'
        59: 0,  # 'ֱ'
        41: 0,  # 'ֲ'
        33: 0,  # 'ִ'
        37: 0,  # 'ֵ'
        36: 0,  # 'ֶ'
        31: 0,  # 'ַ'
        29: 0,  # 'ָ'
        35: 0,  # 'ֹ'
        62: 0,  # 'ֻ'
        28: 0,  # 'ּ'
        38: 0,  # 'ׁ'
        45: 0,  # 'ׂ'
        9: 0,  # 'א'
        8: 0,  # 'ב'
        20: 0,  # 'ג'
        16: 0,  # 'ד'
        3: 1,  # 'ה'
        2: 0,  # 'ו'
        24: 0,  # 'ז'
        14: 0,  # 'ח'
        22: 0,  # 'ט'
        1: 0,  # 'י'
        25: 0,  # 'ך'
        15: 0,  # 'כ'
        4: 0,  # 'ל'
        11: 0,  # 'ם'
        6: 0,  # 'מ'
        23: 0,  # 'ן'
        12: 0,  # 'נ'
        19: 0,  # 'ס'
        13: 0,  # 'ע'
        26: 0,  # 'ף'
        18: 0,  # 'פ'
        27: 0,  # 'ץ'
        21: 0,  # 'צ'
        17: 0,  # 'ק'
        7: 0,  # 'ר'
        10: 0,  # 'ש'
        5: 0,  # 'ת'
        32: 0,  # '–'
        52: 2,  # '’'
        47: 0,  # '“'
        46: 1,  # '”'
        58: 0,  # '†'
        40: 1,  # '…'
    },
    49: {  # 'o'
        50: 1,  # 'a'
        60: 1,  # 'c'
        61: 1,  # 'd'
        42: 1,  # 'e'
        53: 1,  # 'i'
        56: 1,  # 'l'
        54: 2,  # 'n'
        49: 1,  # 'o'
        51: 2,  # 'r'
        43: 1,  # 's'
        44: 1,  # 't'
        63: 1,  # 'u'
        34: 0,  # '\xa0'
        55: 0,  # '´'
        48: 0,  # '¼'
        39: 0,  # '½'
        57: 0,  # '¾'
        30: 0,  # 'ְ'
        59: 0,  # 'ֱ'
        41: 0,  # 'ֲ'
        33: 0,  # 'ִ'
        37: 0,  # 'ֵ'
        36: 0,  # 'ֶ'
        31: 0,  # 'ַ'
        29: 0,  # 'ָ'
        35: 0,  # 'ֹ'
        62: 0,  # 'ֻ'
        28: 0,  # 'ּ'
        38: 0,  # 'ׁ'
        45: 0,  # 'ׂ'
        9: 0,  # 'א'
        8: 0,  # 'ב'
        20: 0,  # 'ג'
        16: 0,  # 'ד'
        3: 0,  # 'ה'
        2: 0,  # 'ו'
        24: 0,  # 'ז'
        14: 0,  # 'ח'
        22: 0,  # 'ט'
        1: 0,  # 'י'
        25: 0,  # 'ך'
        15: 0,  # 'כ'
        4: 0,  # 'ל'
        11: 0,  # 'ם'
        6: 0,  # 'מ'
        23: 0,  # 'ן'
        12: 0,  # 'נ'
        19: 0,  # 'ס'
        13: 0,  # 'ע'
        26: 0,  # 'ף'
        18: 0,  # 'פ'
        27: 0,  # 'ץ'
        21: 0,  # 'צ'
        17: 0,  # 'ק'
        7: 0,  # 'ר'
        10: 0,  # 'ש'
        5: 0,  # 'ת'
        32: 0,  # '–'
        52: 1,  # '’'
        47: 0,  # '“'
        46: 1,  # '”'
        58: 0,  # '†'
        40: 1,  # '…'
    },
    51: {  # 'r'
        50: 2,  # 'a'
        60: 1,  # 'c'
        61: 1,  # 'd'
        42: 2,  # 'e'
        53: 1,  # 'i'
        56: 1,  # 'l'
        54: 1,  # 'n'
        49: 2,  # 'o'
        51: 1,  # 'r'
        43: 1,  # 's'
        44: 1,  # 't'
        63: 1,  # 'u'
        34: 0,  # '\xa0'
        55: 0,  # '´'
        48: 0,  # '¼'
        39: 0,  # '½'
        57: 0,  # '¾'
        30: 0,  # 'ְ'
        59: 0,  # 'ֱ'
        41: 0,  # 'ֲ'
        33: 0,  # 'ִ'
        37: 0,  # 'ֵ'
        36: 0,  # 'ֶ'
        31: 0,  # 'ַ'
        29: 0,  # 'ָ'
        35: 0,  # 'ֹ'
        62: 0,  # 'ֻ'
        28: 0,  # 'ּ'
        38: 0,  # 'ׁ'
        45: 0,  # 'ׂ'
        9: 0,  # 'א'
        8: 0,  # 'ב'
        20: 0,  # 'ג'
        16: 0,  # 'ד'
        3: 0,  # 'ה'
        2: 0,  # 'ו'
        24: 0,  # 'ז'
        14: 0,  # 'ח'
        22: 0,  # 'ט'
        1: 0,  # 'י'
        25: 0,  # 'ך'
        15: 0,  # 'כ'
        4: 0,  # 'ל'
        11: 0,  # 'ם'
        6: 0,  # 'מ'
        23: 0,  # 'ן'
        12: 0,  # 'נ'
        19: 0,  # 'ס'
        13: 0,  # 'ע'
        26: 0,  # 'ף'
        18: 0,  # 'פ'
        27: 0,  # 'ץ'
        21: 0,  # 'צ'
        17: 0,  # 'ק'
        7: 0,  # 'ר'
        10: 0,  # 'ש'
        5: 0,  # 'ת'
        32: 0,  # '–'
        52: 2,  # '’'
        47: 0,  # '“'
        46: 1,  # '”'
        58: 0,  # '†'
        40: 1,  # '…'
    },
    43: {  # 's'
        50: 1,  # 'a'
        60: 1,  # 'c'
        61: 0,  # 'd'
        42: 2,  # 'e'
        53: 1,  # 'i'
        56: 1,  # 'l'
        54: 1,  # 'n'
        49: 1,  # 'o'
        51: 1,  # 'r'
        43: 1,  # 's'
        44: 2,  # 't'
        63: 1,  # 'u'
        34: 0,  # '\xa0'
        55: 0,  # '´'
        48: 0,  # '¼'
        39: 0,  # '½'
        57: 0,  # '¾'
        30: 0,  # 'ְ'
        59: 0,  # 'ֱ'
        41: 0,  # 'ֲ'
        33: 0,  # 'ִ'
        37: 0,  # 'ֵ'
        36: 0,  # 'ֶ'
        31: 0,  # 'ַ'
        29: 0,  # 'ָ'
        35: 0,  # 'ֹ'
        62: 0,  # 'ֻ'
        28: 0,  # 'ּ'
        38: 0,  # 'ׁ'
        45: 0,  # 'ׂ'
        9: 0,  # 'א'
        8: 0,  # 'ב'
        20: 0,  # 'ג'
        16: 0,  # 'ד'
        3: 0,  # 'ה'
        2: 0,  # 'ו'
        24: 0,  # 'ז'
        14: 0,  # 'ח'
        22: 0,  # 'ט'
        1: 0,  # 'י'
        25: 0,  # 'ך'
        15: 0,  # 'כ'
        4: 0,  # 'ל'
        11: 0,  # 'ם'
        6: 0,  # 'מ'
        23: 0,  # 'ן'
        12: 0,  # 'נ'
        19: 0,  # 'ס'
        13: 0,  # 'ע'
        26: 0,  # 'ף'
        18: 0,  # 'פ'
        27: 0,  # 'ץ'
        21: 0,  # 'צ'
        17: 0,  # 'ק'
        7: 0,  # 'ר'
        10: 0,  # 'ש'
        5: 0,  # 'ת'
        32: 0,  # '–'
        52: 1,  # '’'
        47: 0,  # '“'
        46: 2,  # '”'
        58: 0,  # '†'
        40: 2,  # '…'
    },
    44: {  # 't'
        50: 1,  # 'a'
        60: 1,  # 'c'
        61: 0,  # 'd'
        42: 2,  # 'e'
        53: 2,  # 'i'
        56: 1,  # 'l'
        54: 0,  # 'n'
        49: 1,  # 'o'
        51: 1,  # 'r'
        43: 1,  # 's'
        44: 1,  # 't'
        63: 1,  # 'u'
        34: 1,  # '\xa0'
        55: 0,  # '´'
        48: 0,  # '¼'
        39: 0,  # '½'
        57: 0,  # '¾'
        30: 0,  # 'ְ'
        59: 0,  # 'ֱ'
        41: 0,  # 'ֲ'
        33: 0,  # 'ִ'
        37: 0,  # 'ֵ'
        36: 0,  # 'ֶ'
        31: 0,  # 'ַ'
        29: 0,  # 'ָ'
        35: 0,  # 'ֹ'
        62: 0,  # 'ֻ'
        28: 0,  # 'ּ'
        38: 0,  # 'ׁ'
        45: 0,  # 'ׂ'
        9: 0,  # 'א'
        8: 0,  # 'ב'
        20: 0,  # 'ג'
        16: 0,  # 'ד'
        3: 0,  # 'ה'
        2: 0,  # 'ו'
        24: 0,  # 'ז'
        14: 0,  # 'ח'
        22: 0,  # 'ט'
        1: 0,  # 'י'
        25: 0,  # 'ך'
        15: 0,  # 'כ'
        4: 0,  # 'ל'
        11: 0,  # 'ם'
        6: 0,  # 'מ'
        23: 0,  # 'ן'
        12: 0,  # 'נ'
        19: 0,  # 'ס'
        13: 0,  # 'ע'
        26: 0,  # 'ף'
        18: 0,  # 'פ'
        27: 0,  # 'ץ'
        21: 0,  # 'צ'
        17: 0,  # 'ק'
        7: 0,  # 'ר'
        10: 0,  # 'ש'
        5: 0,  # 'ת'
        32: 0,  # '–'
        52: 2,  # '’'
        47: 0,  # '“'
        46: 1,  # '”'
        58: 0,  # '†'
        40: 1,  # '…'
    },
    63: {  # 'u'
        50: 1,  # 'a'
        60: 1,  # 'c'
        61: 1,  # 'd'
        42: 1,  # 'e'
        53: 1,  # 'i'
        56: 1,  # 'l'
        54: 1,  # 'n'
        49: 0,  # 'o'
        51: 1,  # 'r'
        43: 2,  # 's'
        44: 1,  # 't'
        63: 0,  # 'u'
        34: 0,  # '\xa0'
        55: 0,  # '´'
        48: 0,  # '¼'
        39: 0,  # '½'
        57: 0,  # '¾'
        30: 0,  # 'ְ'
        59: 0,  # 'ֱ'
        41: 0,  # 'ֲ'
        33: 0,  # 'ִ'
        37: 0,  # 'ֵ'
        36: 0,  # 'ֶ'
        31: 0,  # 'ַ'
        29: 0,  # 'ָ'
        35: 0,  # 'ֹ'
        62: 0,  # 'ֻ'
        28: 0,  # 'ּ'
        38: 0,  # 'ׁ'
        45: 0,  # 'ׂ'
        9: 0,  # 'א'
        8: 0,  # 'ב'
        20: 0,  # 'ג'
        16: 0,  # 'ד'
        3: 0,  # 'ה'
        2: 0,  # 'ו'
        24: 0,  # 'ז'
        14: 0,  # 'ח'
        22: 0,  # 'ט'
        1: 0,  # 'י'
        25: 0,  # 'ך'
        15: 0,  # 'כ'
        4: 0,  # 'ל'
        11: 0,  # 'ם'
        6: 0,  # 'מ'
        23: 0,  # 'ן'
        12: 0,  # 'נ'
        19: 0,  # 'ס'
        13: 0,  # 'ע'
        26: 0,  # 'ף'
        18: 0,  # 'פ'
        27: 0,  # 'ץ'
        21: 0,  # 'צ'
        17: 0,  # 'ק'
        7: 0,  # 'ר'
        10: 0,  # 'ש'
        5: 0,  # 'ת'
        32: 0,  # '–'
        52: 1,  # '’'
        47: 0,  # '“'
        46: 0,  # '”'
        58: 0,  # '†'
        40: 0,  # '…'
    },
    34: {  # '\xa0'
        50: 1,  # 'a'
        60: 0,  # 'c'
        61: 1,  # 'd'
        42: 0,  # 'e'
        53: 1,  # 'i'
        56: 0,  # 'l'
        54: 1,  # 'n'
        49: 1,  # 'o'
        51: 0,  # 'r'
        43: 1,  # 's'
        44: 1,  # 't'
        63: 0,  # 'u'
        34: 2,  # '\xa0'
        55: 0,  # '´'
        48: 0,  # '¼'
        39: 0,  # '½'
        57: 0,  # '¾'
        30: 0,  # 'ְ'
        59: 0,  # 'ֱ'
        41: 0,  # 'ֲ'
        33: 0,  # 'ִ'
        37: 0,  # 'ֵ'
        36: 0,  # 'ֶ'
        31: 0,  # 'ַ'
        29: 0,  # 'ָ'
        35: 0,  # 'ֹ'
        62: 0,  # 'ֻ'
        28: 0,  # 'ּ'
        38: 0,  # 'ׁ'
        45: 0,  # 'ׂ'
        9: 2,  # 'א'
        8: 1,  # 'ב'
        20: 1,  # 'ג'
        16: 1,  # 'ד'
        3: 1,  # 'ה'
        2: 1,  # 'ו'
        24: 1,  # 'ז'
        14: 1,  # 'ח'
        22: 1,  # 'ט'
        1: 2,  # 'י'
        25: 0,  # 'ך'
        15: 1,  # 'כ'
        4: 1,  # 'ל'
        11: 0,  # 'ם'
        6: 2,  # 'מ'
        23: 0,  # 'ן'
        12: 1,  # 'נ'
        19: 1,  # 'ס'
        13: 1,  # 'ע'
        26: 0,  # 'ף'
        18: 1,  # 'פ'
        27: 0,  # 'ץ'
        21: 1,  # 'צ'
        17: 1,  # 'ק'
        7: 1,  # 'ר'
        10: 1,  # 'ש'
        5: 1,  # 'ת'
        32: 0,  # '–'
        52: 0,  # '’'
        47: 0,  # '“'
        46: 0,  # '”'
        58: 0,  # '†'
        40: 0,  # '…'
    },
    55: {  # '´'
        50: 0,  # 'a'
        60: 0,  # 'c'
        61: 0,  # 'd'
        42: 0,  # 'e'
        53: 0,  # 'i'
        56: 0,  # 'l'
        54: 0,  # 'n'
        49: 0,  # 'o'
        51: 0,  # 'r'
        43: 1,  # 's'
        44: 0,  # 't'
        63: 0,  # 'u'
        34: 0,  # '\xa0'
        55: 0,  # '´'
        48: 0,  # '¼'
        39: 0,  # '½'
        57: 0,  # '¾'
        30: 0,  # 'ְ'
        59: 0,  # 'ֱ'
        41: 0,  # 'ֲ'
        33: 0,  # 'ִ'
        37: 0,  # 'ֵ'
        36: 0,  # 'ֶ'
        31: 0,  # 'ַ'
        29: 0,  # 'ָ'
        35: 0,  # 'ֹ'
        62: 0,  # 'ֻ'
        28: 0,  # 'ּ'
        38: 0,  # 'ׁ'
        45: 0,  # 'ׂ'
        9: 1,  # 'א'
        8: 0,  # 'ב'
        20: 0,  # 'ג'
        16: 0,  # 'ד'
        3: 1,  # 'ה'
        2: 1,  # 'ו'
        24: 0,  # 'ז'
        14: 0,  # 'ח'
        22: 0,  # 'ט'
        1: 2,  # 'י'
        25: 0,  # 'ך'
        15: 0,  # 'כ'
        4: 1,  # 'ל'
        11: 0,  # 'ם'
        6: 1,  # 'מ'
        23: 1,  # 'ן'
        12: 1,  # 'נ'
        19: 1,  # 'ס'
        13: 0,  # 'ע'
        26: 0,  # 'ף'
        18: 0,  # 'פ'
        27: 0,  # 'ץ'
        21: 0,  # 'צ'
        17: 0,  # 'ק'
        7: 1,  # 'ר'
        10: 1,  # 'ש'
        5: 0,  # 'ת'
        32: 0,  # '–'
        52: 0,  # '’'
        47: 0,  # '“'
        46: 0,  # '”'
        58: 0,  # '†'
        40: 0,  # '…'
    },
    48: {  # '¼'
        50: 0,  # 'a'
        60: 0,  # 'c'
        61: 0,  # 'd'
        42: 0,  # 'e'
        53: 0,  # 'i'
        56: 0,  # 'l'
        54: 0,  # 'n'
        49: 0,  # 'o'
        51: 0,  # 'r'
        43: 0,  # 's'
        44: 0,  # 't'
        63: 0,  # 'u'
        34: 0,  # '\xa0'
        55: 0,  # '´'
        48: 0,  # '¼'
        39: 0,  # '½'
        57: 0,  # '¾'
        30: 0,  # 'ְ'
        59: 0,  # 'ֱ'
        41: 0,  # 'ֲ'
        33: 0,  # 'ִ'
        37: 0,  # 'ֵ'
        36: 0,  # 'ֶ'
        31: 0,  # 'ַ'
        29: 0,  # 'ָ'
        35: 0,  # 'ֹ'
        62: 0,  # 'ֻ'
        28: 0,  # 'ּ'
        38: 0,  # 'ׁ'
        45: 0,  # 'ׂ'
        9: 1,  # 'א'
        8: 0,  # 'ב'
        20: 0,  # 'ג'
        16: 0,  # 'ד'
        3: 0,  # 'ה'
        2: 1,  # 'ו'
        24: 0,  # 'ז'
        14: 0,  # 'ח'
        22: 0,  # 'ט'
        1: 0,  # 'י'
        25: 0,  # 'ך'
        15: 1,  # 'כ'
        4: 1,  # 'ל'
        11: 0,  # 'ם'
        6: 1,  # 'מ'
        23: 0,  # 'ן'
        12: 0,  # 'נ'
        19: 0,  # 'ס'
        13: 0,  # 'ע'
        26: 0,  # 'ף'
        18: 0,  # 'פ'
        27: 0,  # 'ץ'
        21: 0,  # 'צ'
        17: 0,  # 'ק'
        7: 0,  # 'ר'
        10: 0,  # 'ש'
        5: 0,  # 'ת'
        32: 0,  # '–'
        52: 0,  # '’'
        47: 0,  # '“'
        46: 0,  # '”'
        58: 0,  # '†'
        40: 0,  # '…'
    },
    39: {  # '½'
        50: 0,  # 'a'
        60: 0,  # 'c'
        61: 0,  # 'd'
        42: 0,  # 'e'
        53: 0,  # 'i'
        56: 0,  # 'l'
        54: 0,  # 'n'
        49: 0,  # 'o'
        51: 0,  # 'r'
        43: 0,  # 's'
        44: 0,  # 't'
        63: 0,  # 'u'
        34: 0,  # '\xa0'
        55: 0,  # '´'
        48: 0,  # '¼'
        39: 0,  # '½'
        57: 0,  # '¾'
        30: 0,  # 'ְ'
        59: 0,  # 'ֱ'
        41: 0,  # 'ֲ'
        33: 0,  # 'ִ'
        37: 0,  # 'ֵ'
        36: 0,  # 'ֶ'
        31: 0,  # 'ַ'
        29: 0,  # 'ָ'
        35: 0,  # 'ֹ'
        62: 0,  # 'ֻ'
        28: 0,  # 'ּ'
        38: 0,  # 'ׁ'
        45: 0,  # 'ׂ'
        9: 0,  # 'א'
        8: 0,  # 'ב'
        20: 0,  # 'ג'
        16: 0,  # 'ד'
        3: 0,  # 'ה'
        2: 0,  # 'ו'
        24: 0,  # 'ז'
        14: 0,  # 'ח'
        22: 0,  # 'ט'
        1: 0,  # 'י'
        25: 0,  # 'ך'
        15: 1,  # 'כ'
        4: 1,  # 'ל'
        11: 0,  # 'ם'
        6: 0,  # 'מ'
        23: 0,  # 'ן'
        12: 0,  # 'נ'
        19: 0,  # 'ס'
        13: 0,  # 'ע'
        26: 0,  # 'ף'
        18: 0,  # 'פ'
        27: 0,  # 'ץ'
        21: 1,  # 'צ'
        17: 1,  # 'ק'
        7: 0,  # 'ר'
        10: 0,  # 'ש'
        5: 0,  # 'ת'
        32: 0,  # '–'
        52: 0,  # '’'
        47: 0,  # '“'
        46: 0,  # '”'
        58: 0,  # '†'
        40: 0,  # '…'
    },
    57: {  # '¾'
        50: 0,  # 'a'
        60: 0,  # 'c'
        61: 0,  # 'd'
        42: 0,  # 'e'
        53: 0,  # 'i'
        56: 0,  # 'l'
        54: 0,  # 'n'
        49: 0,  # 'o'
        51: 0,  # 'r'
        43: 0,  # 's'
        44: 0,  # 't'
        63: 0,  # 'u'
        34: 0,  # '\xa0'
        55: 0,  # '´'
        48: 0,  # '¼'
        39: 0,  # '½'
        57: 0,  # '¾'
        30: 0,  # 'ְ'
        59: 0,  # 'ֱ'
        41: 0,  # 'ֲ'
        33: 0,  # 'ִ'
        37: 0,  # 'ֵ'
        36: 0,  # 'ֶ'
        31: 0,  # 'ַ'
        29: 0,  # 'ָ'
        35: 0,  # 'ֹ'
        62: 0,  # 'ֻ'
        28: 0,  # 'ּ'
        38: 0,  # 'ׁ'
        45: 0,  # 'ׂ'
        9: 0,  # 'א'
        8: 0,  # 'ב'
        20: 0,  # 'ג'
        16: 0,  # 'ד'
        3: 0,  # 'ה'
        2: 0,  # 'ו'
        24: 0,  # 'ז'
        14: 0,  # 'ח'
        22: 0,  # 'ט'
        1: 0,  # 'י'
        25: 0,  # 'ך'
        15: 0,  # 'כ'
        4: 0,  # 'ל'
        11: 0,  # 'ם'
        6: 0,  # 'מ'
        23: 0,  # 'ן'
        12: 0,  # 'נ'
        19: 0,  # 'ס'
        13: 0,  # 'ע'
        26: 0,  # 'ף'
        18: 0,  # 'פ'
        27: 0,  # 'ץ'
        21: 0,  # 'צ'
        17: 0,  # 'ק'
        7: 0,  # 'ר'
        10: 0,  # 'ש'
        5: 0,  # 'ת'
        32: 0,  # '–'
        52: 0,  # '’'
        47: 0,  # '“'
        46: 0,  # '”'
        58: 0,  # '†'
        40: 0,  # '…'
    },
    30: {  # 'ְ'
        50: 0,  # 'a'
        60: 0,  # 'c'
        61: 0,  # 'd'
        42: 0,  # 'e'
        53: 0,  # 'i'
        56: 0,  # 'l'
        54: 0,  # 'n'
        49: 0,  # 'o'
        51: 0,  # 'r'
        43: 0,  # 's'
        44: 0,  # 't'
        63: 0,  # 'u'
        34: 0,  # '\xa0'
        55: 0,  # '´'
        48: 0,  # '¼'
        39: 0,  # '½'
        57: 0,  # '¾'
        30: 0,  # 'ְ'
        59: 0,  # 'ֱ'
        41: 0,  # 'ֲ'
        33: 0,  # 'ִ'
        37: 0,  # 'ֵ'
        36: 1,  # 'ֶ'
        31: 0,  # 'ַ'
        29: 0,  # 'ָ'
        35: 1,  # 'ֹ'
        62: 0,  # 'ֻ'
        28: 0,  # 'ּ'
        38: 0,  # 'ׁ'
        45: 0,  # 'ׂ'
        9: 2,  # 'א'
        8: 2,  # 'ב'
        20: 2,  # 'ג'
        16: 2,  # 'ד'
        3: 2,  # 'ה'
        2: 2,  # 'ו'
        24: 2,  # 'ז'
        14: 2,  # 'ח'
        22: 2,  # 'ט'
        1: 2,  # 'י'
        25: 2,  # 'ך'
        15: 2,  # 'כ'
        4: 2,  # 'ל'
        11: 1,  # 'ם'
        6: 2,  # 'מ'
        23: 0,  # 'ן'
        12: 2,  # 'נ'
        19: 2,  # 'ס'
        13: 2,  # 'ע'
        26: 0,  # 'ף'
        18: 2,  # 'פ'
        27: 0,  # 'ץ'
        21: 2,  # 'צ'
        17: 2,  # 'ק'
        7: 2,  # 'ר'
        10: 2,  # 'ש'
        5: 2,  # 'ת'
        32: 0,  # '–'
        52: 0,  # '’'
        47: 0,  # '“'
        46: 0,  # '”'
        58: 0,  # '†'
        40: 0,  # '…'
    },
    59: {  # 'ֱ'
        50: 0,  # 'a'
        60: 0,  # 'c'
        61: 0,  # 'd'
        42: 0,  # 'e'
        53: 0,  # 'i'
        56: 0,  # 'l'
        54: 0,  # 'n'
        49: 0,  # 'o'
        51: 0,  # 'r'
        43: 0,  # 's'
        44: 0,  # 't'
        63: 0,  # 'u'
        34: 0,  # '\xa0'
        55: 0,  # '´'
        48: 0,  # '¼'
        39: 0,  # '½'
        57: 0,  # '¾'
        30: 1,  # 'ְ'
        59: 0,  # 'ֱ'
        41: 0,  # 'ֲ'
        33: 0,  # 'ִ'
        37: 0,  # 'ֵ'
        36: 0,  # 'ֶ'
        31: 0,  # 'ַ'
        29: 0,  # 'ָ'
        35: 0,  # 'ֹ'
        62: 0,  # 'ֻ'
        28: 0,  # 'ּ'
        38: 0,  # 'ׁ'
        45: 0,  # 'ׂ'
        9: 0,  # 'א'
        8: 1,  # 'ב'
        20: 1,  # 'ג'
        16: 0,  # 'ד'
        3: 0,  # 'ה'
        2: 0,  # 'ו'
        24: 1,  # 'ז'
        14: 0,  # 'ח'
        22: 0,  # 'ט'
        1: 1,  # 'י'
        25: 0,  # 'ך'
        15: 1,  # 'כ'
        4: 2,  # 'ל'
        11: 0,  # 'ם'
        6: 2,  # 'מ'
        23: 0,  # 'ן'
        12: 1,  # 'נ'
        19: 0,  # 'ס'
        13: 0,  # 'ע'
        26: 0,  # 'ף'
        18: 0,  # 'פ'
        27: 0,  # 'ץ'
        21: 0,  # 'צ'
        17: 0,  # 'ק'
        7: 1,  # 'ר'
        10: 1,  # 'ש'
        5: 0,  # 'ת'
        32: 0,  # '–'
        52: 0,  # '’'
        47: 0,  # '“'
        46: 0,  # '”'
        58: 0,  # '†'
        40: 0,  # '…'
    },
    41: {  # 'ֲ'
        50: 0,  # 'a'
        60: 0,  # 'c'
        61: 0,  # 'd'
        42: 0,  # 'e'
        53: 0,  # 'i'
        56: 0,  # 'l'
        54: 0,  # 'n'
        49: 0,  # 'o'
        51: 0,  # 'r'
        43: 0,  # 's'
        44: 0,  # 't'
        63: 0,  # 'u'
        34: 0,  # '\xa0'
        55: 0,  # '´'
        48: 0,  # '¼'
        39: 0,  # '½'
        57: 0,  # '¾'
        30: 0,  # 'ְ'
        59: 0,  # 'ֱ'
        41: 0,  # 'ֲ'
        33: 0,  # 'ִ'
        37: 0,  # 'ֵ'
        36: 0,  # 'ֶ'
        31: 0,  # 'ַ'
        29: 0,  # 'ָ'
        35: 0,  # 'ֹ'
        62: 0,  # 'ֻ'
        28: 0,  # 'ּ'
        38: 0,  # 'ׁ'
        45: 0,  # 'ׂ'
        9: 0,  # 'א'
        8: 2,  # 'ב'
        20: 1,  # 'ג'
        16: 2,  # 'ד'
        3: 1,  # 'ה'
        2: 1,  # 'ו'
        24: 1,  # 'ז'
        14: 1,  # 'ח'
        22: 1,  # 'ט'
        1: 1,  # 'י'
        25: 1,  # 'ך'
        15: 1,  # 'כ'
        4: 2,  # 'ל'
        11: 0,  # 'ם'
        6: 2,  # 'מ'
        23: 0,  # 'ן'
        12: 2,  # 'נ'
        19: 1,  # 'ס'
        13: 0,  # 'ע'
        26: 0,  # 'ף'
        18: 1,  # 'פ'
        27: 0,  # 'ץ'
        21: 2,  # 'צ'
        17: 1,  # 'ק'
        7: 2,  # 'ר'
        10: 2,  # 'ש'
        5: 1,  # 'ת'
        32: 0,  # '–'
        52: 0,  # '’'
        47: 0,  # '“'
        46: 0,  # '”'
        58: 0,  # '†'
        40: 0,  # '…'
    },
    33: {  # 'ִ'
        50: 0,  # 'a'
        60: 0,  # 'c'
        61: 0,  # 'd'
        42: 0,  # 'e'
        53: 0,  # 'i'
        56: 0,  # 'l'
        54: 0,  # 'n'
        49: 0,  # 'o'
        51: 0,  # 'r'
        43: 0,  # 's'
        44: 0,  # 't'
        63: 0,  # 'u'
        34: 0,  # '\xa0'
        55: 0,  # '´'
        48: 0,  # '¼'
        39: 0,  # '½'
        57: 0,  # '¾'
        30: 1,  # 'ְ'
        59: 0,  # 'ֱ'
        41: 0,  # 'ֲ'
        33: 1,  # 'ִ'
        37: 0,  # 'ֵ'
        36: 1,  # 'ֶ'
        31: 0,  # 'ַ'
        29: 1,  # 'ָ'
        35: 0,  # 'ֹ'
        62: 0,  # 'ֻ'
        28: 1,  # 'ּ'
        38: 0,  # 'ׁ'
        45: 0,  # 'ׂ'
        9: 1,  # 'א'
        8: 2,  # 'ב'
        20: 2,  # 'ג'
        16: 2,  # 'ד'
        3: 1,  # 'ה'
        2: 1,  # 'ו'
        24: 2,  # 'ז'
        14: 1,  # 'ח'
        22: 1,  # 'ט'
        1: 3,  # 'י'
        25: 1,  # 'ך'
        15: 2,  # 'כ'
        4: 2,  # 'ל'
        11: 2,  # 'ם'
        6: 2,  # 'מ'
        23: 2,  # 'ן'
        12: 2,  # 'נ'
        19: 2,  # 'ס'
        13: 1,  # 'ע'
        26: 0,  # 'ף'
        18: 2,  # 'פ'
        27: 1,  # 'ץ'
        21: 2,  # 'צ'
        17: 2,  # 'ק'
        7: 2,  # 'ר'
        10: 2,  # 'ש'
        5: 2,  # 'ת'
        32: 0,  # '–'
        52: 0,  # '’'
        47: 0,  # '“'
        46: 0,  # '”'
        58: 0,  # '†'
        40: 0,  # '…'
    },
    37: {  # 'ֵ'
        50: 0,  # 'a'
        60: 0,  # 'c'
        61: 0,  # 'd'
        42: 0,  # 'e'
        53: 0,  # 'i'
        56: 0,  # 'l'
        54: 0,  # 'n'
        49: 0,  # 'o'
        51: 0,  # 'r'
        43: 0,  # 's'
        44: 0,  # 't'
        63: 0,  # 'u'
        34: 0,  # '\xa0'
        55: 0,  # '´'
        48: 0,  # '¼'
        39: 0,  # '½'
        57: 0,  # '¾'
        30: 0,  # 'ְ'
        59: 0,  # 'ֱ'
        41: 0,  # 'ֲ'
        33: 0,  # 'ִ'
        37: 0,  # 'ֵ'
        36: 1,  # 'ֶ'
        31: 1,  # 'ַ'
        29: 1,  # 'ָ'
        35: 0,  # 'ֹ'
        62: 0,  # 'ֻ'
        28: 0,  # 'ּ'
        38: 0,  # 'ׁ'
        45: 0,  # 'ׂ'
        9: 2,  # 'א'
        8: 2,  # 'ב'
        20: 1,  # 'ג'
        16: 2,  # 'ד'
        3: 2,  # 'ה'
        2: 1,  # 'ו'
        24: 1,  # 'ז'
        14: 2,  # 'ח'
        22: 1,  # 'ט'
        1: 3,  # 'י'
        25: 2,  # 'ך'
        15: 1,  # 'כ'
        4: 2,  # 'ל'
        11: 2,  # 'ם'
        6: 1,  # 'מ'
        23: 2,  # 'ן'
        12: 2,  # 'נ'
        19: 1,  # 'ס'
        13: 2,  # 'ע'
        26: 1,  # 'ף'
        18: 1,  # 'פ'
        27: 1,  # 'ץ'
        21: 1,  # 'צ'
        17: 1,  # 'ק'
        7: 2,  # 'ר'
        10: 2,  # 'ש'
        5: 2,  # 'ת'
        32: 0,  # '–'
        52: 0,  # '’'
        47: 0,  # '“'
        46: 0,  # '”'
        58: 0,  # '†'
        40: 0,  # '…'
    },
    36: {  # 'ֶ'
        50: 0,  # 'a'
        60: 0,  # 'c'
        61: 0,  # 'd'
        42: 0,  # 'e'
        53: 0,  # 'i'
        56: 0,  # 'l'
        54: 0,  # 'n'
        49: 0,  # 'o'
        51: 0,  # 'r'
        43: 0,  # 's'
        44: 0,  # 't'
        63: 0,  # 'u'
        34: 0,  # '\xa0'
        55: 0,  # '´'
        48: 0,  # '¼'
        39: 0,  # '½'
        57: 0,  # '¾'
        30: 0,  # 'ְ'
        59: 0,  # 'ֱ'
        41: 0,  # 'ֲ'
        33: 0,  # 'ִ'
        37: 0,  # 'ֵ'
        36: 1,  # 'ֶ'
        31: 1,  # 'ַ'
        29: 1,  # 'ָ'
        35: 0,  # 'ֹ'
        62: 0,  # 'ֻ'
        28: 0,  # 'ּ'
        38: 0,  # 'ׁ'
        45: 0,  # 'ׂ'
        9: 2,  # 'א'
        8: 2,  # 'ב'
        20: 1,  # 'ג'
        16: 2,  # 'ד'
        3: 2,  # 'ה'
        2: 1,  # 'ו'
        24: 1,  # 'ז'
        14: 2,  # 'ח'
        22: 1,  # 'ט'
        1: 2,  # 'י'
        25: 2,  # 'ך'
        15: 1,  # 'כ'
        4: 2,  # 'ל'
        11: 2,  # 'ם'
        6: 2,  # 'מ'
        23: 2,  # 'ן'
        12: 2,  # 'נ'
        19: 2,  # 'ס'
        13: 1,  # 'ע'
        26: 1,  # 'ף'
        18: 1,  # 'פ'
        27: 2,  # 'ץ'
        21: 1,  # 'צ'
        17: 1,  # 'ק'
        7: 2,  # 'ר'
        10: 2,  # 'ש'
        5: 2,  # 'ת'
        32: 0,  # '–'
        52: 0,  # '’'
        47: 0,  # '“'
        46: 0,  # '”'
        58: 0,  # '†'
        40: 0,  # '…'
    },
    31: {  # 'ַ'
        50: 0,  # 'a'
        60: 0,  # 'c'
        61: 0,  # 'd'
        42: 0,  # 'e'
        53: 0,  # 'i'
        56: 0,  # 'l'
        54: 0,  # 'n'
        49: 0,  # 'o'
        51: 0,  # 'r'
        43: 0,  # 's'
        44: 0,  # 't'
        63: 0,  # 'u'
        34: 0,  # '\xa0'
        55: 0,  # '´'
        48: 0,  # '¼'
        39: 0,  # '½'
        57: 0,  # '¾'
        30: 1,  # 'ְ'
        59: 0,  # 'ֱ'
        41: 0,  # 'ֲ'
        33: 0,  # 'ִ'
        37: 0,  # 'ֵ'
        36: 1,  # 'ֶ'
        31: 0,  # 'ַ'
        29: 2,  # 'ָ'
        35: 0,  # 'ֹ'
        62: 0,  # 'ֻ'
        28: 0,  # 'ּ'
        38: 0,  # 'ׁ'
        45: 0,  # 'ׂ'
        9: 2,  # 'א'
        8: 2,  # 'ב'
        20: 2,  # 'ג'
        16: 2,  # 'ד'
        3: 2,  # 'ה'
        2: 1,  # 'ו'
        24: 2,  # 'ז'
        14: 2,  # 'ח'
        22: 2,  # 'ט'
        1: 3,  # 'י'
        25: 1,  # 'ך'
        15: 2,  # 'כ'
        4: 2,  # 'ל'
        11: 2,  # 'ם'
        6: 2,  # 'מ'
        23: 2,  # 'ן'
        12: 2,  # 'נ'
        19: 2,  # 'ס'
        13: 2,  # 'ע'
        26: 2,  # 'ף'
        18: 2,  # 'פ'
        27: 1,  # 'ץ'
        21: 2,  # 'צ'
        17: 2,  # 'ק'
        7: 2,  # 'ר'
        10: 2,  # 'ש'
        5: 2,  # 'ת'
        32: 0,  # '–'
        52: 0,  # '’'
        47: 0,  # '“'
        46: 0,  # '”'
        58: 0,  # '†'
        40: 0,  # '…'
    },
    29: {  # 'ָ'
        50: 0,  # 'a'
        60: 0,  # 'c'
        61: 0,  # 'd'
        42: 0,  # 'e'
        53: 0,  # 'i'
        56: 0,  # 'l'
        54: 0,  # 'n'
        49: 0,  # 'o'
        51: 0,  # 'r'
        43: 0,  # 's'
        44: 0,  # 't'
        63: 0,  # 'u'
        34: 0,  # '\xa0'
        55: 0,  # '´'
        48: 0,  # '¼'
        39: 0,  # '½'
        57: 0,  # '¾'
        30: 0,  # 'ְ'
        59: 0,  # 'ֱ'
        41: 0,  # 'ֲ'
        33: 0,  # 'ִ'
        37: 0,  # 'ֵ'
        36: 0,  # 'ֶ'
        31: 1,  # 'ַ'
        29: 2,  # 'ָ'
        35: 0,  # 'ֹ'
        62: 0,  # 'ֻ'
        28: 1,  # 'ּ'
        38: 0,  # 'ׁ'
        45: 0,  # 'ׂ'
        9: 2,  # 'א'
        8: 2,  # 'ב'
        20: 2,  # 'ג'
        16: 2,  # 'ד'
        3: 3,  # 'ה'
        2: 2,  # 'ו'
        24: 2,  # 'ז'
        14: 2,  # 'ח'
        22: 1,  # 'ט'
        1: 2,  # 'י'
        25: 2,  # 'ך'
        15: 2,  # 'כ'
        4: 2,  # 'ל'
        11: 2,  # 'ם'
        6: 2,  # 'מ'
        23: 2,  # 'ן'
        12: 2,  # 'נ'
        19: 1,  # 'ס'
        13: 2,  # 'ע'
        26: 1,  # 'ף'
        18: 2,  # 'פ'
        27: 1,  # 'ץ'
        21: 2,  # 'צ'
        17: 2,  # 'ק'
        7: 2,  # 'ר'
        10: 2,  # 'ש'
        5: 2,  # 'ת'
        32: 0,  # '–'
        52: 0,  # '’'
        47: 0,  # '“'
        46: 0,  # '”'
        58: 0,  # '†'
        40: 0,  # '…'
    },
    35: {  # 'ֹ'
        50: 0,  # 'a'
        60: 0,  # 'c'
        61: 0,  # 'd'
        42: 0,  # 'e'
        53: 0,  # 'i'
        56: 0,  # 'l'
        54: 0,  # 'n'
        49: 0,  # 'o'
        51: 0,  # 'r'
        43: 0,  # 's'
        44: 0,  # 't'
        63: 0,  # 'u'
        34: 0,  # '\xa0'
        55: 0,  # '´'
        48: 0,  # '¼'
        39: 0,  # '½'
        57: 0,  # '¾'
        30: 0,  # 'ְ'
        59: 0,  # 'ֱ'
        41: 0,  # 'ֲ'
        33: 0,  # 'ִ'
        37: 0,  # 'ֵ'
        36: 0,  # 'ֶ'
        31: 0,  # 'ַ'
        29: 0,  # 'ָ'
        35: 1,  # 'ֹ'
        62: 0,  # 'ֻ'
        28: 0,  # 'ּ'
        38: 0,  # 'ׁ'
        45: 0,  # 'ׂ'
        9: 2,  # 'א'
        8: 2,  # 'ב'
        20: 1,  # 'ג'
        16: 2,  # 'ד'
        3: 2,  # 'ה'
        2: 1,  # 'ו'
        24: 1,  # 'ז'
        14: 1,  # 'ח'
        22: 1,  # 'ט'
        1: 1,  # 'י'
        25: 1,  # 'ך'
        15: 2,  # 'כ'
        4: 2,  # 'ל'
        11: 2,  # 'ם'
        6: 2,  # 'מ'
        23: 2,  # 'ן'
        12: 2,  # 'נ'
        19: 2,  # 'ס'
        13: 2,  # 'ע'
        26: 1,  # 'ף'
        18: 2,  # 'פ'
        27: 1,  # 'ץ'
        21: 2,  # 'צ'
        17: 2,  # 'ק'
        7: 2,  # 'ר'
        10: 2,  # 'ש'
        5: 2,  # 'ת'
        32: 0,  # '–'
        52: 0,  # '’'
        47: 0,  # '“'
        46: 0,  # '”'
        58: 0,  # '†'
        40: 0,  # '…'
    },
    62: {  # 'ֻ'
        50: 0,  # 'a'
        60: 0,  # 'c'
        61: 0,  # 'd'
        42: 0,  # 'e'
        53: 0,  # 'i'
        56: 0,  # 'l'
        54: 0,  # 'n'
        49: 0,  # 'o'
        51: 0,  # 'r'
        43: 0,  # 's'
        44: 0,  # 't'
        63: 0,  # 'u'
        34: 0,  # '\xa0'
        55: 0,  # '´'
        48: 0,  # '¼'
        39: 0,  # '½'
        57: 0,  # '¾'
        30: 0,  # 'ְ'
        59: 0,  # 'ֱ'
        41: 0,  # 'ֲ'
        33: 0,  # 'ִ'
        37: 0,  # 'ֵ'
        36: 0,  # 'ֶ'
        31: 0,  # 'ַ'
        29: 0,  # 'ָ'
        35: 0,  # 'ֹ'
        62: 0,  # 'ֻ'
        28: 0,  # 'ּ'
        38: 0,  # 'ׁ'
        45: 0,  # 'ׂ'
        9: 0,  # 'א'
        8: 1,  # 'ב'
        20: 1,  # 'ג'
        16: 1,  # 'ד'
        3: 1,  # 'ה'
        2: 1,  # 'ו'
        24: 1,  # 'ז'
        14: 1,  # 'ח'
        22: 0,  # 'ט'
        1: 1,  # 'י'
        25: 0,  # 'ך'
        15: 1,  # 'כ'
        4: 2,  # 'ל'
        11: 1,  # 'ם'
        6: 1,  # 'מ'
        23: 1,  # 'ן'
        12: 1,  # 'נ'
        19: 1,  # 'ס'
        13: 1,  # 'ע'
        26: 0,  # 'ף'
        18: 1,  # 'פ'
        27: 0,  # 'ץ'
        21: 1,  # 'צ'
        17: 1,  # 'ק'
        7: 1,  # 'ר'
        10: 1,  # 'ש'
        5: 1,  # 'ת'
        32: 0,  # '–'
        52: 0,  # '’'
        47: 0,  # '“'
        46: 0,  # '”'
        58: 0,  # '†'
        40: 0,  # '…'
    },
    28: {  # 'ּ'
        50: 0,  # 'a'
        60: 0,  # 'c'
        61: 0,  # 'd'
        42: 0,  # 'e'
        53: 0,  # 'i'
        56: 0,  # 'l'
        54: 0,  # 'n'
        49: 0,  # 'o'
        51: 0,  # 'r'
        43: 0,  # 's'
        44: 0,  # 't'
        63: 0,  # 'u'
        34: 0,  # '\xa0'
        55: 0,  # '´'
        48: 0,  # '¼'
        39: 0,  # '½'
        57: 0,  # '¾'
        30: 3,  # 'ְ'
        59: 0,  # 'ֱ'
        41: 1,  # 'ֲ'
        33: 3,  # 'ִ'
        37: 2,  # 'ֵ'
        36: 2,  # 'ֶ'
        31: 3,  # 'ַ'
        29: 3,  # 'ָ'
        35: 2,  # 'ֹ'
        62: 1,  # 'ֻ'
        28: 0,  # 'ּ'
        38: 2,  # 'ׁ'
        45: 1,  # 'ׂ'
        9: 2,  # 'א'
        8: 2,  # 'ב'
        20: 1,  # 'ג'
        16: 2,  # 'ד'
        3: 1,  # 'ה'
        2: 2,  # 'ו'
        24: 1,  # 'ז'
        14: 1,  # 'ח'
        22: 1,  # 'ט'
        1: 2,  # 'י'
        25: 2,  # 'ך'
        15: 2,  # 'כ'
        4: 2,  # 'ל'
        11: 1,  # 'ם'
        6: 2,  # 'מ'
        23: 1,  # 'ן'
        12: 2,  # 'נ'
        19: 1,  # 'ס'
        13: 2,  # 'ע'
        26: 1,  # 'ף'
        18: 1,  # 'פ'
        27: 1,  # 'ץ'
        21: 1,  # 'צ'
        17: 1,  # 'ק'
        7: 2,  # 'ר'
        10: 2,  # 'ש'
        5: 2,  # 'ת'
        32: 0,  # '–'
        52: 0,  # '’'
        47: 0,  # '“'
        46: 0,  # '”'
        58: 0,  # '†'
        40: 0,  # '…'
    },
    38: {  # 'ׁ'
        50: 0,  # 'a'
        60: 0,  # 'c'
        61: 0,  # 'd'
        42: 0,  # 'e'
        53: 0,  # 'i'
        56: 0,  # 'l'
        54: 0,  # 'n'
        49: 0,  # 'o'
        51: 0,  # 'r'
        43: 0,  # 's'
        44: 0,  # 't'
        63: 0,  # 'u'
        34: 0,  # '\xa0'
        55: 0,  # '´'
        48: 0,  # '¼'
        39: 0,  # '½'
        57: 0,  # '¾'
        30: 2,  # 'ְ'
        59: 0,  # 'ֱ'
        41: 0,  # 'ֲ'
        33: 2,  # 'ִ'
        37: 2,  # 'ֵ'
        36: 2,  # 'ֶ'
        31: 2,  # 'ַ'
        29: 2,  # 'ָ'
        35: 1,  # 'ֹ'
        62: 1,  # 'ֻ'
        28: 0,  # 'ּ'
        38: 0,  # 'ׁ'
        45: 0,  # 'ׂ'
        9: 0,  # 'א'
        8: 0,  # 'ב'
        20: 0,  # 'ג'
        16: 0,  # 'ד'
        3: 0,  # 'ה'
        2: 2,  # 'ו'
        24: 0,  # 'ז'
        14: 0,  # 'ח'
        22: 0,  # 'ט'
        1: 1,  # 'י'
        25: 0,  # 'ך'
        15: 0,  # 'כ'
        4: 0,  # 'ל'
        11: 0,  # 'ם'
        6: 0,  # 'מ'
        23: 0,  # 'ן'
        12: 0,  # 'נ'
        19: 0,  # 'ס'
        13: 1,  # 'ע'
        26: 0,  # 'ף'
        18: 0,  # 'פ'
        27: 0,  # 'ץ'
        21: 0,  # 'צ'
        17: 0,  # 'ק'
        7: 0,  # 'ר'
        10: 0,  # 'ש'
        5: 0,  # 'ת'
        32: 0,  # '–'
        52: 0,  # '’'
        47: 0,  # '“'
        46: 0,  # '”'
        58: 0,  # '†'
        40: 0,  # '…'
    },
    45: {  # 'ׂ'
        50: 0,  # 'a'
        60: 0,  # 'c'
        61: 0,  # 'd'
        42: 0,  # 'e'
        53: 0,  # 'i'
        56: 0,  # 'l'
        54: 0,  # 'n'
        49: 0,  # 'o'
        51: 0,  # 'r'
        43: 0,  # 's'
        44: 0,  # 't'
        63: 0,  # 'u'
        34: 0,  # '\xa0'
        55: 0,  # '´'
        48: 0,  # '¼'
        39: 0,  # '½'
        57: 0,  # '¾'
        30: 2,  # 'ְ'
        59: 0,  # 'ֱ'
        41: 0,  # 'ֲ'
        33: 2,  # 'ִ'
        37: 1,  # 'ֵ'
        36: 2,  # 'ֶ'
        31: 1,  # 'ַ'
        29: 2,  # 'ָ'
        35: 1,  # 'ֹ'
        62: 0,  # 'ֻ'
        28: 0,  # 'ּ'
        38: 0,  # 'ׁ'
        45: 0,  # 'ׂ'
        9: 1,  # 'א'
        8: 0,  # 'ב'
        20: 1,  # 'ג'
        16: 0,  # 'ד'
        3: 1,  # 'ה'
        2: 2,  # 'ו'
        24: 0,  # 'ז'
        14: 1,  # 'ח'
        22: 0,  # 'ט'
        1: 1,  # 'י'
        25: 0,  # 'ך'
        15: 0,  # 'כ'
        4: 0,  # 'ל'
        11: 1,  # 'ם'
        6: 1,  # 'מ'
        23: 0,  # 'ן'
        12: 1,  # 'נ'
        19: 0,  # 'ס'
        13: 1,  # 'ע'
        26: 0,  # 'ף'
        18: 1,  # 'פ'
        27: 0,  # 'ץ'
        21: 0,  # 'צ'
        17: 0,  # 'ק'
        7: 1,  # 'ר'
        10: 0,  # 'ש'
        5: 1,  # 'ת'
        32: 0,  # '–'
        52: 0,  # '’'
        47: 0,  # '“'
        46: 0,  # '”'
        58: 0,  # '†'
        40: 0,  # '…'
    },
    9: {  # 'א'
        50: 0,  # 'a'
        60: 0,  # 'c'
        61: 0,  # 'd'
        42: 0,  # 'e'
        53: 0,  # 'i'
        56: 0,  # 'l'
        54: 0,  # 'n'
        49: 0,  # 'o'
        51: 0,  # 'r'
        43: 0,  # 's'
        44: 0,  # 't'
        63: 0,  # 'u'
        34: 1,  # '\xa0'
        55: 1,  # '´'
        48: 1,  # '¼'
        39: 0,  # '½'
        57: 0,  # '¾'
        30: 0,  # 'ְ'
        59: 2,  # 'ֱ'
        41: 2,  # 'ֲ'
        33: 2,  # 'ִ'
        37: 2,  # 'ֵ'
        36: 2,  # 'ֶ'
        31: 2,  # 'ַ'
        29: 2,  # 'ָ'
        35: 2,  # 'ֹ'
        62: 1,  # 'ֻ'
        28: 0,  # 'ּ'
        38: 0,  # 'ׁ'
        45: 0,  # 'ׂ'
        9: 2,  # 'א'
        8: 3,  # 'ב'
        20: 3,  # 'ג'
        16: 3,  # 'ד'
        3: 3,  # 'ה'
        2: 3,  # 'ו'
        24: 3,  # 'ז'
        14: 3,  # 'ח'
        22: 3,  # 'ט'
        1: 3,  # 'י'
        25: 3,  # 'ך'
        15: 3,  # 'כ'
        4: 3,  # 'ל'
        11: 3,  # 'ם'
        6: 3,  # 'מ'
        23: 3,  # 'ן'
        12: 3,  # 'נ'
        19: 3,  # 'ס'
        13: 2,  # 'ע'
        26: 3,  # 'ף'
        18: 3,  # 'פ'
        27: 1,  # 'ץ'
        21: 3,  # 'צ'
        17: 3,  # 'ק'
        7: 3,  # 'ר'
        10: 3,  # 'ש'
        5: 3,  # 'ת'
        32: 0,  # '–'
        52: 0,  # '’'
        47: 0,  # '“'
        46: 1,  # '”'
        58: 0,  # '†'
        40: 1,  # '…'
    },
    8: {  # 'ב'
        50: 0,  # 'a'
        60: 0,  # 'c'
        61: 1,  # 'd'
        42: 0,  # 'e'
        53: 0,  # 'i'
        56: 0,  # 'l'
        54: 0,  # 'n'
        49: 0,  # 'o'
        51: 0,  # 'r'
        43: 0,  # 's'
        44: 0,  # 't'
        63: 0,  # 'u'
        34: 1,  # '\xa0'
        55: 1,  # '´'
        48: 0,  # '¼'
        39: 0,  # '½'
        57: 0,  # '¾'
        30: 2,  # 'ְ'
        59: 0,  # 'ֱ'
        41: 0,  # 'ֲ'
        33: 2,  # 'ִ'
        37: 2,  # 'ֵ'
        36: 2,  # 'ֶ'
        31: 2,  # 'ַ'
        29: 2,  # 'ָ'
        35: 2,  # 'ֹ'
        62: 1,  # 'ֻ'
        28: 3,  # 'ּ'
        38: 0,  # 'ׁ'
        45: 0,  # 'ׂ'
        9: 3,  # 'א'
        8: 3,  # 'ב'
        20: 3,  # 'ג'
        16: 3,  # 'ד'
        3: 3,  # 'ה'
        2: 3,  # 'ו'
        24: 3,  # 'ז'
        14: 3,  # 'ח'
        22: 3,  # 'ט'
        1: 3,  # 'י'
        25: 2,  # 'ך'
        15: 3,  # 'כ'
        4: 3,  # 'ל'
        11: 2,  # 'ם'
        6: 3,  # 'מ'
        23: 3,  # 'ן'
        12: 3,  # 'נ'
        19: 3,  # 'ס'
        13: 3,  # 'ע'
        26: 1,  # 'ף'
        18: 3,  # 'פ'
        27: 2,  # 'ץ'
        21: 3,  # 'צ'
        17: 3,  # 'ק'
        7: 3,  # 'ר'
        10: 3,  # 'ש'
        5: 3,  # 'ת'
        32: 1,  # '–'
        52: 0,  # '’'
        47: 0,  # '“'
        46: 1,  # '”'
        58: 0,  # '†'
        40: 1,  # '…'
    },
    20: {  # 'ג'
        50: 0,  # 'a'
        60: 0,  # 'c'
        61: 0,  # 'd'
        42: 0,  # 'e'
        53: 0,  # 'i'
        56: 0,  # 'l'
        54: 0,  # 'n'
        49: 0,  # 'o'
        51: 0,  # 'r'
        43: 0,  # 's'
        44: 0,  # 't'
        63: 0,  # 'u'
        34: 1,  # '\xa0'
        55: 2,  # '´'
        48: 0,  # '¼'
        39: 0,  # '½'
        57: 0,  # '¾'
        30: 2,  # 'ְ'
        59: 0,  # 'ֱ'
        41: 0,  # 'ֲ'
        33: 1,  # 'ִ'
        37: 1,  # 'ֵ'
        36: 1,  # 'ֶ'
        31: 2,  # 'ַ'
        29: 2,  # 'ָ'
        35: 1,  # 'ֹ'
        62: 0,  # 'ֻ'
        28: 2,  # 'ּ'
        38: 0,  # 'ׁ'
        45: 0,  # 'ׂ'
        9: 2,  # 'א'
        8: 3,  # 'ב'
        20: 2,  # 'ג'
        16: 3,  # 'ד'
        3: 3,  # 'ה'
        2: 3,  # 'ו'
        24: 3,  # 'ז'
        14: 2,  # 'ח'
        22: 2,  # 'ט'
        1: 3,  # 'י'
        25: 1,  # 'ך'
        15: 1,  # 'כ'
        4: 3,  # 'ל'
        11: 3,  # 'ם'
        6: 3,  # 'מ'
        23: 3,  # 'ן'
        12: 3,  # 'נ'
        19: 2,  # 'ס'
        13: 3,  # 'ע'
        26: 2,  # 'ף'
        18: 2,  # 'פ'
        27: 1,  # 'ץ'
        21: 1,  # 'צ'
        17: 1,  # 'ק'
        7: 3,  # 'ר'
        10: 3,  # 'ש'
        5: 3,  # 'ת'
        32: 0,  # '–'
        52: 1,  # '’'
        47: 0,  # '“'
        46: 1,  # '”'
        58: 0,  # '†'
        40: 0,  # '…'
    },
    16: {  # 'ד'
        50: 0,  # 'a'
        60: 0,  # 'c'
        61: 0,  # 'd'
        42: 0,  # 'e'
        53: 0,  # 'i'
        56: 0,  # 'l'
        54: 0,  # 'n'
        49: 0,  # 'o'
        51: 0,  # 'r'
        43: 0,  # 's'
        44: 0,  # 't'
        63: 0,  # 'u'
        34: 0,  # '\xa0'
        55: 0,  # '´'
        48: 0,  # '¼'
        39: 0,  # '½'
        57: 0,  # '¾'
        30: 2,  # 'ְ'
        59: 0,  # 'ֱ'
        41: 0,  # 'ֲ'
        33: 2,  # 'ִ'
        37: 2,  # 'ֵ'
        36: 2,  # 'ֶ'
        31: 2,  # 'ַ'
        29: 2,  # 'ָ'
        35: 2,  # 'ֹ'
        62: 1,  # 'ֻ'
        28: 2,  # 'ּ'
        38: 0,  # 'ׁ'
        45: 0,  # 'ׂ'
        9: 3,  # 'א'
        8: 3,  # 'ב'
        20: 3,  # 'ג'
        16: 3,  # 'ד'
        3: 3,  # 'ה'
        2: 3,  # 'ו'
        24: 1,  # 'ז'
        14: 2,  # 'ח'
        22: 2,  # 'ט'
        1: 3,  # 'י'
        25: 2,  # 'ך'
        15: 2,  # 'כ'
        4: 3,  # 'ל'
        11: 3,  # 'ם'
        6: 3,  # 'מ'
        23: 2,  # 'ן'
        12: 3,  # 'נ'
        19: 2,  # 'ס'
        13: 3,  # 'ע'
        26: 2,  # 'ף'
        18: 3,  # 'פ'
        27: 0,  # 'ץ'
        21: 2,  # 'צ'
        17: 3,  # 'ק'
        7: 3,  # 'ר'
        10: 3,  # 'ש'
        5: 3,  # 'ת'
        32: 0,  # '–'
        52: 0,  # '’'
        47: 0,  # '“'
        46: 1,  # '”'
        58: 0,  # '†'
        40: 1,  # '…'
    },
    3: {  # 'ה'
        50: 0,  # 'a'
        60: 0,  # 'c'
        61: 1,  # 'd'
        42: 0,  # 'e'
        53: 0,  # 'i'
        56: 0,  # 'l'
        54: 0,  # 'n'
        49: 0,  # 'o'
        51: 0,  # 'r'
        43: 0,  # 's'
        44: 0,  # 't'
        63: 0,  # 'u'
        34: 1,  # '\xa0'
        55: 0,  # '´'
        48: 1,  # '¼'
        39: 0,  # '½'
        57: 0,  # '¾'
        30: 1,  # 'ְ'
        59: 1,  # 'ֱ'
        41: 2,  # 'ֲ'
        33: 2,  # 'ִ'
        37: 2,  # 'ֵ'
        36: 2,  # 'ֶ'
        31: 3,  # 'ַ'
        29: 2,  # 'ָ'
        35: 1,  # 'ֹ'
        62: 1,  # 'ֻ'
        28: 2,  # 'ּ'
        38: 0,  # 'ׁ'
        45: 0,  # 'ׂ'
        9: 3,  # 'א'
        8: 3,  # 'ב'
        20: 3,  # 'ג'
        16: 3,  # 'ד'
        3: 3,  # 'ה'
        2: 3,  # 'ו'
        24: 3,  # 'ז'
        14: 3,  # 'ח'
        22: 3,  # 'ט'
        1: 3,  # 'י'
        25: 1,  # 'ך'
        15: 3,  # 'כ'
        4: 3,  # 'ל'
        11: 3,  # 'ם'
        6: 3,  # 'מ'
        23: 3,  # 'ן'
        12: 3,  # 'נ'
        19: 3,  # 'ס'
        13: 3,  # 'ע'
        26: 0,  # 'ף'
        18: 3,  # 'פ'
        27: 1,  # 'ץ'
        21: 3,  # 'צ'
        17: 3,  # 'ק'
        7: 3,  # 'ר'
        10: 3,  # 'ש'
        5: 3,  # 'ת'
        32: 1,  # '–'
        52: 1,  # '’'
        47: 0,  # '“'
        46: 1,  # '”'
        58: 0,  # '†'
        40: 2,  # '…'
    },
    2: {  # 'ו'
        50: 0,  # 'a'
        60: 0,  # 'c'
        61: 0,  # 'd'
        42: 0,  # 'e'
        53: 0,  # 'i'
        56: 0,  # 'l'
        54: 0,  # 'n'
        49: 0,  # 'o'
        51: 0,  # 'r'
        43: 0,  # 's'
        44: 1,  # 't'
        63: 0,  # 'u'
        34: 1,  # '\xa0'
        55: 1,  # '´'
        48: 1,  # '¼'
        39: 0,  # '½'
        57: 0,  # '¾'
        30: 2,  # 'ְ'
        59: 0,  # 'ֱ'
        41: 0,  # 'ֲ'
        33: 2,  # 'ִ'
        37: 1,  # 'ֵ'
        36: 1,  # 'ֶ'
        31: 2,  # 'ַ'
        29: 2,  # 'ָ'
        35: 3,  # 'ֹ'
        62: 0,  # 'ֻ'
        28: 3,  # 'ּ'
        38: 0,  # 'ׁ'
        45: 0,  # 'ׂ'
        9: 3,  # 'א'
        8: 3,  # 'ב'
        20: 3,  # 'ג'
        16: 3,  # 'ד'
        3: 3,  # 'ה'
        2: 3,  # 'ו'
        24: 3,  # 'ז'
        14: 3,  # 'ח'
        22: 3,  # 'ט'
        1: 3,  # 'י'
        25: 3,  # 'ך'
        15: 3,  # 'כ'
        4: 3,  # 'ל'
        11: 3,  # 'ם'
        6: 3,  # 'מ'
        23: 3,  # 'ן'
        12: 3,  # 'נ'
        19: 3,  # 'ס'
        13: 3,  # 'ע'
        26: 3,  # 'ף'
        18: 3,  # 'פ'
        27: 3,  # 'ץ'
        21: 3,  # 'צ'
        17: 3,  # 'ק'
        7: 3,  # 'ר'
        10: 3,  # 'ש'
        5: 3,  # 'ת'
        32: 1,  # '–'
        52: 0,  # '’'
        47: 0,  # '“'
        46: 1,  # '”'
        58: 0,  # '†'
        40: 2,  # '…'
    },
    24: {  # 'ז'
        50: 0,  # 'a'
        60: 0,  # 'c'
        61: 0,  # 'd'
        42: 0,  # 'e'
        53: 0,  # 'i'
        56: 0,  # 'l'
        54: 0,  # 'n'
        49: 0,  # 'o'
        51: 0,  # 'r'
        43: 0,  # 's'
        44: 0,  # 't'
        63: 0,  # 'u'
        34: 0,  # '\xa0'
        55: 1,  # '´'
        48: 0,  # '¼'
        39: 0,  # '½'
        57: 0,  # '¾'
        30: 2,  # 'ְ'
        59: 0,  # 'ֱ'
        41: 1,  # 'ֲ'
        33: 1,  # 'ִ'
        37: 2,  # 'ֵ'
        36: 2,  # 'ֶ'
        31: 2,  # 'ַ'
        29: 2,  # 'ָ'
        35: 1,  # 'ֹ'
        62: 1,  # 'ֻ'
        28: 2,  # 'ּ'
        38: 0,  # 'ׁ'
        45: 0,  # 'ׂ'
        9: 3,  # 'א'
        8: 2,  # 'ב'
        20: 2,  # 'ג'
        16: 2,  # 'ד'
        3: 3,  # 'ה'
        2: 3,  # 'ו'
        24: 2,  # 'ז'
        14: 2,  # 'ח'
        22: 1,  # 'ט'
        1: 3,  # 'י'
        25: 1,  # 'ך'
        15: 3,  # 'כ'
        4: 3,  # 'ל'
        11: 2,  # 'ם'
        6: 3,  # 'מ'
        23: 2,  # 'ן'
        12: 2,  # 'נ'
        19: 1,  # 'ס'
        13: 2,  # 'ע'
        26: 1,  # 'ף'
        18: 1,  # 'פ'
        27: 0,  # 'ץ'
        21: 2,  # 'צ'
        17: 3,  # 'ק'
        7: 3,  # 'ר'
        10: 1,  # 'ש'
        5: 2,  # 'ת'
        32: 0,  # '–'
        52: 0,  # '’'
        47: 0,  # '“'
        46: 0,  # '”'
        58: 0,  # '†'
        40: 1,  # '…'
    },
    14: {  # 'ח'
        50: 0,  # 'a'
        60: 0,  # 'c'
        61: 0,  # 'd'
        42: 0,  # 'e'
        53: 0,  # 'i'
        56: 0,  # 'l'
        54: 0,  # 'n'
        49: 0,  # 'o'
        51: 0,  # 'r'
        43: 0,  # 's'
        44: 0,  # 't'
        63: 0,  # 'u'
        34: 1,  # '\xa0'
        55: 1,  # '´'
        48: 0,  # '¼'
        39: 0,  # '½'
        57: 0,  # '¾'
        30: 2,  # 'ְ'
        59: 1,  # 'ֱ'
        41: 2,  # 'ֲ'
        33: 2,  # 'ִ'
        37: 2,  # 'ֵ'
        36: 2,  # 'ֶ'
        31: 2,  # 'ַ'
        29: 2,  # 'ָ'
        35: 2,  # 'ֹ'
        62: 1,  # 'ֻ'
        28: 0,  # 'ּ'
        38: 0,  # 'ׁ'
        45: 0,  # 'ׂ'
        9: 2,  # 'א'
        8: 3,  # 'ב'
        20: 2,  # 'ג'
        16: 3,  # 'ד'
        3: 3,  # 'ה'
        2: 3,  # 'ו'
        24: 3,  # 'ז'
        14: 2,  # 'ח'
        22: 2,  # 'ט'
        1: 3,  # 'י'
        25: 1,  # 'ך'
        15: 2,  # 'כ'
        4: 3,  # 'ל'
        11: 3,  # 'ם'
        6: 3,  # 'מ'
        23: 2,  # 'ן'
        12: 3,  # 'נ'
        19: 3,  # 'ס'
        13: 1,  # 'ע'
        26: 2,  # 'ף'
        18: 2,  # 'פ'
        27: 2,  # 'ץ'
        21: 3,  # 'צ'
        17: 3,  # 'ק'
        7: 3,  # 'ר'
        10: 3,  # 'ש'
        5: 3,  # 'ת'
        32: 0,  # '–'
        52: 1,  # '’'
        47: 0,  # '“'
        46: 1,  # '”'
        58: 0,  # '†'
        40: 1,  # '…'
    },
    22: {  # 'ט'
        50: 0,  # 'a'
        60: 0,  # 'c'
        61: 0,  # 'd'
        42: 0,  # 'e'
        53: 0,  # 'i'
        56: 0,  # 'l'
        54: 0,  # 'n'
        49: 0,  # 'o'
        51: 0,  # 'r'
        43: 0,  # 's'
        44: 0,  # 't'
        63: 0,  # 'u'
        34: 1,  # '\xa0'
        55: 0,  # '´'
        48: 0,  # '¼'
        39: 0,  # '½'
        57: 0,  # '¾'
        30: 2,  # 'ְ'
        59: 0,  # 'ֱ'
        41: 0,  # 'ֲ'
        33: 2,  # 'ִ'
        37: 1,  # 'ֵ'
        36: 1,  # 'ֶ'
        31: 2,  # 'ַ'
        29: 1,  # 'ָ'
        35: 1,  # 'ֹ'
        62: 1,  # 'ֻ'
        28: 1,  # 'ּ'
        38: 0,  # 'ׁ'
        45: 0,  # 'ׂ'
        9: 3,  # 'א'
        8: 3,  # 'ב'
        20: 3,  # 'ג'
        16: 1,  # 'ד'
        3: 3,  # 'ה'
        2: 3,  # 'ו'
        24: 2,  # 'ז'
        14: 3,  # 'ח'
        22: 2,  # 'ט'
        1: 3,  # 'י'
        25: 1,  # 'ך'
        15: 2,  # 'כ'
        4: 3,  # 'ל'
        11: 2,  # 'ם'
        6: 2,  # 'מ'
        23: 2,  # 'ן'
        12: 3,  # 'נ'
        19: 2,  # 'ס'
        13: 3,  # 'ע'
        26: 2,  # 'ף'
        18: 3,  # 'פ'
        27: 1,  # 'ץ'
        21: 2,  # 'צ'
        17: 2,  # 'ק'
        7: 3,  # 'ר'
        10: 2,  # 'ש'
        5: 3,  # 'ת'
        32: 0,  # '–'
        52: 0,  # '’'
        47: 0,  # '“'
        46: 0,  # '”'
        58: 0,  # '†'
        40: 1,  # '…'
    },
    1: {  # 'י'
        50: 0,  # 'a'
        60: 0,  # 'c'
        61: 0,  # 'd'
        42: 0,  # 'e'
        53: 0,  # 'i'
        56: 0,  # 'l'
        54: 0,  # 'n'
        49: 0,  # 'o'
        51: 0,  # 'r'
        43: 0,  # 's'
        44: 0,  # 't'
        63: 0,  # 'u'
        34: 1,  # '\xa0'
        55: 1,  # '´'
        48: 1,  # '¼'
        39: 0,  # '½'
        57: 0,  # '¾'
        30: 2,  # 'ְ'
        59: 0,  # 'ֱ'
        41: 0,  # 'ֲ'
        33: 2,  # 'ִ'
        37: 2,  # 'ֵ'
        36: 1,  # 'ֶ'
        31: 2,  # 'ַ'
        29: 2,  # 'ָ'
        35: 2,  # 'ֹ'
        62: 1,  # 'ֻ'
        28: 2,  # 'ּ'
        38: 0,  # 'ׁ'
        45: 0,  # 'ׂ'
        9: 3,  # 'א'
        8: 3,  # 'ב'
        20: 3,  # 'ג'
        16: 3,  # 'ד'
        3: 3,  # 'ה'
        2: 3,  # 'ו'
        24: 3,  # 'ז'
        14: 3,  # 'ח'
        22: 3,  # 'ט'
        1: 3,  # 'י'
        25: 3,  # 'ך'
        15: 3,  # 'כ'
        4: 3,  # 'ל'
        11: 3,  # 'ם'
        6: 3,  # 'מ'
        23: 3,  # 'ן'
        12: 3,  # 'נ'
        19: 3,  # 'ס'
        13: 3,  # 'ע'
        26: 3,  # 'ף'
        18: 3,  # 'פ'
        27: 3,  # 'ץ'
        21: 3,  # 'צ'
        17: 3,  # 'ק'
        7: 3,  # 'ר'
        10: 3,  # 'ש'
        5: 3,  # 'ת'
        32: 1,  # '–'
        52: 0,  # '’'
        47: 0,  # '“'
        46: 1,  # '”'
        58: 0,  # '†'
        40: 2,  # '…'
    },
    25: {  # 'ך'
        50: 0,  # 'a'
        60: 0,  # 'c'
        61: 0,  # 'd'
        42: 0,  # 'e'
        53: 0,  # 'i'
        56: 0,  # 'l'
        54: 0,  # 'n'
        49: 0,  # 'o'
        51: 0,  # 'r'
        43: 0,  # 's'
        44: 0,  # 't'
        63: 0,  # 'u'
        34: 0,  # '\xa0'
        55: 0,  # '´'
        48: 0,  # '¼'
        39: 0,  # '½'
        57: 0,  # '¾'
        30: 2,  # 'ְ'
        59: 0,  # 'ֱ'
        41: 0,  # 'ֲ'
        33: 0,  # 'ִ'
        37: 0,  # 'ֵ'
        36: 0,  # 'ֶ'
        31: 0,  # 'ַ'
        29: 2,  # 'ָ'
        35: 0,  # 'ֹ'
        62: 0,  # 'ֻ'
        28: 1,  # 'ּ'
        38: 0,  # 'ׁ'
        45: 0,  # 'ׂ'
        9: 1,  # 'א'
        8: 0,  # 'ב'
        20: 0,  # 'ג'
        16: 0,  # 'ד'
        3: 1,  # 'ה'
        2: 0,  # 'ו'
        24: 0,  # 'ז'
        14: 1,  # 'ח'
        22: 0,  # 'ט'
        1: 0,  # 'י'
        25: 0,  # 'ך'
        15: 0,  # 'כ'
        4: 1,  # 'ל'
        11: 0,  # 'ם'
        6: 1,  # 'מ'
        23: 0,  # 'ן'
        12: 0,  # 'נ'
        19: 0,  # 'ס'
        13: 0,  # 'ע'
        26: 0,  # 'ף'
        18: 0,  # 'פ'
        27: 0,  # 'ץ'
        21: 0,  # 'צ'
        17: 0,  # 'ק'
        7: 0,  # 'ר'
        10: 1,  # 'ש'
        5: 0,  # 'ת'
        32: 0,  # '–'
        52: 0,  # '’'
        47: 0,  # '“'
        46: 0,  # '”'
        58: 0,  # '†'
        40: 1,  # '…'
    },
    15: {  # 'כ'
        50: 0,  # 'a'
        60: 0,  # 'c'
        61: 0,  # 'd'
        42: 0,  # 'e'
        53: 0,  # 'i'
        56: 0,  # 'l'
        54: 0,  # 'n'
        49: 0,  # 'o'
        51: 0,  # 'r'
        43: 0,  # 's'
        44: 0,  # 't'
        63: 0,  # 'u'
        34: 0,  # '\xa0'
        55: 0,  # '´'
        48: 0,  # '¼'
        39: 0,  # '½'
        57: 0,  # '¾'
        30: 2,  # 'ְ'
        59: 0,  # 'ֱ'
        41: 0,  # 'ֲ'
        33: 2,  # 'ִ'
        37: 2,  # 'ֵ'
        36: 2,  # 'ֶ'
        31: 2,  # 'ַ'
        29: 2,  # 'ָ'
        35: 1,  # 'ֹ'
        62: 1,  # 'ֻ'
        28: 3,  # 'ּ'
        38: 0,  # 'ׁ'
        45: 0,  # 'ׂ'
        9: 3,  # 'א'
        8: 3,  # 'ב'
        20: 2,  # 'ג'
        16: 3,  # 'ד'
        3: 3,  # 'ה'
        2: 3,  # 'ו'
        24: 3,  # 'ז'
        14: 3,  # 'ח'
        22: 2,  # 'ט'
        1: 3,  # 'י'
        25: 3,  # 'ך'
        15: 3,  # 'כ'
        4: 3,  # 'ל'
        11: 3,  # 'ם'
        6: 3,  # 'מ'
        23: 3,  # 'ן'
        12: 3,  # 'נ'
        19: 3,  # 'ס'
        13: 2,  # 'ע'
        26: 3,  # 'ף'
        18: 3,  # 'פ'
        27: 1,  # 'ץ'
        21: 2,  # 'צ'
        17: 2,  # 'ק'
        7: 3,  # 'ר'
        10: 3,  # 'ש'
        5: 3,  # 'ת'
        32: 0,  # '–'
        52: 0,  # '’'
        47: 0,  # '“'
        46: 0,  # '”'
        58: 0,  # '†'
        40: 0,  # '…'
    },
    4: {  # 'ל'
        50: 0,  # 'a'
        60: 0,  # 'c'
        61: 0,  # 'd'
        42: 0,  # 'e'
        53: 0,  # 'i'
        56: 0,  # 'l'
        54: 0,  # 'n'
        49: 0,  # 'o'
        51: 0,  # 'r'
        43: 0,  # 's'
        44: 0,  # 't'
        63: 0,  # 'u'
        34: 1,  # '\xa0'
        55: 1,  # '´'
        48: 0,  # '¼'
        39: 0,  # '½'
        57: 0,  # '¾'
        30: 3,  # 'ְ'
        59: 0,  # 'ֱ'
        41: 0,  # 'ֲ'
        33: 2,  # 'ִ'
        37: 2,  # 'ֵ'
        36: 2,  # 'ֶ'
        31: 2,  # 'ַ'
        29: 2,  # 'ָ'
        35: 2,  # 'ֹ'
        62: 1,  # 'ֻ'
        28: 2,  # 'ּ'
        38: 0,  # 'ׁ'
        45: 0,  # 'ׂ'
        9: 3,  # 'א'
        8: 3,  # 'ב'
        20: 3,  # 'ג'
        16: 3,  # 'ד'
        3: 3,  # 'ה'
        2: 3,  # 'ו'
        24: 3,  # 'ז'
        14: 3,  # 'ח'
        22: 3,  # 'ט'
        1: 3,  # 'י'
        25: 3,  # 'ך'
        15: 3,  # 'כ'
        4: 3,  # 'ל'
        11: 3,  # 'ם'
        6: 3,  # 'מ'
        23: 2,  # 'ן'
        12: 3,  # 'נ'
        19: 3,  # 'ס'
        13: 3,  # 'ע'
        26: 2,  # 'ף'
        18: 3,  # 'פ'
        27: 2,  # 'ץ'
        21: 3,  # 'צ'
        17: 3,  # 'ק'
        7: 3,  # 'ר'
        10: 3,  # 'ש'
        5: 3,  # 'ת'
        32: 1,  # '–'
        52: 0,  # '’'
        47: 0,  # '“'
        46: 1,  # '”'
        58: 0,  # '†'
        40: 1,  # '…'
    },
    11: {  # 'ם'
        50: 0,  # 'a'
        60: 0,  # 'c'
        61: 0,  # 'd'
        42: 0,  # 'e'
        53: 0,  # 'i'
        56: 0,  # 'l'
        54: 0,  # 'n'
        49: 0,  # 'o'
        51: 0,  # 'r'
        43: 0,  # 's'
        44: 0,  # 't'
        63: 0,  # 'u'
        34: 1,  # '\xa0'
        55: 0,  # '´'
        48: 0,  # '¼'
        39: 0,  # '½'
        57: 0,  # '¾'
        30: 0,  # 'ְ'
        59: 0,  # 'ֱ'
        41: 0,  # 'ֲ'
        33: 0,  # 'ִ'
        37: 0,  # 'ֵ'
        36: 0,  # 'ֶ'
        31: 0,  # 'ַ'
        29: 0,  # 'ָ'
        35: 0,  # 'ֹ'
        62: 0,  # 'ֻ'
        28: 0,  # 'ּ'
        38: 0,  # 'ׁ'
        45: 0,  # 'ׂ'
        9: 1,  # 'א'
        8: 1,  # 'ב'
        20: 1,  # 'ג'
        16: 0,  # 'ד'
        3: 1,  # 'ה'
        2: 1,  # 'ו'
        24: 1,  # 'ז'
        14: 1,  # 'ח'
        22: 0,  # 'ט'
        1: 1,  # 'י'
        25: 0,  # 'ך'
        15: 1,  # 'כ'
        4: 1,  # 'ל'
        11: 1,  # 'ם'
        6: 1,  # 'מ'
        23: 0,  # 'ן'
        12: 1,  # 'נ'
        19: 0,  # 'ס'
        13: 1,  # 'ע'
        26: 0,  # 'ף'
        18: 1,  # 'פ'
        27: 1,  # 'ץ'
        21: 1,  # 'צ'
        17: 1,  # 'ק'
        7: 1,  # 'ר'
        10: 1,  # 'ש'
        5: 1,  # 'ת'
        32: 0,  # '–'
        52: 0,  # '’'
        47: 0,  # '“'
        46: 1,  # '”'
        58: 0,  # '†'
        40: 2,  # '…'
    },
    6: {  # 'מ'
        50: 0,  # 'a'
        60: 0,  # 'c'
        61: 0,  # 'd'
        42: 0,  # 'e'
        53: 0,  # 'i'
        56: 0,  # 'l'
        54: 0,  # 'n'
        49: 0,  # 'o'
        51: 0,  # 'r'
        43: 0,  # 's'
        44: 0,  # 't'
        63: 0,  # 'u'
        34: 0,  # '\xa0'
        55: 1,  # '´'
        48: 0,  # '¼'
        39: 0,  # '½'
        57: 0,  # '¾'
        30: 2,  # 'ְ'
        59: 0,  # 'ֱ'
        41: 0,  # 'ֲ'
        33: 2,  # 'ִ'
        37: 2,  # 'ֵ'
        36: 2,  # 'ֶ'
        31: 2,  # 'ַ'
        29: 2,  # 'ָ'
        35: 2,  # 'ֹ'
        62: 1,  # 'ֻ'
        28: 2,  # 'ּ'
        38: 0,  # 'ׁ'
        45: 0,  # 'ׂ'
        9: 3,  # 'א'
        8: 3,  # 'ב'
        20: 3,  # 'ג'
        16: 3,  # 'ד'
        3: 3,  # 'ה'
        2: 3,  # 'ו'
        24: 3,  # 'ז'
        14: 3,  # 'ח'
        22: 3,  # 'ט'
        1: 3,  # 'י'
        25: 2,  # 'ך'
        15: 3,  # 'כ'
        4: 3,  # 'ל'
        11: 3,  # 'ם'
        6: 3,  # 'מ'
        23: 3,  # 'ן'
        12: 3,  # 'נ'
        19: 3,  # 'ס'
        13: 3,  # 'ע'
        26: 0,  # 'ף'
        18: 3,  # 'פ'
        27: 2,  # 'ץ'
        21: 3,  # 'צ'
        17: 3,  # 'ק'
        7: 3,  # 'ר'
        10: 3,  # 'ש'
        5: 3,  # 'ת'
        32: 0,  # '–'
        52: 0,  # '’'
        47: 0,  # '“'
        46: 0,  # '”'
        58: 0,  # '†'
        40: 1,  # '…'
    },
    23: {  # 'ן'
        50: 0,  # 'a'
        60: 0,  # 'c'
        61: 0,  # 'd'
        42: 0,  # 'e'
        53: 0,  # 'i'
        56: 0,  # 'l'
        54: 0,  # 'n'
        49: 0,  # 'o'
        51: 0,  # 'r'
        43: 0,  # 's'
        44: 0,  # 't'
        63: 0,  # 'u'
        34: 1,  # '\xa0'
        55: 0,  # '´'
        48: 1,  # '¼'
        39: 0,  # '½'
        57: 0,  # '¾'
        30: 0,  # 'ְ'
        59: 0,  # 'ֱ'
        41: 0,  # 'ֲ'
        33: 0,  # 'ִ'
        37: 0,  # 'ֵ'
        36: 0,  # 'ֶ'
        31: 0,  # 'ַ'
        29: 0,  # 'ָ'
        35: 0,  # 'ֹ'
        62: 0,  # 'ֻ'
        28: 0,  # 'ּ'
        38: 0,  # 'ׁ'
        45: 0,  # 'ׂ'
        9: 1,  # 'א'
        8: 1,  # 'ב'
        20: 1,  # 'ג'
        16: 1,  # 'ד'
        3: 1,  # 'ה'
        2: 1,  # 'ו'
        24: 0,  # 'ז'
        14: 1,  # 'ח'
        22: 1,  # 'ט'
        1: 1,  # 'י'
        25: 0,  # 'ך'
        15: 1,  # 'כ'
        4: 1,  # 'ל'
        11: 1,  # 'ם'
        6: 1,  # 'מ'
        23: 0,  # 'ן'
        12: 1,  # 'נ'
        19: 1,  # 'ס'
        13: 1,  # 'ע'
        26: 1,  # 'ף'
        18: 1,  # 'פ'
        27: 0,  # 'ץ'
        21: 0,  # 'צ'
        17: 1,  # 'ק'
        7: 1,  # 'ר'
        10: 1,  # 'ש'
        5: 1,  # 'ת'
        32: 1,  # '–'
        52: 0,  # '’'
        47: 0,  # '“'
        46: 1,  # '”'
        58: 0,  # '†'
        40: 2,  # '…'
    },
    12: {  # 'נ'
        50: 0,  # 'a'
        60: 0,  # 'c'
        61: 0,  # 'd'
        42: 0,  # 'e'
        53: 0,  # 'i'
        56: 0,  # 'l'
        54: 0,  # 'n'
        49: 0,  # 'o'
        51: 0,  # 'r'
        43: 0,  # 's'
        44: 0,  # 't'
        63: 0,  # 'u'
        34: 0,  # '\xa0'
        55: 0,  # '´'
        48: 0,  # '¼'
        39: 0,  # '½'
        57: 0,  # '¾'
        30: 2,  # 'ְ'
        59: 0,  # 'ֱ'
        41: 0,  # 'ֲ'
        33: 2,  # 'ִ'
        37: 2,  # 'ֵ'
        36: 2,  # 'ֶ'
        31: 2,  # 'ַ'
        29: 2,  # 'ָ'
        35: 1,  # 'ֹ'
        62: 1,  # 'ֻ'
        28: 2,  # 'ּ'
        38: 0,  # 'ׁ'
        45: 0,  # 'ׂ'
        9: 3,  # 'א'
        8: 3,  # 'ב'
        20: 3,  # 'ג'
        16: 3,  # 'ד'
        3: 3,  # 'ה'
        2: 3,  # 'ו'
        24: 3,  # 'ז'
        14: 3,  # 'ח'
        22: 3,  # 'ט'
        1: 3,  # 'י'
        25: 2,  # 'ך'
        15: 3,  # 'כ'
        4: 3,  # 'ל'
        11: 3,  # 'ם'
        6: 3,  # 'מ'
        23: 3,  # 'ן'
        12: 3,  # 'נ'
        19: 3,  # 'ס'
        13: 3,  # 'ע'
        26: 2,  # 'ף'
        18: 3,  # 'פ'
        27: 2,  # 'ץ'
        21: 3,  # 'צ'
        17: 3,  # 'ק'
        7: 3,  # 'ר'
        10: 3,  # 'ש'
        5: 3,  # 'ת'
        32: 0,  # '–'
        52: 0,  # '’'
        47: 0,  # '“'
        46: 0,  # '”'
        58: 0,  # '†'
        40: 0,  # '…'
    },
    19: {  # 'ס'
        50: 0,  # 'a'
        60: 0,  # 'c'
        61: 0,  # 'd'
        42: 0,  # 'e'
        53: 0,  # 'i'
        56: 0,  # 'l'
        54: 0,  # 'n'
        49: 0,  # 'o'
        51: 0,  # 'r'
        43: 0,  # 's'
        44: 0,  # 't'
        63: 0,  # 'u'
        34: 1,  # '\xa0'
        55: 1,  # '´'
        48: 0,  # '¼'
        39: 0,  # '½'
        57: 0,  # '¾'
        30: 2,  # 'ְ'
        59: 0,  # 'ֱ'
        41: 0,  # 'ֲ'
        33: 2,  # 'ִ'
        37: 1,  # 'ֵ'
        36: 2,  # 'ֶ'
        31: 2,  # 'ַ'
        29: 1,  # 'ָ'
        35: 1,  # 'ֹ'
        62: 2,  # 'ֻ'
        28: 2,  # 'ּ'
        38: 0,  # 'ׁ'
        45: 0,  # 'ׂ'
        9: 2,  # 'א'
        8: 3,  # 'ב'
        20: 3,  # 'ג'
        16: 3,  # 'ד'
        3: 3,  # 'ה'
        2: 3,  # 'ו'
        24: 1,  # 'ז'
        14: 3,  # 'ח'
        22: 3,  # 'ט'
        1: 3,  # 'י'
        25: 2,  # 'ך'
        15: 3,  # 'כ'
        4: 3,  # 'ל'
        11: 2,  # 'ם'
        6: 3,  # 'מ'
        23: 2,  # 'ן'
        12: 3,  # 'נ'
        19: 2,  # 'ס'
        13: 3,  # 'ע'
        26: 3,  # 'ף'
        18: 3,  # 'פ'
        27: 0,  # 'ץ'
        21: 2,  # 'צ'
        17: 3,  # 'ק'
        7: 3,  # 'ר'
        10: 1,  # 'ש'
        5: 3,  # 'ת'
        32: 0,  # '–'
        52: 0,  # '’'
        47: 0,  # '“'
        46: 1,  # '”'
        58: 0,  # '†'
        40: 1,  # '…'
    },
    13: {  # 'ע'
        50: 0,  # 'a'
        60: 0,  # 'c'
        61: 0,  # 'd'
        42: 0,  # 'e'
        53: 0,  # 'i'
        56: 0,  # 'l'
        54: 0,  # 'n'
        49: 0,  # 'o'
        51: 0,  # 'r'
        43: 0,  # 's'
        44: 0,  # 't'
        63: 0,  # 'u'
        34: 0,  # '\xa0'
        55: 0,  # '´'
        48: 1,  # '¼'
        39: 0,  # '½'
        57: 0,  # '¾'
        30: 1,  # 'ְ'
        59: 1,  # 'ֱ'
        41: 2,  # 'ֲ'
        33: 2,  # 'ִ'
        37: 2,  # 'ֵ'
        36: 2,  # 'ֶ'
        31: 2,  # 'ַ'
        29: 2,  # 'ָ'
        35: 2,  # 'ֹ'
        62: 1,  # 'ֻ'
        28: 0,  # 'ּ'
        38: 0,  # 'ׁ'
        45: 0,  # 'ׂ'
        9: 2,  # 'א'
        8: 3,  # 'ב'
        20: 3,  # 'ג'
        16: 3,  # 'ד'
        3: 3,  # 'ה'
        2: 3,  # 'ו'
        24: 3,  # 'ז'
        14: 1,  # 'ח'
        22: 3,  # 'ט'
        1: 3,  # 'י'
        25: 2,  # 'ך'
        15: 2,  # 'כ'
        4: 3,  # 'ל'
        11: 3,  # 'ם'
        6: 3,  # 'מ'
        23: 2,  # 'ן'
        12: 3,  # 'נ'
        19: 3,  # 'ס'
        13: 2,  # 'ע'
        26: 1,  # 'ף'
        18: 2,  # 'פ'
        27: 2,  # 'ץ'
        21: 3,  # 'צ'
        17: 3,  # 'ק'
        7: 3,  # 'ר'
        10: 3,  # 'ש'
        5: 3,  # 'ת'
        32: 0,  # '–'
        52: 0,  # '’'
        47: 0,  # '“'
        46: 1,  # '”'
        58: 0,  # '†'
        40: 1,  # '…'
    },
    26: {  # 'ף'
        50: 0,  # 'a'
        60: 0,  # 'c'
        61: 0,  # 'd'
        42: 0,  # 'e'
        53: 0,  # 'i'
        56: 0,  # 'l'
        54: 0,  # 'n'
        49: 0,  # 'o'
        51: 0,  # 'r'
        43: 0,  # 's'
        44: 0,  # 't'
        63: 0,  # 'u'
        34: 0,  # '\xa0'
        55: 0,  # '´'
        48: 0,  # '¼'
        39: 0,  # '½'
        57: 0,  # '¾'
        30: 0,  # 'ְ'
        59: 0,  # 'ֱ'
        41: 0,  # 'ֲ'
        33: 0,  # 'ִ'
        37: 0,  # 'ֵ'
        36: 0,  # 'ֶ'
        31: 0,  # 'ַ'
        29: 0,  # 'ָ'
        35: 0,  # 'ֹ'
        62: 0,  # 'ֻ'
        28: 0,  # 'ּ'
        38: 0,  # 'ׁ'
        45: 0,  # 'ׂ'
        9: 1,  # 'א'
        8: 0,  # 'ב'
        20: 0,  # 'ג'
        16: 0,  # 'ד'
        3: 0,  # 'ה'
        2: 1,  # 'ו'
        24: 0,  # 'ז'
        14: 1,  # 'ח'
        22: 0,  # 'ט'
        1: 0,  # 'י'
        25: 0,  # 'ך'
        15: 1,  # 'כ'
        4: 1,  # 'ל'
        11: 0,  # 'ם'
        6: 1,  # 'מ'
        23: 0,  # 'ן'
        12: 0,  # 'נ'
        19: 1,  # 'ס'
        13: 0,  # 'ע'
        26: 1,  # 'ף'
        18: 1,  # 'פ'
        27: 0,  # 'ץ'
        21: 0,  # 'צ'
        17: 1,  # 'ק'
        7: 1,  # 'ר'
        10: 1,  # 'ש'
        5: 0,  # 'ת'
        32: 0,  # '–'
        52: 0,  # '’'
        47: 0,  # '“'
        46: 0,  # '”'
        58: 0,  # '†'
        40: 1,  # '…'
    },
    18: {  # 'פ'
        50: 0,  # 'a'
        60: 0,  # 'c'
        61: 0,  # 'd'
        42: 0,  # 'e'
        53: 0,  # 'i'
        56: 0,  # 'l'
        54: 0,  # 'n'
        49: 0,  # 'o'
        51: 0,  # 'r'
        43: 0,  # 's'
        44: 0,  # 't'
        63: 0,  # 'u'
        34: 0,  # '\xa0'
        55: 1,  # '´'
        48: 0,  # '¼'
        39: 0,  # '½'
        57: 0,  # '¾'
        30: 2,  # 'ְ'
        59: 0,  # 'ֱ'
        41: 0,  # 'ֲ'
        33: 2,  # 'ִ'
        37: 1,  # 'ֵ'
        36: 2,  # 'ֶ'
        31: 1,  # 'ַ'
        29: 2,  # 'ָ'
        35: 1,  # 'ֹ'
        62: 1,  # 'ֻ'
        28: 2,  # 'ּ'
        38: 0,  # 'ׁ'
        45: 0,  # 'ׂ'
        9: 3,  # 'א'
        8: 2,  # 'ב'
        20: 3,  # 'ג'
        16: 2,  # 'ד'
        3: 3,  # 'ה'
        2: 3,  # 'ו'
        24: 2,  # 'ז'
        14: 3,  # 'ח'
        22: 3,  # 'ט'
        1: 3,  # 'י'
        25: 2,  # 'ך'
        15: 3,  # 'כ'
        4: 3,  # 'ל'
        11: 2,  # 'ם'
        6: 2,  # 'מ'
        23: 3,  # 'ן'
        12: 3,  # 'נ'
        19: 3,  # 'ס'
        13: 3,  # 'ע'
        26: 2,  # 'ף'
        18: 2,  # 'פ'
        27: 2,  # 'ץ'
        21: 3,  # 'צ'
        17: 3,  # 'ק'
        7: 3,  # 'ר'
        10: 3,  # 'ש'
        5: 3,  # 'ת'
        32: 0,  # '–'
        52: 0,  # '’'
        47: 0,  # '“'
        46: 1,  # '”'
        58: 0,  # '†'
        40: 0,  # '…'
    },
    27: {  # 'ץ'
        50: 0,  # 'a'
        60: 0,  # 'c'
        61: 0,  # 'd'
        42: 0,  # 'e'
        53: 0,  # 'i'
        56: 0,  # 'l'
        54: 0,  # 'n'
        49: 0,  # 'o'
        51: 0,  # 'r'
        43: 0,  # 's'
        44: 0,  # 't'
        63: 0,  # 'u'
        34: 0,  # '\xa0'
        55: 1,  # '´'
        48: 0,  # '¼'
        39: 0,  # '½'
        57: 0,  # '¾'
        30: 0,  # 'ְ'
        59: 0,  # 'ֱ'
        41: 0,  # 'ֲ'
        33: 0,  # 'ִ'
        37: 0,  # 'ֵ'
        36: 0,  # 'ֶ'
        31: 0,  # 'ַ'
        29: 0,  # 'ָ'
        35: 0,  # 'ֹ'
        62: 0,  # 'ֻ'
        28: 0,  # 'ּ'
        38: 0,  # 'ׁ'
        45: 0,  # 'ׂ'
        9: 1,  # 'א'
        8: 0,  # 'ב'
        20: 0,  # 'ג'
        16: 0,  # 'ד'
        3: 0,  # 'ה'
        2: 0,  # 'ו'
        24: 0,  # 'ז'
        14: 0,  # 'ח'
        22: 0,  # 'ט'
        1: 0,  # 'י'
        25: 0,  # 'ך'
        15: 0,  # 'כ'
        4: 1,  # 'ל'
        11: 0,  # 'ם'
        6: 0,  # 'מ'
        23: 0,  # 'ן'
        12: 0,  # 'נ'
        19: 1,  # 'ס'
        13: 0,  # 'ע'
        26: 0,  # 'ף'
        18: 0,  # 'פ'
        27: 0,  # 'ץ'
        21: 0,  # 'צ'
        17: 0,  # 'ק'
        7: 1,  # 'ר'
        10: 0,  # 'ש'
        5: 1,  # 'ת'
        32: 0,  # '–'
        52: 0,  # '’'
        47: 0,  # '“'
        46: 0,  # '”'
        58: 0,  # '†'
        40: 1,  # '…'
    },
    21: {  # 'צ'
        50: 0,  # 'a'
        60: 0,  # 'c'
        61: 0,  # 'd'
        42: 0,  # 'e'
        53: 0,  # 'i'
        56: 0,  # 'l'
        54: 0,  # 'n'
        49: 0,  # 'o'
        51: 0,  # 'r'
        43: 0,  # 's'
        44: 0,  # 't'
        63: 0,  # 'u'
        34: 0,  # '\xa0'
        55: 1,  # '´'
        48: 0,  # '¼'
        39: 0,  # '½'
        57: 0,  # '¾'
        30: 2,  # 'ְ'
        59: 0,  # 'ֱ'
        41: 0,  # 'ֲ'
        33: 2,  # 'ִ'
        37: 2,  # 'ֵ'
        36: 1,  # 'ֶ'
        31: 2,  # 'ַ'
        29: 2,  # 'ָ'
        35: 1,  # 'ֹ'
        62: 1,  # 'ֻ'
        28: 2,  # 'ּ'
        38: 0,  # 'ׁ'
        45: 0,  # 'ׂ'
        9: 3,  # 'א'
        8: 3,  # 'ב'
        20: 2,  # 'ג'
        16: 3,  # 'ד'
        3: 3,  # 'ה'
        2: 3,  # 'ו'
        24: 1,  # 'ז'
        14: 3,  # 'ח'
        22: 2,  # 'ט'
        1: 3,  # 'י'
        25: 1,  # 'ך'
        15: 1,  # 'כ'
        4: 3,  # 'ל'
        11: 2,  # 'ם'
        6: 3,  # 'מ'
        23: 2,  # 'ן'
        12: 3,  # 'נ'
        19: 1,  # 'ס'
        13: 3,  # 'ע'
        26: 2,  # 'ף'
        18: 3,  # 'פ'
        27: 2,  # 'ץ'
        21: 2,  # 'צ'
        17: 3,  # 'ק'
        7: 3,  # 'ר'
        10: 0,  # 'ש'
        5: 3,  # 'ת'
        32: 0,  # '–'
        52: 0,  # '’'
        47: 0,  # '“'
        46: 0,  # '”'
        58: 0,  # '†'
        40: 0,  # '…'
    },
    17: {  # 'ק'
        50: 0,  # 'a'
        60: 0,  # 'c'
        61: 0,  # 'd'
        42: 0,  # 'e'
        53: 0,  # 'i'
        56: 0,  # 'l'
        54: 0,  # 'n'
        49: 0,  # 'o'
        51: 0,  # 'r'
        43: 0,  # 's'
        44: 0,  # 't'
        63: 0,  # 'u'
        34: 1,  # '\xa0'
        55: 1,  # '´'
        48: 0,  # '¼'
        39: 0,  # '½'
        57: 0,  # '¾'
        30: 2,  # 'ְ'
        59: 0,  # 'ֱ'
        41: 0,  # 'ֲ'
        33: 2,  # 'ִ'
        37: 2,  # 'ֵ'
        36: 1,  # 'ֶ'
        31: 2,  # 'ַ'
        29: 2,  # 'ָ'
        35: 2,  # 'ֹ'
        62: 1,  # 'ֻ'
        28: 2,  # 'ּ'
        38: 0,  # 'ׁ'
        45: 0,  # 'ׂ'
        9: 3,  # 'א'
        8: 3,  # 'ב'
        20: 2,  # 'ג'
        16: 3,  # 'ד'
        3: 3,  # 'ה'
        2: 3,  # 'ו'
        24: 2,  # 'ז'
        14: 3,  # 'ח'
        22: 3,  # 'ט'
        1: 3,  # 'י'
        25: 1,  # 'ך'
        15: 1,  # 'כ'
        4: 3,  # 'ל'
        11: 2,  # 'ם'
        6: 3,  # 'מ'
        23: 2,  # 'ן'
        12: 3,  # 'נ'
        19: 3,  # 'ס'
        13: 3,  # 'ע'
        26: 2,  # 'ף'
        18: 3,  # 'פ'
        27: 2,  # 'ץ'
        21: 3,  # 'צ'
        17: 2,  # 'ק'
        7: 3,  # 'ר'
        10: 3,  # 'ש'
        5: 3,  # 'ת'
        32: 0,  # '–'
        52: 1,  # '’'
        47: 0,  # '“'
        46: 1,  # '”'
        58: 0,  # '†'
        40: 1,  # '…'
    },
    7: {  # 'ר'
        50: 0,  # 'a'
        60: 0,  # 'c'
        61: 0,  # 'd'
        42: 0,  # 'e'
        53: 0,  # 'i'
        56: 0,  # 'l'
        54: 0,  # 'n'
        49: 0,  # 'o'
        51: 0,  # 'r'
        43: 0,  # 's'
        44: 0,  # 't'
        63: 0,  # 'u'
        34: 1,  # '\xa0'
        55: 2,  # '´'
        48: 1,  # '¼'
        39: 0,  # '½'
        57: 0,  # '¾'
        30: 2,  # 'ְ'
        59: 0,  # 'ֱ'
        41: 1,  # 'ֲ'
        33: 2,  # 'ִ'
        37: 2,  # 'ֵ'
        36: 2,  # 'ֶ'
        31: 2,  # 'ַ'
        29: 2,  # 'ָ'
        35: 2,  # 'ֹ'
        62: 1,  # 'ֻ'
        28: 0,  # 'ּ'
        38: 0,  # 'ׁ'
        45: 0,  # 'ׂ'
        9: 3,  # 'א'
        8: 3,  # 'ב'
        20: 3,  # 'ג'
        16: 3,  # 'ד'
        3: 3,  # 'ה'
        2: 3,  # 'ו'
        24: 3,  # 'ז'
        14: 3,  # 'ח'
        22: 3,  # 'ט'
        1: 3,  # 'י'
        25: 3,  # 'ך'
        15: 3,  # 'כ'
        4: 3,  # 'ל'
        11: 3,  # 'ם'
        6: 3,  # 'מ'
        23: 3,  # 'ן'
        12: 3,  # 'נ'
        19: 3,  # 'ס'
        13: 3,  # 'ע'
        26: 2,  # 'ף'
        18: 3,  # 'פ'
        27: 3,  # 'ץ'
        21: 3,  # 'צ'
        17: 3,  # 'ק'
        7: 3,  # 'ר'
        10: 3,  # 'ש'
        5: 3,  # 'ת'
        32: 0,  # '–'
        52: 0,  # '’'
        47: 0,  # '“'
        46: 1,  # '”'
        58: 0,  # '†'
        40: 2,  # '…'
    },
    10: {  # 'ש'
        50: 0,  # 'a'
        60: 0,  # 'c'
        61: 0,  # 'd'
        42: 0,  # 'e'
        53: 0,  # 'i'
        56: 0,  # 'l'
        54: 0,  # 'n'
        49: 0,  # 'o'
        51: 0,  # 'r'
        43: 0,  # 's'
        44: 0,  # 't'
        63: 0,  # 'u'
        34: 1,  # '\xa0'
        55: 0,  # '´'
        48: 0,  # '¼'
        39: 0,  # '½'
        57: 0,  # '¾'
        30: 1,  # 'ְ'
        59: 0,  # 'ֱ'
        41: 0,  # 'ֲ'
        33: 1,  # 'ִ'
        37: 1,  # 'ֵ'
        36: 1,  # 'ֶ'
        31: 1,  # 'ַ'
        29: 1,  # 'ָ'
        35: 1,  # 'ֹ'
        62: 1,  # 'ֻ'
        28: 2,  # 'ּ'
        38: 3,  # 'ׁ'
        45: 2,  # 'ׂ'
        9: 3,  # 'א'
        8: 3,  # 'ב'
        20: 3,  # 'ג'
        16: 3,  # 'ד'
        3: 3,  # 'ה'
        2: 3,  # 'ו'
        24: 2,  # 'ז'
        14: 3,  # 'ח'
        22: 3,  # 'ט'
        1: 3,  # 'י'
        25: 3,  # 'ך'
        15: 3,  # 'כ'
        4: 3,  # 'ל'
        11: 3,  # 'ם'
        6: 3,  # 'מ'
        23: 2,  # 'ן'
        12: 3,  # 'נ'
        19: 2,  # 'ס'
        13: 3,  # 'ע'
        26: 2,  # 'ף'
        18: 3,  # 'פ'
        27: 1,  # 'ץ'
        21: 2,  # 'צ'
        17: 3,  # 'ק'
        7: 3,  # 'ר'
        10: 3,  # 'ש'
        5: 3,  # 'ת'
        32: 0,  # '–'
        52: 0,  # '’'
        47: 0,  # '“'
        46: 1,  # '”'
        58: 0,  # '†'
        40: 1,  # '…'
    },
    5: {  # 'ת'
        50: 0,  # 'a'
        60: 0,  # 'c'
        61: 0,  # 'd'
        42: 0,  # 'e'
        53: 0,  # 'i'
        56: 0,  # 'l'
        54: 0,  # 'n'
        49: 0,  # 'o'
        51: 0,  # 'r'
        43: 0,  # 's'
        44: 0,  # 't'
        63: 0,  # 'u'
        34: 1,  # '\xa0'
        55: 0,  # '´'
        48: 1,  # '¼'
        39: 1,  # '½'
        57: 0,  # '¾'
        30: 2,  # 'ְ'
        59: 0,  # 'ֱ'
        41: 0,  # 'ֲ'
        33: 2,  # 'ִ'
        37: 2,  # 'ֵ'
        36: 2,  # 'ֶ'
        31: 2,  # 'ַ'
        29: 2,  # 'ָ'
        35: 1,  # 'ֹ'
        62: 1,  # 'ֻ'
        28: 2,  # 'ּ'
        38: 0,  # 'ׁ'
        45: 0,  # 'ׂ'
        9: 3,  # 'א'
        8: 3,  # 'ב'
        20: 3,  # 'ג'
        16: 2,  # 'ד'
        3: 3,  # 'ה'
        2: 3,  # 'ו'
        24: 2,  # 'ז'
        14: 3,  # 'ח'
        22: 2,  # 'ט'
        1: 3,  # 'י'
        25: 2,  # 'ך'
        15: 3,  # 'כ'
        4: 3,  # 'ל'
        11: 3,  # 'ם'
        6: 3,  # 'מ'
        23: 3,  # 'ן'
        12: 3,  # 'נ'
        19: 2,  # 'ס'
        13: 3,  # 'ע'
        26: 2,  # 'ף'
        18: 3,  # 'פ'
        27: 1,  # 'ץ'
        21: 2,  # 'צ'
        17: 3,  # 'ק'
        7: 3,  # 'ר'
        10: 3,  # 'ש'
        5: 3,  # 'ת'
        32: 1,  # '–'
        52: 1,  # '’'
        47: 0,  # '“'
        46: 0,  # '”'
        58: 0,  # '†'
        40: 2,  # '…'
    },
    32: {  # '–'
        50: 0,  # 'a'
        60: 0,  # 'c'
        61: 0,  # 'd'
        42: 0,  # 'e'
        53: 0,  # 'i'
        56: 0,  # 'l'
        54: 1,  # 'n'
        49: 0,  # 'o'
        51: 0,  # 'r'
        43: 0,  # 's'
        44: 0,  # 't'
        63: 0,  # 'u'
        34: 0,  # '\xa0'
        55: 0,  # '´'
        48: 0,  # '¼'
        39: 0,  # '½'
        57: 0,  # '¾'
        30: 0,  # 'ְ'
        59: 0,  # 'ֱ'
        41: 0,  # 'ֲ'
        33: 0,  # 'ִ'
        37: 0,  # 'ֵ'
        36: 0,  # 'ֶ'
        31: 0,  # 'ַ'
        29: 0,  # 'ָ'
        35: 0,  # 'ֹ'
        62: 0,  # 'ֻ'
        28: 0,  # 'ּ'
        38: 0,  # 'ׁ'
        45: 0,  # 'ׂ'
        9: 1,  # 'א'
        8: 1,  # 'ב'
        20: 1,  # 'ג'
        16: 1,  # 'ד'
        3: 1,  # 'ה'
        2: 1,  # 'ו'
        24: 0,  # 'ז'
        14: 1,  # 'ח'
        22: 0,  # 'ט'
        1: 1,  # 'י'
        25: 0,  # 'ך'
        15: 1,  # 'כ'
        4: 1,  # 'ל'
        11: 0,  # 'ם'
        6: 1,  # 'מ'
        23: 0,  # 'ן'
        12: 0,  # 'נ'
        19: 1,  # 'ס'
        13: 1,  # 'ע'
        26: 0,  # 'ף'
        18: 1,  # 'פ'
        27: 0,  # 'ץ'
        21: 1,  # 'צ'
        17: 0,  # 'ק'
        7: 1,  # 'ר'
        10: 1,  # 'ש'
        5: 1,  # 'ת'
        32: 0,  # '–'
        52: 0,  # '’'
        47: 0,  # '“'
        46: 0,  # '”'
        58: 0,  # '†'
        40: 0,  # '…'
    },
    52: {  # '’'
        50: 1,  # 'a'
        60: 0,  # 'c'
        61: 1,  # 'd'
        42: 1,  # 'e'
        53: 1,  # 'i'
        56: 1,  # 'l'
        54: 0,  # 'n'
        49: 0,  # 'o'
        51: 1,  # 'r'
        43: 2,  # 's'
        44: 2,  # 't'
        63: 1,  # 'u'
        34: 0,  # '\xa0'
        55: 0,  # '´'
        48: 0,  # '¼'
        39: 0,  # '½'
        57: 0,  # '¾'
        30: 0,  # 'ְ'
        59: 0,  # 'ֱ'
        41: 0,  # 'ֲ'
        33: 0,  # 'ִ'
        37: 0,  # 'ֵ'
        36: 0,  # 'ֶ'
        31: 0,  # 'ַ'
        29: 0,  # 'ָ'
        35: 0,  # 'ֹ'
        62: 0,  # 'ֻ'
        28: 0,  # 'ּ'
        38: 0,  # 'ׁ'
        45: 0,  # 'ׂ'
        9: 0,  # 'א'
        8: 0,  # 'ב'
        20: 0,  # 'ג'
        16: 0,  # 'ד'
        3: 0,  # 'ה'
        2: 1,  # 'ו'
        24: 0,  # 'ז'
        14: 0,  # 'ח'
        22: 0,  # 'ט'
        1: 0,  # 'י'
        25: 0,  # 'ך'
        15: 0,  # 'כ'
        4: 0,  # 'ל'
        11: 0,  # 'ם'
        6: 1,  # 'מ'
        23: 0,  # 'ן'
        12: 0,  # 'נ'
        19: 0,  # 'ס'
        13: 0,  # 'ע'
        26: 0,  # 'ף'
        18: 0,  # 'פ'
        27: 0,  # 'ץ'
        21: 0,  # 'צ'
        17: 0,  # 'ק'
        7: 0,  # 'ר'
        10: 0,  # 'ש'
        5: 1,  # 'ת'
        32: 0,  # '–'
        52: 0,  # '’'
        47: 0,  # '“'
        46: 0,  # '”'
        58: 0,  # '†'
        40: 0,  # '…'
    },
    47: {  # '“'
        50: 1,  # 'a'
        60: 1,  # 'c'
        61: 1,  # 'd'
        42: 1,  # 'e'
        53: 1,  # 'i'
        56: 1,  # 'l'
        54: 1,  # 'n'
        49: 1,  # 'o'
        51: 1,  # 'r'
        43: 1,  # 's'
        44: 1,  # 't'
        63: 1,  # 'u'
        34: 0,  # '\xa0'
        55: 0,  # '´'
        48: 0,  # '¼'
        39: 0,  # '½'
        57: 0,  # '¾'
        30: 0,  # 'ְ'
        59: 0,  # 'ֱ'
        41: 0,  # 'ֲ'
        33: 0,  # 'ִ'
        37: 0,  # 'ֵ'
        36: 0,  # 'ֶ'
        31: 0,  # 'ַ'
        29: 0,  # 'ָ'
        35: 0,  # 'ֹ'
        62: 0,  # 'ֻ'
        28: 0,  # 'ּ'
        38: 0,  # 'ׁ'
        45: 0,  # 'ׂ'
        9: 2,  # 'א'
        8: 1,  # 'ב'
        20: 1,  # 'ג'
        16: 1,  # 'ד'
        3: 1,  # 'ה'
        2: 1,  # 'ו'
        24: 1,  # 'ז'
        14: 1,  # 'ח'
        22: 1,  # 'ט'
        1: 1,  # 'י'
        25: 0,  # 'ך'
        15: 1,  # 'כ'
        4: 1,  # 'ל'
        11: 0,  # 'ם'
        6: 1,  # 'מ'
        23: 0,  # 'ן'
        12: 1,  # 'נ'
        19: 1,  # 'ס'
        13: 1,  # 'ע'
        26: 0,  # 'ף'
        18: 1,  # 'פ'
        27: 0,  # 'ץ'
        21: 1,  # 'צ'
        17: 1,  # 'ק'
        7: 1,  # 'ר'
        10: 1,  # 'ש'
        5: 1,  # 'ת'
        32: 0,  # '–'
        52: 0,  # '’'
        47: 0,  # '“'
        46: 0,  # '”'
        58: 0,  # '†'
        40: 0,  # '…'
    },
    46: {  # '”'
        50: 0,  # 'a'
        60: 0,  # 'c'
        61: 0,  # 'd'
        42: 0,  # 'e'
        53: 0,  # 'i'
        56: 0,  # 'l'
        54: 0,  # 'n'
        49: 0,  # 'o'
        51: 0,  # 'r'
        43: 0,  # 's'
        44: 1,  # 't'
        63: 0,  # 'u'
        34: 0,  # '\xa0'
        55: 0,  # '´'
        48: 0,  # '¼'
        39: 0,  # '½'
        57: 0,  # '¾'
        30: 0,  # 'ְ'
        59: 0,  # 'ֱ'
        41: 0,  # 'ֲ'
        33: 0,  # 'ִ'
        37: 0,  # 'ֵ'
        36: 0,  # 'ֶ'
        31: 0,  # 'ַ'
        29: 0,  # 'ָ'
        35: 0,  # 'ֹ'
        62: 0,  # 'ֻ'
        28: 0,  # 'ּ'
        38: 0,  # 'ׁ'
        45: 0,  # 'ׂ'
        9: 1,  # 'א'
        8: 1,  # 'ב'
        20: 1,  # 'ג'
        16: 0,  # 'ד'
        3: 0,  # 'ה'
        2: 0,  # 'ו'
        24: 0,  # 'ז'
        14: 0,  # 'ח'
        22: 0,  # 'ט'
        1: 1,  # 'י'
        25: 0,  # 'ך'
        15: 1,  # 'כ'
        4: 1,  # 'ל'
        11: 0,  # 'ם'
        6: 1,  # 'מ'
        23: 0,  # 'ן'
        12: 0,  # 'נ'
        19: 0,  # 'ס'
        13: 0,  # 'ע'
        26: 0,  # 'ף'
        18: 0,  # 'פ'
        27: 0,  # 'ץ'
        21: 1,  # 'צ'
        17: 0,  # 'ק'
        7: 1,  # 'ר'
        10: 0,  # 'ש'
        5: 0,  # 'ת'
        32: 0,  # '–'
        52: 0,  # '’'
        47: 0,  # '“'
        46: 0,  # '”'
        58: 0,  # '†'
        40: 0,  # '…'
    },
    58: {  # '†'
        50: 0,  # 'a'
        60: 0,  # 'c'
        61: 0,  # 'd'
        42: 0,  # 'e'
        53: 0,  # 'i'
        56: 0,  # 'l'
        54: 0,  # 'n'
        49: 0,  # 'o'
        51: 0,  # 'r'
        43: 0,  # 's'
        44: 0,  # 't'
        63: 0,  # 'u'
        34: 0,  # '\xa0'
        55: 0,  # '´'
        48: 0,  # '¼'
        39: 0,  # '½'
        57: 0,  # '¾'
        30: 0,  # 'ְ'
        59: 0,  # 'ֱ'
        41: 0,  # 'ֲ'
        33: 0,  # 'ִ'
        37: 0,  # 'ֵ'
        36: 0,  # 'ֶ'
        31: 0,  # 'ַ'
        29: 0,  # 'ָ'
        35: 0,  # 'ֹ'
        62: 0,  # 'ֻ'
        28: 0,  # 'ּ'
        38: 0,  # 'ׁ'
        45: 0,  # 'ׂ'
        9: 0,  # 'א'
        8: 0,  # 'ב'
        20: 0,  # 'ג'
        16: 0,  # 'ד'
        3: 0,  # 'ה'
        2: 0,  # 'ו'
        24: 0,  # 'ז'
        14: 0,  # 'ח'
        22: 0,  # 'ט'
        1: 0,  # 'י'
        25: 0,  # 'ך'
        15: 0,  # 'כ'
        4: 0,  # 'ל'
        11: 0,  # 'ם'
        6: 0,  # 'מ'
        23: 0,  # 'ן'
        12: 0,  # 'נ'
        19: 0,  # 'ס'
        13: 0,  # 'ע'
        26: 0,  # 'ף'
        18: 0,  # 'פ'
        27: 0,  # 'ץ'
        21: 0,  # 'צ'
        17: 0,  # 'ק'
        7: 0,  # 'ר'
        10: 0,  # 'ש'
        5: 0,  # 'ת'
        32: 0,  # '–'
        52: 0,  # '’'
        47: 0,  # '“'
        46: 0,  # '”'
        58: 2,  # '†'
        40: 0,  # '…'
    },
    40: {  # '…'
        50: 1,  # 'a'
        60: 1,  # 'c'
        61: 1,  # 'd'
        42: 1,  # 'e'
        53: 1,  # 'i'
        56: 0,  # 'l'
        54: 1,  # 'n'
        49: 0,  # 'o'
        51: 1,  # 'r'
        43: 1,  # 's'
        44: 1,  # 't'
        63: 0,  # 'u'
        34: 0,  # '\xa0'
        55: 0,  # '´'
        48: 0,  # '¼'
        39: 0,  # '½'
        57: 0,  # '¾'
        30: 0,  # 'ְ'
        59: 0,  # 'ֱ'
        41: 0,  # 'ֲ'
        33: 0,  # 'ִ'
        37: 0,  # 'ֵ'
        36: 0,  # 'ֶ'
        31: 0,  # 'ַ'
        29: 0,  # 'ָ'
        35: 0,  # 'ֹ'
        62: 0,  # 'ֻ'
        28: 0,  # 'ּ'
        38: 0,  # 'ׁ'
        45: 0,  # 'ׂ'
        9: 1,  # 'א'
        8: 0,  # 'ב'
        20: 0,  # 'ג'
        16: 0,  # 'ד'
        3: 1,  # 'ה'
        2: 1,  # 'ו'
        24: 1,  # 'ז'
        14: 0,  # 'ח'
        22: 0,  # 'ט'
        1: 1,  # 'י'
        25: 0,  # 'ך'
        15: 1,  # 'כ'
        4: 1,  # 'ל'
        11: 0,  # 'ם'
        6: 1,  # 'מ'
        23: 0,  # 'ן'
        12: 1,  # 'נ'
        19: 0,  # 'ס'
        13: 0,  # 'ע'
        26: 0,  # 'ף'
        18: 1,  # 'פ'
        27: 0,  # 'ץ'
        21: 0,  # 'צ'
        17: 0,  # 'ק'
        7: 1,  # 'ר'
        10: 1,  # 'ש'
        5: 1,  # 'ת'
        32: 0,  # '–'
        52: 0,  # '’'
        47: 0,  # '“'
        46: 1,  # '”'
        58: 0,  # '†'
        40: 2,  # '…'
    },
}

# 255: Undefined characters that did not exist in training text
# 254: Carriage/Return
# 253: symbol (punctuation) that does not belong to word
# 252: 0 - 9
# 251: Control characters

# Character Mapping Table(s):
WINDOWS_1255_HEBREW_CHAR_TO_ORDER = {
    0: 255,  # '\x00'
    1: 255,  # '\x01'
    2: 255,  # '\x02'
    3: 255,  # '\x03'
    4: 255,  # '\x04'
    5: 255,  # '\x05'
    6: 255,  # '\x06'
    7: 255,  # '\x07'
    8: 255,  # '\x08'
    9: 255,  # '\t'
    10: 254,  # '\n'
    11: 255,  # '\x0b'
    12: 255,  # '\x0c'
    13: 254,  # '\r'
    14: 255,  # '\x0e'
    15: 255,  # '\x0f'
    16: 255,  # '\x10'
    17: 255,  # '\x11'
    18: 255,  # '\x12'
    19: 255,  # '\x13'
    20: 255,  # '\x14'
    21: 255,  # '\x15'
    22: 255,  # '\x16'
    23: 255,  # '\x17'
    24: 255,  # '\x18'
    25: 255,  # '\x19'
    26: 255,  # '\x1a'
    27: 255,  # '\x1b'
    28: 255,  # '\x1c'
    29: 255,  # '\x1d'
    30: 255,  # '\x1e'
    31: 255,  # '\x1f'
    32: 253,  # ' '
    33: 253,  # '!'
    34: 253,  # '"'
    35: 253,  # '#'
    36: 253,  # '$'
    37: 253,  # '%'
    38: 253,  # '&'
    39: 253,  # "'"
    40: 253,  # '('
    41: 253,  # ')'
    42: 253,  # '*'
    43: 253,  # '+'
    44: 253,  # ','
    45: 253,  # '-'
    46: 253,  # '.'
    47: 253,  # '/'
    48: 252,  # '0'
    49: 252,  # '1'
    50: 252,  # '2'
    51: 252,  # '3'
    52: 252,  # '4'
    53: 252,  # '5'
    54: 252,  # '6'
    55: 252,  # '7'
    56: 252,  # '8'
    57: 252,  # '9'
    58: 253,  # ':'
    59: 253,  # ';'
    60: 253,  # '<'
    61: 253,  # '='
    62: 253,  # '>'
    63: 253,  # '?'
    64: 253,  # '@'
    65: 69,  # 'A'
    66: 91,  # 'B'
    67: 79,  # 'C'
    68: 80,  # 'D'
    69: 92,  # 'E'
    70: 89,  # 'F'
    71: 97,  # 'G'
    72: 90,  # 'H'
    73: 68,  # 'I'
    74: 111,  # 'J'
    75: 112,  # 'K'
    76: 82,  # 'L'
    77: 73,  # 'M'
    78: 95,  # 'N'
    79: 85,  # 'O'
    80: 78,  # 'P'
    81: 121,  # 'Q'
    82: 86,  # 'R'
    83: 71,  # 'S'
    84: 67,  # 'T'
    85: 102,  # 'U'
    86: 107,  # 'V'
    87: 84,  # 'W'
    88: 114,  # 'X'
    89: 103,  # 'Y'
    90: 115,  # 'Z'
    91: 253,  # '['
    92: 253,  # '\\'
    93: 253,  # ']'
    94: 253,  # '^'
    95: 253,  # '_'
    96: 253,  # '`'
    97: 50,  # 'a'
    98: 74,  # 'b'
    99: 60,  # 'c'
    100: 61,  # 'd'
    101: 42,  # 'e'
    102: 76,  # 'f'
    103: 70,  # 'g'
    104: 64,  # 'h'
    105: 53,  # 'i'
    106: 105,  # 'j'
    107: 93,  # 'k'
    108: 56,  # 'l'
    109: 65,  # 'm'
    110: 54,  # 'n'
    111: 49,  # 'o'
    112: 66,  # 'p'
    113: 110,  # 'q'
    114: 51,  # 'r'
    115: 43,  # 's'
    116: 44,  # 't'
    117: 63,  # 'u'
    118: 81,  # 'v'
    119: 77,  # 'w'
    120: 98,  # 'x'
    121: 75,  # 'y'
    122: 108,  # 'z'
    123: 253,  # '{'
    124: 253,  # '|'
    125: 253,  # '}'
    126: 253,  # '~'
    127: 253,  # '\x7f'
    128: 124,  # '€'
    129: 202,  # None
    130: 203,  # '‚'
    131: 204,  # 'ƒ'
    132: 205,  # '„'
    133: 40,  # '…'
    134: 58,  # '†'
    135: 206,  # '‡'
    136: 207,  # 'ˆ'
    137: 208,  # '‰'
    138: 209,  # None
    139: 210,  # '‹'
    140: 211,  # None
    141: 212,  # None
    142: 213,  # None
    143: 214,  # None
    144: 215,  # None
    145: 83,  # '‘'
    146: 52,  # '’'
    147: 47,  # '“'
    148: 46,  # '”'
    149: 72,  # '•'
    150: 32,  # '–'
    151: 94,  # '—'
    152: 216,  # '˜'
    153: 113,  # '™'
    154: 217,  # None
    155: 109,  # '›'
    156: 218,  # None
    157: 219,  # None
    158: 220,  # None
    159: 221,  # None
    160: 34,  # '\xa0'
    161: 116,  # '¡'
    162: 222,  # '¢'
    163: 118,  # '£'
    164: 100,  # '₪'
    165: 223,  # '¥'
    166: 224,  # '¦'
    167: 117,  # '§'
    168: 119,  # '¨'
    169: 104,  # '©'
    170: 125,  # '×'
    171: 225,  # '«'
    172: 226,  # '¬'
    173: 87,  # '\xad'
    174: 99,  # '®'
    175: 227,  # '¯'
    176: 106,  # '°'
    177: 122,  # '±'
    178: 123,  # '²'
    179: 228,  # '³'
    180: 55,  # '´'
    181: 229,  # 'µ'
    182: 230,  # '¶'
    183: 101,  # '·'
    184: 231,  # '¸'
    185: 232,  # '¹'
    186: 120,  # '÷'
    187: 233,  # '»'
    188: 48,  # '¼'
    189: 39,  # '½'
    190: 57,  # '¾'
    191: 234,  # '¿'
    192: 30,  # 'ְ'
    193: 59,  # 'ֱ'
    194: 41,  # 'ֲ'
    195: 88,  # 'ֳ'
    196: 33,  # 'ִ'
    197: 37,  # 'ֵ'
    198: 36,  # 'ֶ'
    199: 31,  # 'ַ'
    200: 29,  # 'ָ'
    201: 35,  # 'ֹ'
    202: 235,  # None
    203: 62,  # 'ֻ'
    204: 28,  # 'ּ'
    205: 236,  # 'ֽ'
    206: 126,  # '־'
    207: 237,  # 'ֿ'
    208: 238,  # '׀'
    209: 38,  # 'ׁ'
    210: 45,  # 'ׂ'
    211: 239,  # '׃'
    212: 240,  # 'װ'
    213: 241,  # 'ױ'
    214: 242,  # 'ײ'
    215: 243,  # '׳'
    216: 127,  # '״'
    217: 244,  # None
    218: 245,  # None
    219: 246,  # None
    220: 247,  # None
    221: 248,  # None
    222: 249,  # None
    223: 250,  # None
    224: 9,  # 'א'
    225: 8,  # 'ב'
    226: 20,  # 'ג'
    227: 16,  # 'ד'
    228: 3,  # 'ה'
    229: 2,  # 'ו'
    230: 24,  # 'ז'
    231: 14,  # 'ח'
    232: 22,  # 'ט'
    233: 1,  # 'י'
    234: 25,  # 'ך'
    235: 15,  # 'כ'
    236: 4,  # 'ל'
    237: 11,  # 'ם'
    238: 6,  # 'מ'
    239: 23,  # 'ן'
    240: 12,  # 'נ'
    241: 19,  # 'ס'
    242: 13,  # 'ע'
    243: 26,  # 'ף'
    244: 18,  # 'פ'
    245: 27,  # 'ץ'
    246: 21,  # 'צ'
    247: 17,  # 'ק'
    248: 7,  # 'ר'
    249: 10,  # 'ש'
    250: 5,  # 'ת'
    251: 251,  # None
    252: 252,  # None
    253: 128,  # '\u200e'
    254: 96,  # '\u200f'
    255: 253,  # None
}

WINDOWS_1255_HEBREW_MODEL = SingleByteCharSetModel(
    charset_name="windows-1255",
    language="Hebrew",
    char_to_order_map=WINDOWS_1255_HEBREW_CHAR_TO_ORDER,
    language_model=HEBREW_LANG_MODEL,
    typical_positive_ratio=0.984004,
    keep_ascii_letters=False,
    alphabet="אבגדהוזחטיךכלםמןנסעףפץצקרשתװױײ",
)
