set(CMAKE_SYSTEM_NAME                   Generic)
set(CMAKE_SYSTEM_PROCESSOR              riscv)
set(CMAKE_TRY_COMPILE_TARGET_TYPE       STATIC_LIBRARY)

if(WIN32)
  set(EXE_SUFFIX ".exe")
else()
  set(EXE_SUFFIX "")
endif()

if(DEFINED ENV{RISCV_GCC_DIR})
  set(TOOLCHAIN_DIR "$ENV{RISCV_GCC_DIR}/bin/")
elseif(WIN32)
  set(TOOLCHAIN_DIR "")
elseif(APPLE)
  set(TOOLCHAIN_DIR "")
else()
  set(TOOLCHAIN_DIR "")
endif()

if(DEFINED ENV{POST_BUILD_EXE})
  set(POST_BUILD_EXE "$ENV{POST_BUILD_EXE}")
elseif(WIN32)
  set(POST_BUILD_EXE "{{POST_BUILD_EXE_WIN | replace('\\', '/')}}")
elseif(APPLE)
  set(POST_BUILD_EXE "{{POST_BUILD_EXE_OSX | replace('\\', '/')}}")
else()
  set(POST_BUILD_EXE "{{POST_BUILD_EXE_LINUX | replace('\\', '/')}}")
endif()

if(DEFINED ENV{NINJA_EXE_PATH})
  set(CMAKE_MAKE_PROGRAM "$ENV{NINJA_EXE_PATH}" CACHE FILEPATH "" FORCE)
elseif(WIN32)
  set(NINJA_RUNTIME_PATH "{{NINJA_EXE_PATH_WIN | replace('\\', '/')}}")
elseif(APPLE)
  set(NINJA_RUNTIME_PATH "{{NINJA_EXE_PATH_OSX | replace('\\', '/')}}")
else()
  set(NINJA_RUNTIME_PATH "{{NINJA_EXE_PATH_LINUX | replace('\\', '/')}}")
endif()
# Use default lookup mechanisms if the OS specific values are not set above
if (NINJA_RUNTIME_PATH)
	set(CMAKE_MAKE_PROGRAM ${NINJA_RUNTIME_PATH} CACHE FILEPATH "" FORCE)
endif()

set(TARGET_TRIPLET "riscv32-unknown-elf-")
set(CMAKE_C_COMPILER    ${TOOLCHAIN_DIR}${TARGET_TRIPLET}gcc${EXE_SUFFIX})
set(CMAKE_CXX_COMPILER  ${TOOLCHAIN_DIR}${TARGET_TRIPLET}g++${EXE_SUFFIX})
set(CMAKE_ASM_COMPILER  ${TOOLCHAIN_DIR}${TARGET_TRIPLET}gcc${EXE_SUFFIX})
set(CMAKE_LINKER        ${TOOLCHAIN_DIR}${TARGET_TRIPLET}gcc${EXE_SUFFIX})
set(CMAKE_AR            ${TOOLCHAIN_DIR}${TARGET_TRIPLET}ar${EXE_SUFFIX})
set(CMAKE_SIZE_UTIL     ${TOOLCHAIN_DIR}${TARGET_TRIPLET}size${EXE_SUFFIX})
set(CMAKE_STRIP         ${TOOLCHAIN_DIR}${TARGET_TRIPLET}strip${EXE_SUFFIX})
set(CMAKE_OBJCOPY       ${TOOLCHAIN_DIR}${TARGET_TRIPLET}objcopy${EXE_SUFFIX})
set(CMAKE_OBJDUMP       ${TOOLCHAIN_DIR}${TARGET_TRIPLET}objdump${EXE_SUFFIX})
set(CMAKE_NM_UTIL       ${TOOLCHAIN_DIR}${TARGET_TRIPLET}gcc-nm${EXE_SUFFIX})
set(CMAKE_RANLIB        ${TOOLCHAIN_DIR}${TARGET_TRIPLET}gcc-ranlib${EXE_SUFFIX})
set(CMAKE_GCOV          ${TOOLCHAIN_DIR}${TARGET_TRIPLET}gcov${EXE_SUFFIX})

set(OBJCOPY_SREC_CMD    "-O;srec")
set(OBJCOPY_IHEX_CMD    "-O;ihex")
set(OBJCOPY_BIN_CMD     "-O;binary")

set(CMAKE_C_STANDARD_REQUIRED   OFF)
set(CMAKE_CXX_STANDARD_REQUIRED OFF)
set(CMAKE_C_EXTENSIONS          OFF)

set(CMAKE_C_FLAGS_RELEASE               "" CACHE STRING "")
set(CMAKE_CXX_FLAGS_RELEASE             "" CACHE STRING "")

# Response file support
SET(CMAKE_C_USE_RESPONSE_FILE_FOR_OBJECTS   1)
SET(CMAKE_CXX_USE_RESPONSE_FILE_FOR_OBJECTS 1)
SET(CMAKE_C_RESPONSE_FILE_LINK_FLAG         "@")
SET(CMAKE_CXX_RESPONSE_FILE_LINK_FLAG       "@")
SET(CMAKE_NINJA_FORCE_RESPONSE_FILE         1 CACHE INTERNAL "")

set(CMAKE_FIND_ROOT_PATH_MODE_PROGRAM   NEVER)
set(CMAKE_FIND_ROOT_PATH_MODE_LIBRARY   ONLY)
set(CMAKE_FIND_ROOT_PATH_MODE_INCLUDE   ONLY)

set(CMAKE_EXECUTABLE_SUFFIX     .out)
set(CMAKE_EXECUTABLE_SUFFIX_C   .out)
set(CMAKE_EXECUTABLE_SUFFIX_CXX .out)
