/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.java.internal.utils.files.monitor;

import com.silabs.java.internal.utils.files.monitor.IDirectoryMonitorImpl;
import com.silabs.java.internal.utils.files.monitor.SingleDirectoryMonitor;
import com.silabs.java.utils.files.monitor.IDirectoryNotifier;
import com.silabs.java.utils.log.Log;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;

final class PollingDirectoryMonitorImpl
implements IDirectoryMonitorImpl {
    public static final int POLLING_INTERVAL = 250;
    private Path directory;
    private boolean stopped = false;
    private final boolean checkModified;
    private IDirectoryNotifier notifier;
    private Thread runner;
    private Map<String, Long> oldFilesMap;

    public PollingDirectoryMonitorImpl(boolean checkModified) {
        this.checkModified = checkModified;
    }

    @Override
    public void init(Path directory, IDirectoryNotifier notifier) throws IOException {
        if (!directory.toFile().isDirectory()) {
            throw new IOException("Not a directory: " + directory.toString());
        }
        this.notifier = notifier;
        this.directory = directory;
        this.oldFilesMap = ((Stream)Stream.of(this.directory.toFile().listFiles()).parallel()).collect(Collectors.toMap(File::getName, this::getModifiedTime));
    }

    private void compare(File[] newFiles) {
        HashMap<String, Long> newMap = new HashMap<String, Long>(newFiles.length);
        for (File file : newFiles) {
            long newModified = this.getModifiedTime(file);
            String newFileName = file.getName();
            newMap.put(newFileName, newModified);
            Long oldModified = this.oldFilesMap.remove(newFileName);
            if (oldModified == null) {
                this.notifier.fileEvent(IDirectoryNotifier.TYPE.CREATED, file.toPath());
                continue;
            }
            if (oldModified == newModified) continue;
            this.notifier.fileEvent(IDirectoryNotifier.TYPE.CHANGED, file.toPath());
        }
        Map<String, Long> iterMap = this.oldFilesMap;
        this.oldFilesMap = newMap;
        iterMap.keySet().forEach(f -> this.notifier.fileEvent(IDirectoryNotifier.TYPE.DELETED, this.directory.resolve((String)f)));
    }

    private long getModifiedTime(File file) {
        long newModified = 0L;
        if (this.checkModified) {
            try {
                BasicFileAttributes attributes = Files.readAttributes(file.toPath(), BasicFileAttributes.class, new LinkOption[0]);
                if (!attributes.isDirectory()) {
                    newModified = attributes.lastModifiedTime().toMillis();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return newModified;
    }

    @Override
    public void run() {
        this.runner = Thread.currentThread();
        while (!this.stopped) {
            try {
                Thread.sleep(250L);
            }
            catch (InterruptedException interruptedException) {
            }
            catch (Exception exception) {
                // empty catch block
            }
            File[] files = this.directory.toFile().listFiles();
            if (files == null) {
                this.oldFilesMap.keySet().forEach(f -> this.notifier.fileEvent(IDirectoryNotifier.TYPE.DELETED, this.directory.resolve((String)f)));
                this.notifier.fileEvent(IDirectoryNotifier.TYPE.DELETED, this.directory);
                break;
            }
            this.compare(files);
        }
        this.runner = null;
        ((SingleDirectoryMonitor)this.notifier).monitorShutdown();
    }

    public void pollNow() {
        try {
            Thread local_runner = this.runner;
            if (local_runner != null) {
                local_runner.interrupt();
            }
        }
        catch (Throwable t) {
            Log.error(t);
        }
    }

    @Override
    public void stop() {
        this.stopped = true;
        this.pollNow();
    }

    @Override
    public Thread runningThread() {
        return this.runner;
    }
}

