/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.java.utils;

import java.util.Iterator;
import java.util.NoSuchElementException;

public class CircularBuffer<T>
implements Iterable<T> {
    private Object[] buffer;
    private int initialCapacity;
    private int first;
    private int last = -1;
    private int size;
    private int maxSize = Integer.MAX_VALUE;

    public CircularBuffer(int initialCapacity) {
        this.initialCapacity = initialCapacity;
        this.buffer = new Object[initialCapacity];
    }

    public void setMaxSize(int maxSize) {
        this.maxSize = maxSize;
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    public int size() {
        return this.size;
    }

    public T add(T object) {
        Object replaced = null;
        if (this.size == this.buffer.length && this.buffer.length < this.maxSize) {
            this.growBuffer();
        }
        this.increment();
        replaced = this.buffer[this.last];
        this.buffer[this.last] = object;
        return (T)replaced;
    }

    private boolean increment() {
        this.size = Math.min(this.size + 1, this.buffer.length);
        this.last = this.getIncrementedIndex(this.last);
        if (this.last == this.first && this.size == this.buffer.length) {
            this.first = this.getIncrementedIndex(this.first);
            return false;
        }
        return true;
    }

    private int getIncrementedIndex(int value) {
        if (value + 1 == this.buffer.length) {
            return 0;
        }
        return value + 1;
    }

    private void growBuffer() {
        int newSize = Math.min(2 * this.buffer.length, this.maxSize);
        Object[] oldBuffer = this.buffer;
        this.buffer = new Object[newSize];
        if (this.first <= this.last) {
            System.arraycopy(oldBuffer, this.first, this.buffer, 0, this.size);
        } else {
            int firstPartLen = oldBuffer.length - this.first;
            System.arraycopy(oldBuffer, this.first, this.buffer, 0, firstPartLen);
            System.arraycopy(oldBuffer, 0, this.buffer, firstPartLen + 1, this.last + 1);
        }
        this.first = 0;
        this.last = this.size - 1;
    }

    public T get(int index) {
        if (index >= this.size) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        if (this.first + index >= this.buffer.length) {
            return (T)this.buffer[index - (this.buffer.length - this.first)];
        }
        return (T)this.buffer[this.first + index];
    }

    public void clear() {
        this.buffer = new Object[this.initialCapacity];
        this.first = 0;
        this.last = -1;
        this.size = 0;
    }

    @Override
    public Iterator<T> iterator() {
        return new Iter();
    }

    public class Iter
    implements Iterator<T> {
        private int cursor;

        @Override
        public boolean hasNext() {
            return this.cursor != CircularBuffer.this.size();
        }

        @Override
        public T next() {
            try {
                Object next = CircularBuffer.this.get(this.cursor++);
                return next;
            }
            catch (IndexOutOfBoundsException e) {
                throw new NoSuchElementException();
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

