/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.java.utils;

import com.silabs.java.utils.OSUtils;
import com.silabs.java.utils.TextUtils;
import com.silabs.java.utils.variables.EnvironmentVariableUtils;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Locale;

public final class HostUtils {
    private static final String PATH = "PATH";
    private static final String LD_LIBRARY_PATH = "LD_LIBRARY_PATH";
    private static final String DYLD_LIBRARY_PATH = "DYLD_LIBRARY_PATH";
    private static String newline = null;
    private static boolean isWindows;
    private static boolean isWindows64;
    private static boolean isOSX;
    private static Path tmpPath;
    private static boolean is64bit;
    private static boolean isX86_64;

    protected HostUtils() {
    }

    public static boolean isWindows() {
        return isWindows;
    }

    public static boolean isOSX() {
        return isOSX;
    }

    public static boolean isLinux() {
        return !isWindows && !isOSX;
    }

    public static boolean is32Bit() {
        return !is64bit;
    }

    public static boolean hostIs32Bit() {
        if (isWindows64) {
            return false;
        }
        return HostUtils.is32Bit();
    }

    public static boolean is64Bit() {
        return is64bit;
    }

    public static boolean hostIs64Bit() {
        if (isWindows64) {
            return true;
        }
        return HostUtils.is64Bit();
    }

    public static boolean isX86_64() {
        return isX86_64;
    }

    public static boolean isArm64() {
        String osArch = System.getProperty("os.arch");
        if (TextUtils.hasContent(osArch)) {
            return "arm64".equals(osArch.toLowerCase(Locale.ROOT));
        }
        return false;
    }

    public static String getNewline() {
        return newline;
    }

    public static Path getTemporaryPath() {
        if (tmpPath == null) {
            if (HostUtils.isWindows()) {
                String tmp = System.getProperty("java.io.tmpdir");
                if (tmp == null) {
                    tmp = EnvironmentVariableUtils.getDirectoryValue("TEMP");
                }
                if (tmp == null) {
                    tmp = EnvironmentVariableUtils.getDirectoryValue("TMP");
                }
                if (tmp == null) {
                    tmp = "c:/temp";
                }
                tmpPath = Paths.get(tmp, new String[0]);
                tmpPath.toFile().mkdirs();
            } else {
                tmpPath = Paths.get("/tmp", new String[0]);
            }
        }
        return tmpPath;
    }

    public static File createExectuablePathForGUIApp(File applicationDir, String executableBaseName, String ... osXApplicationBaseName) {
        return HostUtils.createExecutablePathForGUIApp(applicationDir, executableBaseName, "Contents/MacOS", osXApplicationBaseName);
    }

    public static File createExecutablePathForGUIApp(File appDir, String executableName, String innerPath, String ... osXApplicationBaseName) {
        if (HostUtils.isOSX()) {
            String osXAppName = HostUtils.createExecutableNameForGUIApp(osXApplicationBaseName.length > 0 ? osXApplicationBaseName[0] : executableName);
            return Paths.get(appDir.getPath(), osXAppName, innerPath, executableName).toFile();
        }
        return new File(appDir, HostUtils.createExecutableNameForGUIApp(executableName));
    }

    public static File getStudioExecutablePathForGUIApp(File appDir, String executableName) {
        if (HostUtils.isOSX()) {
            return Paths.get(appDir.getParent(), "MacOS", executableName).toFile();
        }
        return new File(appDir, HostUtils.createExecutableNameForGUIApp(executableName));
    }

    public static String createExecutableNameForGUIApp(String filebase) {
        if (HostUtils.isWindows()) {
            return filebase + ".exe";
        }
        if (isOSX) {
            return filebase + ".app";
        }
        return filebase;
    }

    public static String createExecutableName(String filebase) {
        if (HostUtils.isWindows()) {
            return filebase + ".exe";
        }
        return filebase;
    }

    public static String createSharedObjectName(String filebase, boolean isPlugin) {
        if (HostUtils.isWindows()) {
            return filebase + ".dll";
        }
        return (!isPlugin ? "lib" : "") + filebase + (HostUtils.isOSX() ? ".dylib" : ".so");
    }

    public static String createSharedObjectName(String filebase) {
        return HostUtils.createSharedObjectName(filebase, false);
    }

    public static String getExecutablePath() {
        if (HostUtils.isWindows()) {
            return "os/win32/x86";
        }
        if (HostUtils.isOSX()) {
            return "os/macosx/x86_64";
        }
        return "os/linux/x86";
    }

    public static String getLibraryPathVar() {
        if (HostUtils.isWindows()) {
            return PATH;
        }
        if (HostUtils.isOSX()) {
            return DYLD_LIBRARY_PATH;
        }
        return LD_LIBRARY_PATH;
    }

    public static String userHome() {
        return System.getProperty("user.home");
    }

    public static File userHomeFile() {
        return new File(HostUtils.userHome());
    }

    public static Path getUserAppDataLocation() {
        String initPath;
        if (isWindows) {
            initPath = EnvironmentVariableUtils.getDirectoryValue("APPDATA");
            if (initPath == null) {
                initPath = HostUtils.getTemporaryPath().toString();
            }
        } else {
            initPath = HostUtils.userHome();
        }
        if (initPath == null) {
            return null;
        }
        Path path = isWindows ? Paths.get(initPath, new String[0]) : (isOSX ? Paths.get(initPath, new String[0]).resolve("Library").resolve("Application Support") : Paths.get(initPath, new String[0]).resolve(".config"));
        if (!(path = path.resolve("SimplicityStudio").resolve("5")).toFile().exists()) {
            path.toFile().mkdirs();
        }
        return path;
    }

    public static String userName() {
        return System.getProperty("user.name");
    }

    @Deprecated
    public static boolean isProcessRunning(long processId) {
        return OSUtils.isProcessRunning(processId);
    }

    public static boolean isEnvVarSet(String varName, String expected) {
        String val = System.getenv(varName);
        if (val == null) {
            return false;
        }
        return val.toLowerCase().compareTo(expected.toLowerCase()) == 0;
    }

    public static boolean supportsDisplayTests() {
        return !HostUtils.isEnvVarSet("DISABLE_UI_TESTS", "true");
    }

    static {
        String osName = System.getProperty("os.name");
        String osArch = System.getProperty("os.arch").toLowerCase(Locale.ROOT);
        String osgiArch = System.getProperty("osgi.arch");
        isWindows = osName.contains("Windows");
        isOSX = "Mac OS X".equals(osName);
        newline = isWindows ? "\r\n" : "\n";
        isWindows64 = false;
        if (isWindows && EnvironmentVariableUtils.getValue("ProgramFiles(x86)") != null) {
            isWindows64 = true;
        }
        is64bit = "x64".equals(osArch) || "x86_64".equals(osArch) || "amd64".equals(osArch) || "ia64".equals(osArch) || "arm64".equals(osArch) || osArch.contains("64");
        isX86_64 = osgiArch != null && osgiArch.length() > 0 && "x86_64".equals(osgiArch.toLowerCase(Locale.ROOT)) || osArch != null && osArch.length() > 0 && "amd64".equals(osArch.toLowerCase(Locale.ROOT));
    }
}

