/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.java.utils;

import com.silabs.java.utils.HostUtils;
import com.silabs.java.utils.log.Log;
import com.silabs.java.utils.variables.EnvironmentVariableUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.attribute.PosixFilePermission;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.Set;

public class OSUtils {
    private static final List<String> arch32 = Arrays.asList("x86", "x86_32", "i386", "ppc", "sparc");
    private static String is64Windows = EnvironmentVariableUtils.getValue("ProgramFiles(x86)");
    private static Properties systemProperties = System.getProperties();
    private static BitSize BIT_SIZE = OSUtils.computeBitSize();

    public static BitSize osArchitectureBitSize() {
        return BIT_SIZE;
    }

    private static BitSize computeBitSize() {
        String osName = systemProperties.getProperty("os.name");
        assert (osName != null) : "System 'os.name' property is not set";
        if (osName.contains("Mac OS X")) {
            return BitSize.S_64;
        }
        if (osName.contains("Windows")) {
            return is64Windows != null ? BitSize.S_64 : BitSize.S_32;
        }
        String arch = systemProperties.getProperty("os.arch");
        assert (arch != null) : "System 'os.arch' property is not set";
        return arch32.contains(arch) ? BitSize.S_32 : BitSize.S_64;
    }

    public static void test_setIs64Windows(String environmentVariable) {
        is64Windows = environmentVariable;
    }

    public static void test_setSystemProperties(Properties alternative) {
        systemProperties = alternative;
    }

    public static void test_recomputeBitSize() {
        BIT_SIZE = OSUtils.computeBitSize();
    }

    public static boolean isProcessRunning(long processId) {
        if (HostUtils.isWindows()) {
            String CMD = "tasklist /FI";
            String ARG = "\"PID eq " + processId + "\"";
            try {
                Process process = Runtime.getRuntime().exec(new String[]{"cmd", "/c", CMD + " " + ARG});
                BufferedReader stdout = new BufferedReader(new InputStreamReader(process.getInputStream()));
                String line = null;
                while ((line = stdout.readLine()) != null) {
                    if (!line.contains(" " + processId + " ")) continue;
                    return true;
                }
                return false;
            }
            catch (Exception ex) {
                return false;
            }
        }
        if (processId == 0L) {
            return false;
        }
        String CMD = "/bin/kill";
        String ARG = "-0 " + processId;
        try {
            int retValue = Runtime.getRuntime().exec(CMD + " " + ARG).waitFor();
            return retValue == 0;
        }
        catch (IOException ioe) {
            return false;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return false;
        }
    }

    public static void setExecutableFlagsIfNeeded(File f) {
        if (f == null) {
            return;
        }
        if (HostUtils.isWindows()) {
            return;
        }
        String[] executables = new String[]{".sh", ".run", ".osx", ".out", ".ksh", ".csh", ".bsh", ".bin", ".app", ".action"};
        PosixFilePermission[] permissions = new PosixFilePermission[]{PosixFilePermission.GROUP_EXECUTE, PosixFilePermission.OTHERS_EXECUTE, PosixFilePermission.OWNER_EXECUTE};
        String n = f.getName();
        boolean needsToHaveFlagSet = false;
        for (String suffix : executables) {
            if (!n.toLowerCase(Locale.ROOT).endsWith(suffix.toLowerCase(Locale.ROOT))) continue;
            needsToHaveFlagSet = true;
            break;
        }
        if (needsToHaveFlagSet) {
            try {
                Set<PosixFilePermission> set = Files.getPosixFilePermissions(f.toPath(), new LinkOption[0]);
                for (PosixFilePermission p : permissions) {
                    if (set.contains((Object)p)) continue;
                    set.add(p);
                }
                Files.setPosixFilePermissions(f.toPath(), set);
            }
            catch (Throwable t) {
                Log.warning("Could not set executable flag: " + f.getAbsolutePath());
            }
        }
    }

    public static enum BitSize {
        S_32(32),
        S_64(64);

        private final int bits;

        private BitSize(int bits) {
            this.bits = bits;
        }

        public int bits() {
            return this.bits;
        }
    }
}

