/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.java.utils;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;

public class ReflectionUtil {
    public static Class<?>[] getAllInterfaces(Class<?> klass) {
        LinkedHashSet intfColl = new LinkedHashSet();
        ReflectionUtil.gatherAllInterfaces(klass, intfColl);
        return intfColl.toArray(new Class[intfColl.size()]);
    }

    private static void gatherAllInterfaces(Class<?> klass, Collection<Class<?>> intfsColl) {
        for (Class<?> cls = klass; cls != null; cls = cls.getSuperclass()) {
            Class<?>[] intfs = cls.getInterfaces();
            intfsColl.addAll(Arrays.asList(intfs));
            for (Class<?> intf : intfs) {
                ReflectionUtil.gatherAllInterfaces(intf, intfsColl);
            }
        }
    }

    public static boolean hasAnnotation(Class<?> klass, Annotation[] annotations) {
        for (Annotation ann : annotations) {
            if (!klass.isAssignableFrom(ann.annotationType())) continue;
            return true;
        }
        return false;
    }

    public static <T extends Annotation> T getAnnotation(Class<?> clazz, String method, Class<T> annotation) {
        for (Method m : clazz.getMethods()) {
            T ann;
            if (!m.getName().equals(method) || (ann = m.getAnnotation(annotation)) == null) continue;
            return ann;
        }
        return null;
    }
}

